/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import pt.efacec.smartlighting.common.core.entity.User;

public class Context {
    private User user;
    private String language;
    private String country;
    private int depth = 0;
    private String sessionId;
    private static final ThreadLocal<Context> store = new ThreadLocal<Context>(){

        @Override
        protected Context initialValue() {
            return new Context();
        }
    };
    private Map<Object, Object> metadata;

    public <T> void setAttribute(AttributeKey<T> key, T value) {
        if (this.metadata == null) {
            this.metadata = new HashMap<Object, Object>();
        }
        this.metadata.put(key, value);
    }

    public <T> T getAttribute(AttributeKey<T> key) {
        if (this.metadata == null) {
            return null;
        }
        return (T)this.metadata.get(key);
    }

    public <T> void removeAttribute(AttributeKey<T> key) {
        if (this.metadata != null) {
            this.metadata.remove(key);
        }
    }

    public static void set(Context context) {
        store.set(context);
    }

    public static Context get() {
        return store.get();
    }

    public Context() {
    }

    public Context(Context original) {
        this.user = original.getUser();
        this.language = original.getLanguage();
        this.country = original.getCountry();
    }

    public User getUser() {
        if (this.user != null) {
            User u = new User(this.user);
            u.setId(this.user.getId());
            return u;
        }
        return null;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public int getDepth() {
        return this.depth;
    }

    public int incDepth() {
        ++this.depth;
        return this.depth;
    }

    public int decDepth() {
        --this.depth;
        return this.depth;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getSessionId() {
        if (this.sessionId == null) {
            this.sessionId = UUID.randomUUID().toString();
        }
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void clearState() {
        this.user = null;
        this.language = null;
        this.country = null;
        this.sessionId = null;
        this.metadata = null;
    }

    public static abstract class AttributeKey<T> {
    }
}

