/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.tclouds;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.GetFuture;
import net.spy.memcached.internal.OperationFuture;
import org.apache.log4j.Logger;
import pt.efacec.smartlighting.common.tclouds.ICache;

public class MemcacheDCache
implements ICache {
    private static final Logger log = Logger.getLogger(MemcacheDCache.class);
    private static final int TIMEOUT = 5;
    private MemcachedClient client = null;
    private String servers;

    public void setServers(String servers) {
        this.servers = servers;
    }

    public void init() {
        if (this.client != null) {
            this.client.shutdown();
        }
        try {
            this.client = new MemcachedClient(AddrUtil.getAddresses((String)this.servers));
        }
        catch (IOException e) {
            log.error((Object)"Unable to define Memcached server(s)", (Throwable)e);
        }
    }

    @Override
    public void put(String key, Serializable o, int minutes) {
        if (this.client != null) {
            OperationFuture op = this.client.set(key, 60 * minutes, (Object)o);
            try {
                op.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                op.cancel(false);
            }
        }
    }

    @Override
    public void remove(String key) {
        if (this.client != null) {
            OperationFuture op = this.client.delete(key);
            try {
                op.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                op.cancel(false);
            }
        }
    }

    @Override
    public <T extends Serializable> T get(String key, int minutes, Callable<T> callable) {
        Serializable obj = null;
        if (this.client != null && (obj = (Serializable)this.getIfPresent(key)) == null) {
            try {
                obj = (Serializable)callable.call();
            }
            catch (Exception e) {
                log.error((Object)"Unable to compute cache value", (Throwable)e);
            }
            this.put(key, obj, minutes);
        }
        return (T)obj;
    }

    @Override
    public <T extends Serializable> T getIfPresent(String key) {
        Object myObj = null;
        if (this.client != null) {
            GetFuture f = this.client.asyncGet(key);
            try {
                myObj = f.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                f.cancel(false);
            }
        }
        return (T)((Serializable)myObj);
    }
}

