/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.tclouds;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import pt.efacec.smartlighting.common.tclouds.ICache;

public class CacheMock
implements ICache {
    private static final long WAIT_PERIOD = 60000L;
    private Map<String, TimeHolder> cache = new ConcurrentHashMap<String, TimeHolder>();
    private Thread janitor = new Thread(){

        @Override
        public void run() {
            try {
                block2: while (true) {
                    Thread.sleep(60000L);
                    long now = System.currentTimeMillis();
                    Iterator it = CacheMock.this.cache.entrySet().iterator();
                    while (true) {
                        if (!it.hasNext()) continue block2;
                        Map.Entry entry = it.next();
                        if (now <= ((TimeHolder)entry.getValue()).getWhen()) continue;
                        it.remove();
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    };

    public CacheMock() {
        this.janitor.start();
    }

    @Override
    public void put(String key, Serializable o, int minutes) {
        this.cache.put(key, new TimeHolder(o, System.currentTimeMillis() + (long)minutes * 60000L));
    }

    @Override
    public void remove(String key) {
        this.cache.remove(key);
    }

    @Override
    public <T extends Serializable> T getIfPresent(String key) {
        TimeHolder th = this.cache.get(key);
        if (th != null) {
            return (T)th.getObject();
        }
        return null;
    }

    @Override
    public <T extends Serializable> T get(String key, int minutes, Callable<T> callable) {
        TimeHolder th = this.cache.get(key);
        Serializable ser = null;
        if (th != null) {
            ser = th.getObject();
        } else if (callable != null) {
            try {
                ser = (Serializable)callable.call();
                this.put(key, ser, minutes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (T)ser;
    }

    class TimeHolder {
        private Serializable object;
        private long when;

        public TimeHolder(Serializable object, long when) {
            this.object = object;
            this.when = when;
        }

        public Serializable getObject() {
            return this.object;
        }

        public void setObject(Serializable object) {
            this.object = object;
        }

        public long getWhen() {
            return this.when;
        }

        public void setWhen(long when) {
            this.when = when;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TimeHolder [object=");
            builder.append(this.object);
            builder.append(", when=");
            builder.append(this.when);
            builder.append("]");
            return builder.toString();
        }
    }
}

