/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.mail;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import pt.efacec.smartlighting.common.mail.IMailClient;

public class SmtpClient
implements IMailClient {
    private String host = "127.0.0.1";
    private int port = 25;
    private boolean useAuthentication = false;
    private String username = "";
    private String password = "";
    private String domain = "";
    private Boolean enableSSL = false;
    private String defaultFromAddress = "";

    @Override
    public void sendMessage(String from, String to, String subject, String body) throws MessagingException {
        if (from == null) {
            from = this.getDefaultFromAddress();
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", this.host);
        Authenticator auth = null;
        if (this.useAuthentication) {
            props.put("mail.smtp.auth", "true");
            if (this.enableSSL.booleanValue()) {
                props.put("mail.smtp.socketFactory.port", (Object)this.port);
                props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                props.put("mail.smtp.port", (Object)this.port);
            }
            auth = this.domain.equals("") ? new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SmtpClient.this.username, SmtpClient.this.password);
                }
            } : new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    String usernameDomain = String.format("%s\\%s", SmtpClient.this.domain, SmtpClient.this.username);
                    return new PasswordAuthentication(usernameDomain, SmtpClient.this.password);
                }
            };
        }
        Session session = Session.getDefaultInstance((Properties)props, auth);
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(from));
        message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
        message.setSubject(subject);
        message.setText(body);
        Transport.send((Message)message);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isUseAuthentication() {
        return this.useAuthentication;
    }

    public void setUseAuthentication(boolean useAuthentication) {
        this.useAuthentication = useAuthentication;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Boolean getEnableSSL() {
        return this.enableSSL;
    }

    public void setEnableSSL(Boolean enableSSL) {
        this.enableSSL = enableSSL;
    }

    public String getDefaultFromAddress() {
        return this.defaultFromAddress;
    }

    public void setDefaultFromAddress(String defaultFromAddress) {
        this.defaultFromAddress = defaultFromAddress;
    }
}

