/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;

public class AuditLog
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROFILE_REMOVE = "PROFILE_REMOVE";
    public static final String PROFILE_ADD = "PROFILE_ADD";
    public static final String PROFILE_MODIFY = "PROFILE_MODIFY";
    public static final String PROFILE_UNASSIGN = "PROFILE_UNASSIGN";
    public static final String PROFILE_ASSIGN = "PROFILE_ASSIGN";
    public static final String SPECIAL_DAY_PROFILE_REMOVE = "SPECIAL_DAY_PROFILE_REMOVE";
    public static final String SPECIAL_DAY_DTC_REMOVE = "SPECIAL_DAY_DTC_REMOVE";
    public static final String SPECIAL_DAY_PROFILE_ADD = "SPECIAL_DAY_PROFILE_ADD";
    public static final String SPECIAL_DAY_DTC_ADD = "SPECIAL_DAY_DTC_ADD";
    public static final String SPECIAL_DAY_PROFILE_MODIFY = "SPECIAL_DAY_PROFILE_MODIFY";
    public static final String SPECIAL_DAY_DTC_MODIFY = "SPECIAL_DAY_DTC_MODIFY";
    public static final String CLIENT_UNASSIGN = "CLIENT_UNASSIGN";
    public static final String CLIENT_ASSIGN = "CLIENT_ASSIGN";
    public static final String CLIENT_REMOVE = "CLIENT_REMOVE";
    public static final String CLIENT_ADD = "CLIENT_ADD";
    public static final String CLIENT_MODIFY = "CLIENT_MODIFY";
    public static final String SCHEDULE_TEMPLATE_REMOVE = "SCHEDULE_TEMPLATE_REMOVE";
    public static final String SCHEDULE_REMOVE = "SCHEDULE_REMOVE";
    public static final String SCHEDULE_TEMPLATE_ADD = "SCHEDULE_TEMPLATE_ADD";
    public static final String SCHEDULE_ADD = "SCHEDULE_ADD";
    public static final String SCHEDULE_MODIFY = "SCHEDULE_MODIFY";
    public static final String SCHEDULE_PERIOD_MODIFY = "SCHEDULE_PERIOD_MODIFY";
    public static final String SCHEDULE_TEMPLATE_MODIFY = "SCHEDULE_TEMPLATE_MODIFY";
    public static final String SCHEDULE_TEMPLATE_PERIOD_MODIFY = "SCHEDULE_TEMPLATE_PERIOD_MODIFY";
    public static final String DTC_CHGSTATE = "DTC_CHGSTATE";
    public static final String DTC_CHGMODE = "DTC_CHGMODE";
    public static final String LOG_SESTIMOUT = "LOG_SESTIMOUT";
    public static final String LOG_LOGOUT = "LOG_LOGOUT";
    public static final String USER_ADD = "USER_ADD";
    public static final String USER_MODIFY = "USER_MODIFY";
    public static final String USER_PWD_MODIFY = "USER_PWD_MODIFY";
    public static final String USER_LOCK = "USER_LOCK";
    public static final String USER_UNLOCK = "USER_UNLOCK";
    public static final String USER_RESET = "USER_RESET";
    public static final String USER_REMOVE = "USER_REMOVE";
    private String code;
    private String name;
    private String oldName;
    private String dtc;
    private String operationalArea;
    private String schedule;
    private String oldSchedule;
    private Date date;
    private Date oldDate;
    private String profile;
    private String oldProfile;
    private String email;
    private String oldEmail;
    private String service;
    private Boolean state;
    private Boolean mode;
    private String ipAddress;
    private String login;
    private String stateTrue;
    private String stateFalse;
    private String modeTrue;
    private String modeFalse;
    private static final String SEPARATOR = "|";

    public AuditLog(String code) {
        this.code = code;
    }

    public AuditLog(String source, String stateTrue, String stateFalse, String modeTrue, String modeFalse) {
        this.read(source);
        this.stateFalse = stateFalse;
        this.stateTrue = stateTrue;
        this.modeFalse = modeFalse;
        this.modeTrue = modeTrue;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOldName() {
        return this.oldName;
    }

    public void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public String getDtc() {
        return this.dtc;
    }

    public void setDtc(String dtc) {
        this.dtc = dtc;
    }

    public String getOperationalArea() {
        return this.operationalArea;
    }

    public void setOperationalArea(String operationalArea) {
        this.operationalArea = operationalArea;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String baseSchedule) {
        this.schedule = baseSchedule;
    }

    public String getOldSchedule() {
        return this.oldSchedule;
    }

    public void setOldSchedule(String oldSchedule) {
        this.oldSchedule = oldSchedule;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getOldDate() {
        return this.oldDate;
    }

    public void setOldDate(Date oldDate) {
        this.oldDate = oldDate;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getOldProfile() {
        return this.oldProfile;
    }

    public void setOldProfile(String oldProfile) {
        this.oldProfile = oldProfile;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getOldEmail() {
        return this.oldEmail;
    }

    public void setOldEmail(String oldEmail) {
        this.oldEmail = oldEmail;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public Boolean getState() {
        return this.state;
    }

    public void setState(Boolean state) {
        this.state = state;
    }

    public Boolean getMode() {
        return this.mode;
    }

    public void setMode(Boolean mode) {
        this.mode = mode;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String stateDescription() {
        if (this.state != null) {
            return this.state != false ? this.stateTrue : this.stateFalse;
        }
        return "";
    }

    public String modeDescription() {
        if (this.mode != null) {
            return this.mode != false ? this.modeTrue : this.modeFalse;
        }
        return "";
    }

    public String stringify() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.code);
        builder.append(this.pipe(this.login));
        builder.append(this.pipe(this.name));
        builder.append(this.pipe(this.oldName));
        builder.append(this.pipe(this.dtc));
        builder.append(this.pipe(this.operationalArea));
        builder.append(this.pipe(this.schedule));
        builder.append(this.pipe(this.oldSchedule));
        builder.append(this.pipe(this.date));
        builder.append(this.pipe(this.oldDate));
        builder.append(this.pipe(this.profile));
        builder.append(this.pipe(this.oldProfile));
        builder.append(this.pipe(this.email));
        builder.append(this.pipe(this.oldEmail));
        builder.append(this.pipe(this.service));
        builder.append(this.pipe(this.state));
        builder.append(this.pipe(this.mode));
        builder.append(this.pipe(this.ipAddress));
        return builder.toString();
    }

    public void read(String source) {
        String[] sources = source.split("\\|");
        int cnt = 0;
        this.code = this.asString(sources, cnt++);
        this.login = this.asString(sources, cnt++);
        this.name = this.asString(sources, cnt++);
        this.oldName = this.asString(sources, cnt++);
        this.dtc = this.asString(sources, cnt++);
        this.operationalArea = this.asString(sources, cnt++);
        this.schedule = this.asString(sources, cnt++);
        this.oldSchedule = this.asString(sources, cnt++);
        this.date = this.asDate(sources, cnt++);
        this.oldDate = this.asDate(sources, cnt++);
        this.profile = this.asString(sources, cnt++);
        this.oldProfile = this.asString(sources, cnt++);
        this.email = this.asString(sources, cnt++);
        this.oldEmail = this.asString(sources, cnt++);
        this.service = this.asString(sources, cnt++);
        this.state = this.asBoolean(sources, cnt++);
        this.mode = this.asBoolean(sources, cnt++);
        this.ipAddress = this.asString(sources, cnt++);
    }

    public Object[] elements() {
        ArrayList<Comparable<Date>> array = new ArrayList<Comparable<Date>>();
        array.add(this.date);
        array.add(this.oldDate);
        array.add(Integer.valueOf(Boolean.TRUE.equals(this.state) ? 1 : 0));
        array.add(Integer.valueOf(Boolean.TRUE.equals(this.mode) ? 1 : 0));
        return array.toArray();
    }

    private String pipe(String o) {
        return o != null ? SEPARATOR + o : SEPARATOR;
    }

    private String pipe(Date o) {
        return o != null ? SEPARATOR + o.getTime() : SEPARATOR;
    }

    private String pipe(Boolean o) {
        return o != null ? SEPARATOR + (o != false ? 1 : 0) : SEPARATOR;
    }

    private String asString(String[] sources, int index) {
        if (index < sources.length) {
            return sources[index];
        }
        return null;
    }

    private Date asDate(String[] sources, int index) {
        String s;
        if (index < sources.length && !(s = sources[index]).isEmpty()) {
            return new Date(new Long(s));
        }
        return null;
    }

    private Boolean asBoolean(String[] sources, int index) {
        String s;
        if (index < sources.length && !(s = sources[index]).isEmpty()) {
            return s.equals("1");
        }
        return null;
    }
}

