/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.core.entity;

import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import pt.efacec.smartlighting.common.core.entity.AuditAction;
import pt.efacec.smartlighting.common.core.entity.ClientEntity;
import pt.efacec.smartlighting.common.core.entity.DtcState;
import pt.efacec.smartlighting.common.core.entity.OperationalArea;
import pt.efacec.smartlighting.common.entity.AbstractEntity;

@Entity
@Table(name="USER")
public class User
extends AbstractEntity<String> {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="USERUID", length=36)
    private String id;
    @Version
    @Column
    private Integer version;
    @Column(name="DELETED", nullable=false)
    protected String deleted = new String("0");
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DEATH_DATE")
    protected Date deathDate;
    @Column(name="LOGIN", length=30, nullable=false)
    protected String login;
    @Column(name="SALT", length=16, nullable=false)
    protected String salt;
    @Column(name="PASSWORD", length=256, nullable=false)
    protected String password;
    @Column(name="NAME", length=100, nullable=false)
    protected String name;
    @Column(name="FAILED_LOGINS", nullable=false)
    protected Long failedLogins = new Long(0L);
    @Column(name="LOCKED", nullable=false)
    protected Boolean locked = new Boolean(false);
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="LOCKED_DATE")
    protected Date lockedDate;
    @Column(name="EMAIL")
    protected String email;
    @Column(name="CLIENT", length=36)
    protected String clientId;
    @Column(name="OPERATIONAL_AREA", length=36)
    protected String operationalAreaId;
    @Transient
    private ClientEntity client;
    @Transient
    private OperationalArea operationalArea;
    @Transient
    private Set<AuditAction> auditActions;
    @Transient
    private Set<DtcState> states;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public User() {
    }

    public User(User original) {
        this.copy(original);
    }

    public void copy(User original) {
        if (original == null) {
            return;
        }
        this.deleted = original.getDeleted();
        this.deathDate = original.getDeathDate();
        this.login = original.getLogin();
        this.salt = original.getSalt();
        this.password = original.getPassword();
        this.name = original.getName();
        this.failedLogins = original.getFailedLogins();
        this.locked = original.getLocked();
        this.lockedDate = original.getLockedDate();
        this.email = original.getEmail();
        this.clientId = original.getClientId();
        this.operationalAreaId = original.getOperationalAreaId();
    }

    public String getDeleted() {
        return this.deleted;
    }

    public void setDeleted(String deleted) {
        this.deleted = deleted;
    }

    public Date getDeathDate() {
        return this.deathDate;
    }

    public void setDeathDate(Date deathDate) {
        this.deathDate = deathDate;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getFailedLogins() {
        return this.failedLogins;
    }

    public void setFailedLogins(Long failedLogins) {
        this.failedLogins = failedLogins;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public Date getLockedDate() {
        return this.lockedDate;
    }

    public void setLockedDate(Date lockedDate) {
        this.lockedDate = lockedDate;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        if (clientId == null || !clientId.equals(this.clientId)) {
            this.client = null;
        }
        this.clientId = clientId;
    }

    public String getOperationalAreaId() {
        return this.operationalAreaId;
    }

    public void setOperationalAreaId(String operationalAreaId) {
        if (operationalAreaId == null || !operationalAreaId.equals(this.operationalAreaId)) {
            this.operationalArea = null;
        }
        this.operationalAreaId = operationalAreaId;
    }

    public ClientEntity getClient() {
        return this.client;
    }

    public void setClient(ClientEntity client) {
        this.client = client;
        this.clientId = client != null ? client.getId() : null;
    }

    public OperationalArea getOperationalArea() {
        return this.operationalArea;
    }

    public void setOperationalArea(OperationalArea operationalArea) {
        this.operationalArea = operationalArea;
        this.operationalAreaId = operationalArea != null ? operationalArea.getId() : null;
    }

    public Set<AuditAction> getAuditActions() {
        return this.auditActions;
    }

    public void setAuditActions(Set<AuditAction> auditActions) {
        this.auditActions = auditActions;
    }

    public Set<DtcState> getStates() {
        return this.states;
    }

    public void setStates(Set<DtcState> states) {
        this.states = states;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{id: ").append(this.getId());
        sb.append(", version: ").append(this.getVersion());
        sb.append(", deleted: ").append(this.deleted);
        sb.append(", deathDate: ").append(this.deathDate);
        sb.append(", login: ").append(this.login);
        sb.append(", salt: ").append(this.salt);
        sb.append(", password: ").append(this.password);
        sb.append(", name: ").append(this.name);
        sb.append(", failedLogins: ").append(this.failedLogins);
        sb.append(", locked: ").append(this.locked);
        sb.append(", lockedDate: ").append(this.lockedDate);
        sb.append(", email: ").append(this.email);
        sb.append(", clientId: ").append(this.clientId);
        sb.append(", operationalAreaId: ").append(this.operationalAreaId);
        sb.append("}");
        return sb.toString();
    }
}

