/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.core.entity;

import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.Profile;
import pt.efacec.smartlighting.common.core.entity.SpecialDayService;
import pt.efacec.smartlighting.common.entity.AbstractEntity;

@Entity
@Table(name="SPECIAL_DAY")
public class SpecialDay
extends AbstractEntity<String> {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="SPECIAL_DAYUID", length=36)
    private String id;
    @Version
    @Column
    private Integer version;
    @Column(name="NAME", length=100, nullable=false)
    protected String name;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DAY", nullable=false)
    protected Date day;
    @Column(name="PROFILE", length=36)
    protected String profileId;
    @Column(name="DTC", length=36)
    protected String dtcId;
    @Transient
    private Profile profile;
    @Transient
    private Dtc dtc;
    @Transient
    private Set<SpecialDayService> specialDayServices;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public SpecialDay() {
    }

    public SpecialDay(SpecialDay original) {
        this.copy(original);
    }

    public void copy(SpecialDay original) {
        if (original == null) {
            return;
        }
        this.name = original.getName();
        if (original.getDay() != null) {
            this.day = new Date(original.getDay().getTime());
        }
        this.profileId = original.getProfileId();
        this.dtcId = original.getDtcId();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getDay() {
        return this.day;
    }

    public void setDay(Date day) {
        this.day = day;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public void setProfileId(String profileId) {
        if (profileId == null || !profileId.equals(this.profileId)) {
            this.profile = null;
        }
        this.profileId = profileId;
    }

    public String getDtcId() {
        return this.dtcId;
    }

    public void setDtcId(String dtcId) {
        if (dtcId == null || !dtcId.equals(this.dtcId)) {
            this.dtc = null;
        }
        this.dtcId = dtcId;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
        this.profileId = profile != null ? profile.getId() : null;
    }

    public Dtc getDtc() {
        return this.dtc;
    }

    public void setDtc(Dtc dtc) {
        this.dtc = dtc;
        this.dtcId = dtc != null ? dtc.getId() : null;
    }

    public Set<SpecialDayService> getSpecialDayServices() {
        return this.specialDayServices;
    }

    public void setSpecialDayServices(Set<SpecialDayService> specialDayServices) {
        this.specialDayServices = specialDayServices;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{id: ").append(this.getId());
        sb.append(", version: ").append(this.getVersion());
        sb.append(", name: ").append(this.name);
        sb.append(", day: ").append(this.day);
        sb.append(", profileId: ").append(this.profileId);
        sb.append(", dtcId: ").append(this.dtcId);
        sb.append("}");
        return sb.toString();
    }
}

