/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.core.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import pt.efacec.smartlighting.common.core.entity.ClientEntity;
import pt.efacec.smartlighting.common.core.entity.District;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.DtcService;
import pt.efacec.smartlighting.common.core.entity.Municipality;
import pt.efacec.smartlighting.common.core.entity.OperationalArea;
import pt.efacec.smartlighting.common.entity.AbstractEntity;

@Entity
@Table(name="SERVICE_STOPWATCH")
public class ServiceStopwatch
extends AbstractEntity<String> {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="SERVICE_TIMERUID", length=36)
    private String id;
    @Version
    @Column
    private Integer version;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="BEGIN_DATE", nullable=false)
    protected Date beginDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="END_DATE")
    protected Date endDate;
    @Column(name="MINUTES")
    protected Long minutes;
    @Column(name="RUNNING", nullable=false)
    protected Boolean running;
    @Column(name="STATE", nullable=false)
    protected Boolean state;
    @Column(name="DTC_NAME")
    protected String dtcName;
    @Column(name="SERVICE_NAME")
    protected String serviceName;
    @Column(name="POWER", nullable=false)
    protected Double power;
    @Column(name="OPERATIONAL_AREAUID", length=36)
    protected String operationalAreaId;
    @Column(name="CLIENTEUID", length=36)
    protected String clientId;
    @Column(name="SERVICEUID", length=36)
    protected String serviceId;
    @Column(name="DISTRICTUID", length=36)
    protected String districtId;
    @Column(name="MUNICIPALITYUID", length=36)
    protected String municipalityId;
    @Column(name="DTCUID", length=36)
    protected String dtcId;
    @Transient
    private OperationalArea operationalArea;
    @Transient
    private ClientEntity client;
    @Transient
    private DtcService service;
    @Transient
    private District district;
    @Transient
    private Municipality municipality;
    @Transient
    private Dtc dtc;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public ServiceStopwatch() {
    }

    public ServiceStopwatch(ServiceStopwatch original) {
        this.copy(original);
    }

    public void copy(ServiceStopwatch original) {
        if (original == null) {
            return;
        }
        this.beginDate = original.getBeginDate();
        this.endDate = original.getEndDate();
        this.minutes = original.getMinutes();
        this.running = original.getRunning();
        this.state = original.getState();
        this.dtcName = original.getDtcName();
        this.serviceName = original.getServiceName();
        this.power = original.getPower();
        this.operationalAreaId = original.getOperationalAreaId();
        this.clientId = original.getClientId();
        this.serviceId = original.getServiceId();
        this.districtId = original.getDistrictId();
        this.municipalityId = original.getMunicipalityId();
        this.dtcId = original.getDtcId();
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Long getMinutes() {
        return this.minutes;
    }

    public void setMinutes(Long minutes) {
        this.minutes = minutes;
    }

    public Boolean getRunning() {
        return this.running;
    }

    public void setRunning(Boolean running) {
        this.running = running;
    }

    public Boolean getState() {
        return this.state;
    }

    public void setState(Boolean state) {
        this.state = state;
    }

    public String getDtcName() {
        return this.dtcName;
    }

    public void setDtcName(String dtcName) {
        this.dtcName = dtcName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Double getPower() {
        return this.power;
    }

    public void setPower(Double power) {
        this.power = power;
    }

    public String getOperationalAreaId() {
        return this.operationalAreaId;
    }

    public void setOperationalAreaId(String operationalAreaId) {
        if (operationalAreaId == null || !operationalAreaId.equals(this.operationalAreaId)) {
            this.operationalArea = null;
        }
        this.operationalAreaId = operationalAreaId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        if (clientId == null || !clientId.equals(this.clientId)) {
            this.client = null;
        }
        this.clientId = clientId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        if (serviceId == null || !serviceId.equals(this.serviceId)) {
            this.service = null;
        }
        this.serviceId = serviceId;
    }

    public String getDistrictId() {
        return this.districtId;
    }

    public void setDistrictId(String districtId) {
        if (districtId == null || !districtId.equals(this.districtId)) {
            this.district = null;
        }
        this.districtId = districtId;
    }

    public String getMunicipalityId() {
        return this.municipalityId;
    }

    public void setMunicipalityId(String municipalityId) {
        if (municipalityId == null || !municipalityId.equals(this.municipalityId)) {
            this.municipality = null;
        }
        this.municipalityId = municipalityId;
    }

    public String getDtcId() {
        return this.dtcId;
    }

    public void setDtcId(String dtcId) {
        if (dtcId == null || !dtcId.equals(this.dtcId)) {
            this.dtc = null;
        }
        this.dtcId = dtcId;
    }

    public OperationalArea getOperationalArea() {
        return this.operationalArea;
    }

    public void setOperationalArea(OperationalArea operationalArea) {
        this.operationalArea = operationalArea;
        this.operationalAreaId = operationalArea != null ? operationalArea.getId() : null;
    }

    public ClientEntity getClient() {
        return this.client;
    }

    public void setClient(ClientEntity client) {
        this.client = client;
        this.clientId = client != null ? client.getId() : null;
    }

    public DtcService getService() {
        return this.service;
    }

    public void setService(DtcService service) {
        this.service = service;
        this.serviceId = service != null ? service.getId() : null;
    }

    public District getDistrict() {
        return this.district;
    }

    public void setDistrict(District district) {
        this.district = district;
        this.districtId = district != null ? district.getId() : null;
    }

    public Municipality getMunicipality() {
        return this.municipality;
    }

    public void setMunicipality(Municipality municipality) {
        this.municipality = municipality;
        this.municipalityId = municipality != null ? municipality.getId() : null;
    }

    public Dtc getDtc() {
        return this.dtc;
    }

    public void setDtc(Dtc dtc) {
        this.dtc = dtc;
        this.dtcId = dtc != null ? dtc.getId() : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{id: ").append(this.getId());
        sb.append(", version: ").append(this.getVersion());
        sb.append(", beginDate: ").append(this.beginDate);
        sb.append(", endDate: ").append(this.endDate);
        sb.append(", minutes: ").append(this.minutes);
        sb.append(", running: ").append(this.running);
        sb.append(", state: ").append(this.state);
        sb.append(", dtcName: ").append(this.dtcName);
        sb.append(", serviceName: ").append(this.serviceName);
        sb.append(", power: ").append(this.power);
        sb.append(", operationalAreaId: ").append(this.operationalAreaId);
        sb.append(", clientId: ").append(this.clientId);
        sb.append(", serviceId: ").append(this.serviceId);
        sb.append(", districtId: ").append(this.districtId);
        sb.append(", municipalityId: ").append(this.municipalityId);
        sb.append(", dtcId: ").append(this.dtcId);
        sb.append("}");
        return sb.toString();
    }
}

