/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.core.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import pt.efacec.smartlighting.common.core.entity.Profile;
import pt.efacec.smartlighting.common.core.entity.Timetable;
import pt.efacec.smartlighting.common.entity.AbstractEntity;

@Entity
@Table(name="SERVICE")
public class Service
extends AbstractEntity<String> {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="SERVICEUID", length=36)
    private String id;
    @Version
    @Column
    private Integer version;
    @Column(name="NAME", nullable=false)
    protected String name;
    @Column(name="PROFILE", length=36)
    protected String profileId;
    @Column(name="TIMETABLE", length=36)
    protected String timetableId;
    @Transient
    private Profile profile;
    @Transient
    private Timetable timetable;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Service() {
    }

    public Service(Service original) {
        this.copy(original);
    }

    public void copy(Service original) {
        if (original == null) {
            return;
        }
        this.name = original.getName();
        this.profileId = original.getProfileId();
        this.timetableId = original.getTimetableId();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public void setProfileId(String profileId) {
        if (profileId == null || !profileId.equals(this.profileId)) {
            this.profile = null;
        }
        this.profileId = profileId;
    }

    public String getTimetableId() {
        return this.timetableId;
    }

    public void setTimetableId(String timetableId) {
        if (timetableId == null || !timetableId.equals(this.timetableId)) {
            this.timetable = null;
        }
        this.timetableId = timetableId;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
        this.profileId = profile != null ? profile.getId() : null;
    }

    public Timetable getTimetable() {
        return this.timetable;
    }

    public void setTimetable(Timetable timetable) {
        this.timetable = timetable;
        this.timetableId = timetable != null ? timetable.getId() : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{id: ").append(this.getId());
        sb.append(", version: ").append(this.getVersion());
        sb.append(", name: ").append(this.name);
        sb.append(", profileId: ").append(this.profileId);
        sb.append(", timetableId: ").append(this.timetableId);
        sb.append("}");
        return sb.toString();
    }
}

