/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.core.entity;

import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import pt.efacec.smartlighting.common.core.entity.Control;
import pt.efacec.smartlighting.common.core.entity.Timetable;
import pt.efacec.smartlighting.common.entity.AbstractEntity;

@Entity
@Table(name="PERIOD")
public class Period
extends AbstractEntity<String> {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="PERIODUID", length=36)
    private String id;
    @Version
    @Column
    private Integer version;
    @Temporal(value=TemporalType.DATE)
    @Column(name="START", nullable=false)
    protected Date start;
    @Temporal(value=TemporalType.DATE)
    @Column(name="END")
    protected Date end;
    @Column(name="TIMETABLE", length=36)
    protected String timetableId;
    @Transient
    private Timetable timetable;
    @Transient
    private Set<Control> controls;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Period() {
    }

    public Period(Period original) {
        this.copy(original);
    }

    public void copy(Period original) {
        if (original == null) {
            return;
        }
        if (original.getStart() != null) {
            this.start = new Date(original.getStart().getTime());
        }
        if (original.getEnd() != null) {
            this.end = new Date(original.getEnd().getTime());
        }
        this.timetableId = original.getTimetableId();
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public String getTimetableId() {
        return this.timetableId;
    }

    public void setTimetableId(String timetableId) {
        if (timetableId == null || !timetableId.equals(this.timetableId)) {
            this.timetable = null;
        }
        this.timetableId = timetableId;
    }

    public Timetable getTimetable() {
        return this.timetable;
    }

    public void setTimetable(Timetable timetable) {
        this.timetable = timetable;
        this.timetableId = timetable != null ? timetable.getId() : null;
    }

    public Set<Control> getControls() {
        return this.controls;
    }

    public void setControls(Set<Control> controls) {
        this.controls = controls;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{id: ").append(this.getId());
        sb.append(", version: ").append(this.getVersion());
        sb.append(", start: ").append(this.start);
        sb.append(", end: ").append(this.end);
        sb.append(", timetableId: ").append(this.timetableId);
        sb.append("}");
        return sb.toString();
    }
}

