/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.core.entity;

import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import pt.efacec.smartlighting.common.core.entity.District;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.ServiceStopwatch;
import pt.efacec.smartlighting.common.entity.AbstractEntity;

@Entity
@Table(name="MUNICIPALITY")
public class Municipality
extends AbstractEntity<String> {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="MUNICIPALITYUID", length=36)
    private String id;
    @Version
    @Column
    private Integer version;
    @Column(name="NAME", length=100, nullable=false)
    protected String name;
    @Column(name="DISTRICTUID", length=36)
    protected String districtId;
    @Transient
    private District district;
    @Transient
    private Set<Dtc> dtcs;
    @Transient
    private Set<ServiceStopwatch> timers;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Municipality() {
    }

    public Municipality(Municipality original) {
        this.copy(original);
    }

    public void copy(Municipality original) {
        if (original == null) {
            return;
        }
        this.name = original.getName();
        this.districtId = original.getDistrictId();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDistrictId() {
        return this.districtId;
    }

    public void setDistrictId(String districtId) {
        if (districtId == null || !districtId.equals(this.districtId)) {
            this.district = null;
        }
        this.districtId = districtId;
    }

    public District getDistrict() {
        return this.district;
    }

    public void setDistrict(District district) {
        this.district = district;
        this.districtId = district != null ? district.getId() : null;
    }

    public Set<Dtc> getDtcs() {
        return this.dtcs;
    }

    public void setDtcs(Set<Dtc> dtcs) {
        this.dtcs = dtcs;
    }

    public Set<ServiceStopwatch> getTimers() {
        return this.timers;
    }

    public void setTimers(Set<ServiceStopwatch> timers) {
        this.timers = timers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{id: ").append(this.getId());
        sb.append(", version: ").append(this.getVersion());
        sb.append(", name: ").append(this.name);
        sb.append(", districtId: ").append(this.districtId);
        sb.append("}");
        return sb.toString();
    }
}

