/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.core.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.DtcService;
import pt.efacec.smartlighting.common.core.lov.EventLOV;
import pt.efacec.smartlighting.common.entity.AbstractEntity;

@Entity
@Table(name="EVENT")
public class Event
extends AbstractEntity<String> {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="EVENTUID", length=36)
    private String id;
    @Version
    @Column
    private Integer version;
    @Enumerated(value=EnumType.STRING)
    @Column(name="TYPE", length=5, nullable=false)
    protected EventLOV type;
    @Column(name="VALUE", nullable=false)
    protected String value;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="TIME", nullable=false)
    protected Date time;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DELIVERY_DATE", nullable=false)
    protected Date deliveryDate;
    @Column(name="CLIENT_NAME")
    protected String clientName;
    @Column(name="DTC_NAME")
    protected String dtcName;
    @Column(name="SERVICE_NAME")
    protected String serviceName;
    @Column(name="PROFILE_NAME")
    protected String profileName;
    @Column(name="DTCUID", length=36)
    protected String dtcId;
    @Column(name="DTC_SERVICEUID", length=36)
    protected String dtcServiceId;
    @Transient
    private Dtc dtc;
    @Transient
    private DtcService dtcService;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Event() {
    }

    public Event(Event original) {
        this.copy(original);
    }

    public void copy(Event original) {
        if (original == null) {
            return;
        }
        this.type = original.getType();
        this.value = original.getValue();
        this.time = original.getTime();
        this.deliveryDate = original.getDeliveryDate();
        this.clientName = original.getClientName();
        this.dtcName = original.getDtcName();
        this.serviceName = original.getServiceName();
        this.profileName = original.getProfileName();
        this.dtcId = original.getDtcId();
        this.dtcServiceId = original.getDtcServiceId();
    }

    public EventLOV getType() {
        return this.type;
    }

    public void setType(EventLOV type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public Date getDeliveryDate() {
        return this.deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getDtcName() {
        return this.dtcName;
    }

    public void setDtcName(String dtcName) {
        this.dtcName = dtcName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getDtcId() {
        return this.dtcId;
    }

    public void setDtcId(String dtcId) {
        if (dtcId == null || !dtcId.equals(this.dtcId)) {
            this.dtc = null;
        }
        this.dtcId = dtcId;
    }

    public String getDtcServiceId() {
        return this.dtcServiceId;
    }

    public void setDtcServiceId(String dtcServiceId) {
        if (dtcServiceId == null || !dtcServiceId.equals(this.dtcServiceId)) {
            this.dtcService = null;
        }
        this.dtcServiceId = dtcServiceId;
    }

    public Dtc getDtc() {
        return this.dtc;
    }

    public void setDtc(Dtc dtc) {
        this.dtc = dtc;
        this.dtcId = dtc != null ? dtc.getId() : null;
    }

    public DtcService getDtcService() {
        return this.dtcService;
    }

    public void setDtcService(DtcService dtcService) {
        this.dtcService = dtcService;
        this.dtcServiceId = dtcService != null ? dtcService.getId() : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{id: ").append(this.getId());
        sb.append(", version: ").append(this.getVersion());
        sb.append(", type: ").append((Object)this.type);
        sb.append(", value: ").append(this.value);
        sb.append(", time: ").append(this.time);
        sb.append(", deliveryDate: ").append(this.deliveryDate);
        sb.append(", clientName: ").append(this.clientName);
        sb.append(", dtcName: ").append(this.dtcName);
        sb.append(", serviceName: ").append(this.serviceName);
        sb.append(", profileName: ").append(this.profileName);
        sb.append(", dtcId: ").append(this.dtcId);
        sb.append(", dtcServiceId: ").append(this.dtcServiceId);
        sb.append("}");
        return sb.toString();
    }
}

