/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.core.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.User;
import pt.efacec.smartlighting.common.core.lov.SynchronizationErrorLOV;
import pt.efacec.smartlighting.common.core.lov.SynchronizationStateLOV;
import pt.efacec.smartlighting.common.entity.AbstractEntity;

@Entity
@Table(name="DTC_STATE")
public class DtcState
extends AbstractEntity<String> {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="DTC_STATEUID", length=36)
    private String id;
    @Version
    @Column
    private Integer version;
    @Enumerated(value=EnumType.STRING)
    @Column(name="STATE", length=11, nullable=false)
    protected SynchronizationStateLOV state;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="OPERATION_TIME")
    protected Date operationTime;
    @Column(name="LAST_CHANGE", length=4000)
    protected String lastChange;
    @Enumerated(value=EnumType.STRING)
    @Column(name="ERROR_TYPE", length=20)
    protected SynchronizationErrorLOV errorType;
    @Column(name="DTC_NAME", length=100, nullable=false)
    protected String dtcName;
    @Column(name="OPERATIONAL_AREAUID", length=36, nullable=false)
    protected String operationalAreaId;
    @Column(name="OPERATIONAL_AREA", length=100, nullable=false)
    protected String operationalArea;
    @Column(name="DISTRICTUID", length=36, nullable=false)
    protected String districtId;
    @Column(name="MUNICIPALITYUID", length=36)
    protected String municipalityId;
    @Column(name="CLIENTUID", length=36)
    protected String clientId;
    @Column(name="SUBMITER", length=36)
    protected String submiterId;
    @Transient
    private Dtc dtc;
    @Transient
    private User submiter;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public DtcState() {
    }

    public DtcState(DtcState original) {
        this.copy(original);
    }

    public void copy(DtcState original) {
        if (original == null) {
            return;
        }
        this.state = original.getState();
        this.operationTime = original.getOperationTime();
        this.lastChange = original.getLastChange();
        this.errorType = original.getErrorType();
        this.dtcName = original.getDtcName();
        this.operationalAreaId = original.getOperationalAreaId();
        this.operationalArea = original.getOperationalArea();
        this.districtId = original.getDistrictId();
        this.municipalityId = original.getMunicipalityId();
        this.clientId = original.getClientId();
        this.submiterId = original.getSubmiterId();
    }

    public SynchronizationStateLOV getState() {
        return this.state;
    }

    public void setState(SynchronizationStateLOV state) {
        this.state = state;
    }

    public Date getOperationTime() {
        return this.operationTime;
    }

    public void setOperationTime(Date operationTime) {
        this.operationTime = operationTime;
    }

    public String getLastChange() {
        return this.lastChange;
    }

    public void setLastChange(String lastChange) {
        this.lastChange = lastChange;
    }

    public SynchronizationErrorLOV getErrorType() {
        return this.errorType;
    }

    public void setErrorType(SynchronizationErrorLOV errorType) {
        this.errorType = errorType;
    }

    public String getDtcName() {
        return this.dtcName;
    }

    public void setDtcName(String dtcName) {
        this.dtcName = dtcName;
    }

    public String getOperationalAreaId() {
        return this.operationalAreaId;
    }

    public void setOperationalAreaId(String operationalAreaId) {
        this.operationalAreaId = operationalAreaId;
    }

    public String getOperationalArea() {
        return this.operationalArea;
    }

    public void setOperationalArea(String operationalArea) {
        this.operationalArea = operationalArea;
    }

    public String getDistrictId() {
        return this.districtId;
    }

    public void setDistrictId(String districtId) {
        this.districtId = districtId;
    }

    public String getMunicipalityId() {
        return this.municipalityId;
    }

    public void setMunicipalityId(String municipalityId) {
        this.municipalityId = municipalityId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getSubmiterId() {
        return this.submiterId;
    }

    public void setSubmiterId(String submiterId) {
        if (submiterId == null || !submiterId.equals(this.submiterId)) {
            this.submiter = null;
        }
        this.submiterId = submiterId;
    }

    public Dtc getDtc() {
        return this.dtc;
    }

    public void setDtc(Dtc dtc) {
        this.dtc = dtc;
    }

    public User getSubmiter() {
        return this.submiter;
    }

    public void setSubmiter(User submiter) {
        this.submiter = submiter;
        this.submiterId = submiter != null ? submiter.getId() : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{id: ").append(this.getId());
        sb.append(", version: ").append(this.getVersion());
        sb.append(", state: ").append((Object)this.state);
        sb.append(", operationTime: ").append(this.operationTime);
        sb.append(", lastChange: ").append(this.lastChange);
        sb.append(", errorType: ").append((Object)this.errorType);
        sb.append(", dtcName: ").append(this.dtcName);
        sb.append(", operationalAreaId: ").append(this.operationalAreaId);
        sb.append(", operationalArea: ").append(this.operationalArea);
        sb.append(", districtId: ").append(this.districtId);
        sb.append(", municipalityId: ").append(this.municipalityId);
        sb.append(", clientId: ").append(this.clientId);
        sb.append(", submiterId: ").append(this.submiterId);
        sb.append("}");
        return sb.toString();
    }
}

