/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.core.entity;

import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import pt.efacec.smartlighting.common.core.entity.Alarm;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.Event;
import pt.efacec.smartlighting.common.core.entity.ServiceStopwatch;
import pt.efacec.smartlighting.common.entity.AbstractEntity;

@Entity
@Table(name="DTC_SERVICE")
public class DtcService
extends AbstractEntity<String> {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="DTC_SERVICEUID", length=36)
    private String id;
    @Version
    @Column
    private Integer version;
    @Column(name="DELETED", nullable=false)
    protected String deleted = new String("0");
    @Column(name="NAME", nullable=false)
    protected String name;
    @Column(name="STATE")
    protected Boolean state;
    @Column(name="OPMODE")
    protected Boolean mode;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="BIRTH_DATE", nullable=false)
    protected Date birthDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DEATH_DATE")
    protected Date deathDate;
    @Column(name="DTCUID", length=36)
    protected String dtcId;
    @Transient
    private Dtc dtc;
    @Transient
    private Set<Event> events;
    @Transient
    private Set<Alarm> alarms;
    @Transient
    private Set<ServiceStopwatch> timers;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public DtcService() {
    }

    public DtcService(DtcService original) {
        this.copy(original);
    }

    public void copy(DtcService original) {
        if (original == null) {
            return;
        }
        this.deleted = original.getDeleted();
        this.name = original.getName();
        this.state = original.getState();
        this.mode = original.getMode();
        this.birthDate = original.getBirthDate();
        this.deathDate = original.getDeathDate();
        this.dtcId = original.getDtcId();
    }

    public String getDeleted() {
        return this.deleted;
    }

    public void setDeleted(String deleted) {
        this.deleted = deleted;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getState() {
        return this.state;
    }

    public void setState(Boolean state) {
        this.state = state;
    }

    public Boolean getMode() {
        return this.mode;
    }

    public void setMode(Boolean mode) {
        this.mode = mode;
    }

    public Date getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    public Date getDeathDate() {
        return this.deathDate;
    }

    public void setDeathDate(Date deathDate) {
        this.deathDate = deathDate;
    }

    public String getDtcId() {
        return this.dtcId;
    }

    public void setDtcId(String dtcId) {
        if (dtcId == null || !dtcId.equals(this.dtcId)) {
            this.dtc = null;
        }
        this.dtcId = dtcId;
    }

    public Dtc getDtc() {
        return this.dtc;
    }

    public void setDtc(Dtc dtc) {
        this.dtc = dtc;
        this.dtcId = dtc != null ? dtc.getId() : null;
    }

    public Set<Event> getEvents() {
        return this.events;
    }

    public void setEvents(Set<Event> events) {
        this.events = events;
    }

    public Set<Alarm> getAlarms() {
        return this.alarms;
    }

    public void setAlarms(Set<Alarm> alarms) {
        this.alarms = alarms;
    }

    public Set<ServiceStopwatch> getTimers() {
        return this.timers;
    }

    public void setTimers(Set<ServiceStopwatch> timers) {
        this.timers = timers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{id: ").append(this.getId());
        sb.append(", version: ").append(this.getVersion());
        sb.append(", deleted: ").append(this.deleted);
        sb.append(", name: ").append(this.name);
        sb.append(", state: ").append(this.state);
        sb.append(", mode: ").append(this.mode);
        sb.append(", birthDate: ").append(this.birthDate);
        sb.append(", deathDate: ").append(this.deathDate);
        sb.append(", dtcId: ").append(this.dtcId);
        sb.append("}");
        return sb.toString();
    }
}

