/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.core.entity;

import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import pt.efacec.smartlighting.common.core.entity.Alarm;
import pt.efacec.smartlighting.common.core.entity.ClientEntity;
import pt.efacec.smartlighting.common.core.entity.District;
import pt.efacec.smartlighting.common.core.entity.DtcService;
import pt.efacec.smartlighting.common.core.entity.DtcState;
import pt.efacec.smartlighting.common.core.entity.Event;
import pt.efacec.smartlighting.common.core.entity.Municipality;
import pt.efacec.smartlighting.common.core.entity.OperationalArea;
import pt.efacec.smartlighting.common.core.entity.Profile;
import pt.efacec.smartlighting.common.core.entity.ServiceStopwatch;
import pt.efacec.smartlighting.common.core.entity.SpecialDay;
import pt.efacec.smartlighting.common.core.entity.Timetable;
import pt.efacec.smartlighting.common.entity.AbstractEntity;

@Entity
@Table(name="DTC")
public class Dtc
extends AbstractEntity<String> {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="DTCUID", length=36)
    private String id;
    @Version
    @Column
    private Integer version;
    @Column(name="DELETED", nullable=false)
    protected String deleted = new String("0");
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="BIRTH_DATE", nullable=false)
    protected Date birthDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DEATH_DATE")
    protected Date deathDate;
    @Column(name="RTUUID", length=50, unique=true)
    protected String rtuuid;
    @Column(name="NAME", length=100, nullable=false)
    protected String name;
    @Column(name="SECSUBSTATION", length=16)
    protected String secundarySubstation;
    @Column(name="LATITUDE")
    protected Double latitude;
    @Column(name="LONGITUDE")
    protected Double longitude;
    @Column(name="HASPHOTOCELL")
    protected Boolean hasPhotocell;
    @Column(name="IPADDRESS", length=15, nullable=false)
    protected String ipAddress;
    @Column(name="OPERATIONAL_AREAUID", length=36)
    protected String operationalAreaId;
    @Column(name="CLIENTUID", length=36)
    protected String clientId;
    @Column(name="DISTRICTUID", length=36)
    protected String districtId;
    @Column(name="MUNICIPALITYUID", length=36)
    protected String municipalityId;
    @Column(name="TIMETABLEUID", length=36)
    protected String timetableId;
    @Column(name="PROFILEUID", length=36)
    protected String profileId;
    @Transient
    private OperationalArea operationalArea;
    @Transient
    private ClientEntity client;
    @Transient
    private District district;
    @Transient
    private Municipality municipality;
    @Transient
    private DtcState state;
    @Transient
    private Timetable timetable;
    @Transient
    private Profile profile;
    @Transient
    private Set<Alarm> alarm;
    @Transient
    private Set<Event> events;
    @Transient
    private Set<DtcService> services;
    @Transient
    private Set<SpecialDay> specialDays;
    @Transient
    private Set<ServiceStopwatch> timers;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Dtc() {
    }

    public Dtc(Dtc original) {
        this.copy(original);
    }

    public void copy(Dtc original) {
        if (original == null) {
            return;
        }
        this.deleted = original.getDeleted();
        this.birthDate = original.getBirthDate();
        this.deathDate = original.getDeathDate();
        this.rtuuid = original.getRtuuid();
        this.name = original.getName();
        this.secundarySubstation = original.getSecundarySubstation();
        this.latitude = original.getLatitude();
        this.longitude = original.getLongitude();
        this.hasPhotocell = original.getHasPhotocell();
        this.ipAddress = original.getIpAddress();
        this.operationalAreaId = original.getOperationalAreaId();
        this.clientId = original.getClientId();
        this.districtId = original.getDistrictId();
        this.municipalityId = original.getMunicipalityId();
        this.timetableId = original.getTimetableId();
        this.profileId = original.getProfileId();
    }

    public String getDeleted() {
        return this.deleted;
    }

    public void setDeleted(String deleted) {
        this.deleted = deleted;
    }

    public Date getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    public Date getDeathDate() {
        return this.deathDate;
    }

    public void setDeathDate(Date deathDate) {
        this.deathDate = deathDate;
    }

    public String getRtuuid() {
        return this.rtuuid;
    }

    public void setRtuuid(String rtuuid) {
        this.rtuuid = rtuuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSecundarySubstation() {
        return this.secundarySubstation;
    }

    public void setSecundarySubstation(String secundarySubstation) {
        this.secundarySubstation = secundarySubstation;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public Boolean getHasPhotocell() {
        return this.hasPhotocell;
    }

    public void setHasPhotocell(Boolean hasPhotocell) {
        this.hasPhotocell = hasPhotocell;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getOperationalAreaId() {
        return this.operationalAreaId;
    }

    public void setOperationalAreaId(String operationalAreaId) {
        if (operationalAreaId == null || !operationalAreaId.equals(this.operationalAreaId)) {
            this.operationalArea = null;
        }
        this.operationalAreaId = operationalAreaId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        if (clientId == null || !clientId.equals(this.clientId)) {
            this.client = null;
        }
        this.clientId = clientId;
    }

    public String getDistrictId() {
        return this.districtId;
    }

    public void setDistrictId(String districtId) {
        if (districtId == null || !districtId.equals(this.districtId)) {
            this.district = null;
        }
        this.districtId = districtId;
    }

    public String getMunicipalityId() {
        return this.municipalityId;
    }

    public void setMunicipalityId(String municipalityId) {
        if (municipalityId == null || !municipalityId.equals(this.municipalityId)) {
            this.municipality = null;
        }
        this.municipalityId = municipalityId;
    }

    public String getTimetableId() {
        return this.timetableId;
    }

    public void setTimetableId(String timetableId) {
        if (timetableId == null || !timetableId.equals(this.timetableId)) {
            this.timetable = null;
        }
        this.timetableId = timetableId;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public void setProfileId(String profileId) {
        if (profileId == null || !profileId.equals(this.profileId)) {
            this.profile = null;
        }
        this.profileId = profileId;
    }

    public OperationalArea getOperationalArea() {
        return this.operationalArea;
    }

    public void setOperationalArea(OperationalArea operationalArea) {
        this.operationalArea = operationalArea;
        this.operationalAreaId = operationalArea != null ? operationalArea.getId() : null;
    }

    public ClientEntity getClient() {
        return this.client;
    }

    public void setClient(ClientEntity client) {
        this.client = client;
        this.clientId = client != null ? client.getId() : null;
    }

    public District getDistrict() {
        return this.district;
    }

    public void setDistrict(District district) {
        this.district = district;
        this.districtId = district != null ? district.getId() : null;
    }

    public Municipality getMunicipality() {
        return this.municipality;
    }

    public void setMunicipality(Municipality municipality) {
        this.municipality = municipality;
        this.municipalityId = municipality != null ? municipality.getId() : null;
    }

    public DtcState getState() {
        return this.state;
    }

    public void setState(DtcState state) {
        this.state = state;
    }

    public Timetable getTimetable() {
        return this.timetable;
    }

    public void setTimetable(Timetable timetable) {
        this.timetable = timetable;
        this.timetableId = timetable != null ? timetable.getId() : null;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
        this.profileId = profile != null ? profile.getId() : null;
    }

    public Set<Alarm> getAlarm() {
        return this.alarm;
    }

    public void setAlarm(Set<Alarm> alarm) {
        this.alarm = alarm;
    }

    public Set<Event> getEvents() {
        return this.events;
    }

    public void setEvents(Set<Event> events) {
        this.events = events;
    }

    public Set<DtcService> getServices() {
        return this.services;
    }

    public void setServices(Set<DtcService> services) {
        this.services = services;
    }

    public Set<SpecialDay> getSpecialDays() {
        return this.specialDays;
    }

    public void setSpecialDays(Set<SpecialDay> specialDays) {
        this.specialDays = specialDays;
    }

    public Set<ServiceStopwatch> getTimers() {
        return this.timers;
    }

    public void setTimers(Set<ServiceStopwatch> timers) {
        this.timers = timers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{id: ").append(this.getId());
        sb.append(", version: ").append(this.getVersion());
        sb.append(", deleted: ").append(this.deleted);
        sb.append(", birthDate: ").append(this.birthDate);
        sb.append(", deathDate: ").append(this.deathDate);
        sb.append(", rtuuid: ").append(this.rtuuid);
        sb.append(", name: ").append(this.name);
        sb.append(", secundarySubstation: ").append(this.secundarySubstation);
        sb.append(", latitude: ").append(this.latitude);
        sb.append(", longitude: ").append(this.longitude);
        sb.append(", hasPhotocell: ").append(this.hasPhotocell);
        sb.append(", ipAddress: ").append(this.ipAddress);
        sb.append(", operationalAreaId: ").append(this.operationalAreaId);
        sb.append(", clientId: ").append(this.clientId);
        sb.append(", districtId: ").append(this.districtId);
        sb.append(", municipalityId: ").append(this.municipalityId);
        sb.append(", timetableId: ").append(this.timetableId);
        sb.append(", profileId: ").append(this.profileId);
        sb.append("}");
        return sb.toString();
    }
}

