/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.core.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import pt.efacec.smartlighting.common.core.entity.Period;
import pt.efacec.smartlighting.common.core.entity.SpecialDayService;
import pt.efacec.smartlighting.common.core.lov.ModeLOV;
import pt.efacec.smartlighting.common.entity.AbstractEntity;

@Entity
@Table(name="CONTROL")
public class Control
extends AbstractEntity<String> {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="CONTROLUID", length=36)
    private String id;
    @Version
    @Column
    private Integer version;
    @Column(name="TARGET_STATE", nullable=false)
    protected Boolean targetState;
    @Enumerated(value=EnumType.STRING)
    @Column(name="MODE", length=2)
    protected ModeLOV mode;
    @Temporal(value=TemporalType.TIME)
    @Column(name="TIME")
    protected Date time;
    @Column(name="OFFSET")
    protected Long offset;
    @Column(name="RANK", nullable=false)
    protected Long order;
    @Column(name="SPECIAL_DAY_SERVICE", length=36)
    protected String specialDayServiceId;
    @Column(name="PERIOD", length=36)
    protected String periodId;
    @Transient
    private SpecialDayService specialDayService;
    @Transient
    private Period period;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Control() {
    }

    public Control(Control original) {
        this.copy(original);
    }

    public void copy(Control original) {
        if (original == null) {
            return;
        }
        this.targetState = original.getTargetState();
        this.mode = original.getMode();
        this.time = original.getTime();
        this.offset = original.getOffset();
        this.order = original.getOrder();
        this.specialDayServiceId = original.getSpecialDayServiceId();
        this.periodId = original.getPeriodId();
    }

    public Boolean getTargetState() {
        return this.targetState;
    }

    public void setTargetState(Boolean targetState) {
        this.targetState = targetState;
    }

    public ModeLOV getMode() {
        return this.mode;
    }

    public void setMode(ModeLOV mode) {
        this.mode = mode;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public Long getOffset() {
        return this.offset;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public Long getOrder() {
        return this.order;
    }

    public void setOrder(Long order) {
        this.order = order;
    }

    public String getSpecialDayServiceId() {
        return this.specialDayServiceId;
    }

    public void setSpecialDayServiceId(String specialDayServiceId) {
        if (specialDayServiceId == null || !specialDayServiceId.equals(this.specialDayServiceId)) {
            this.specialDayService = null;
        }
        this.specialDayServiceId = specialDayServiceId;
    }

    public String getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(String periodId) {
        if (periodId == null || !periodId.equals(this.periodId)) {
            this.period = null;
        }
        this.periodId = periodId;
    }

    public SpecialDayService getSpecialDayService() {
        return this.specialDayService;
    }

    public void setSpecialDayService(SpecialDayService specialDayService) {
        this.specialDayService = specialDayService;
        this.specialDayServiceId = specialDayService != null ? specialDayService.getId() : null;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
        this.periodId = period != null ? period.getId() : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{id: ").append(this.getId());
        sb.append(", version: ").append(this.getVersion());
        sb.append(", targetState: ").append(this.targetState);
        sb.append(", mode: ").append((Object)this.mode);
        sb.append(", time: ").append(this.time);
        sb.append(", offset: ").append(this.offset);
        sb.append(", order: ").append(this.order);
        sb.append(", specialDayServiceId: ").append(this.specialDayServiceId);
        sb.append(", periodId: ").append(this.periodId);
        sb.append("}");
        return sb.toString();
    }
}

