/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.core.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import pt.efacec.smartlighting.common.core.entity.User;
import pt.efacec.smartlighting.common.core.lov.AuditActionContextLOV;
import pt.efacec.smartlighting.common.core.lov.AuditActionTypeLOV;
import pt.efacec.smartlighting.common.entity.AbstractEntity;

@Entity
@Table(name="AUDIT_ACTION")
public class AuditAction
extends AbstractEntity<String> {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="AUDIT_ACTIONUID", length=36)
    private String id;
    @Version
    @Column
    private Integer version;
    @Enumerated(value=EnumType.STRING)
    @Column(name="TYPE", length=10, nullable=false)
    protected AuditActionTypeLOV type;
    @Enumerated(value=EnumType.STRING)
    @Column(name="CONTEXT", length=3, nullable=false)
    protected AuditActionContextLOV context;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ACTION_DATE", nullable=false)
    protected Date date;
    @Column(name="TEXT", length=4000)
    protected String text;
    @Column(name="LOGIN")
    protected String login;
    @Column(name="USERUID", length=36)
    protected String userId;
    @Transient
    private User user;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public AuditAction() {
    }

    public AuditAction(AuditAction original) {
        this.copy(original);
    }

    public void copy(AuditAction original) {
        if (original == null) {
            return;
        }
        this.type = original.getType();
        this.context = original.getContext();
        this.date = original.getDate();
        this.text = original.getText();
        this.login = original.getLogin();
        this.userId = original.getUserId();
    }

    public AuditActionTypeLOV getType() {
        return this.type;
    }

    public void setType(AuditActionTypeLOV type) {
        this.type = type;
    }

    public AuditActionContextLOV getContext() {
        return this.context;
    }

    public void setContext(AuditActionContextLOV context) {
        this.context = context;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        if (userId == null || !userId.equals(this.userId)) {
            this.user = null;
        }
        this.userId = userId;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.userId = user != null ? user.getId() : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{id: ").append(this.getId());
        sb.append(", version: ").append(this.getVersion());
        sb.append(", type: ").append((Object)this.type);
        sb.append(", context: ").append((Object)this.context);
        sb.append(", date: ").append(this.date);
        sb.append(", text: ").append(this.text);
        sb.append(", login: ").append(this.login);
        sb.append(", userId: ").append(this.userId);
        sb.append("}");
        return sb.toString();
    }
}

