/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.common.core.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.DtcService;
import pt.efacec.smartlighting.common.core.lov.AlarmNatureLOV;
import pt.efacec.smartlighting.common.core.lov.AlarmTypeLOV;
import pt.efacec.smartlighting.common.entity.AbstractEntity;

@Entity
@Table(name="ALARM")
public class Alarm
extends AbstractEntity<String> {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="ALARMUID", length=36)
    private String id;
    @Version
    @Column
    private Integer version;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="NATURE", length=3)
    protected AlarmNatureLOV nature;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="TYPE", length=11)
    protected AlarmTypeLOV type;
    @Column(name="DESCRIPTION")
    protected String description;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ERROR_DATE")
    protected Date errorDate;
    @Column(name="DTC_NAME")
    protected String dtcName;
    @Column(name="SERVICE_NAME")
    protected String serviceName;
    @Column(name="DTCUID", length=36)
    protected String dtcId;
    @Column(name="DTC_SERVICEUID", length=36)
    protected String serviceId;
    @Transient
    private Dtc dtc;
    @Transient
    private DtcService service;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Alarm() {
    }

    public Alarm(Alarm original) {
        this.copy(original);
    }

    public void copy(Alarm original) {
        if (original == null) {
            return;
        }
        this.nature = original.getNature();
        this.type = original.getType();
        this.description = original.getDescription();
        this.errorDate = original.getErrorDate();
        this.dtcName = original.getDtcName();
        this.serviceName = original.getServiceName();
        this.dtcId = original.getDtcId();
        this.serviceId = original.getServiceId();
    }

    public AlarmNatureLOV getNature() {
        return this.nature;
    }

    public void setNature(AlarmNatureLOV nature) {
        this.nature = nature;
    }

    public AlarmTypeLOV getType() {
        return this.type;
    }

    public void setType(AlarmTypeLOV type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getErrorDate() {
        return this.errorDate;
    }

    public void setErrorDate(Date errorDate) {
        this.errorDate = errorDate;
    }

    public String getDtcName() {
        return this.dtcName;
    }

    public void setDtcName(String dtcName) {
        this.dtcName = dtcName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getDtcId() {
        return this.dtcId;
    }

    public void setDtcId(String dtcId) {
        if (dtcId == null || !dtcId.equals(this.dtcId)) {
            this.dtc = null;
        }
        this.dtcId = dtcId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        if (serviceId == null || !serviceId.equals(this.serviceId)) {
            this.service = null;
        }
        this.serviceId = serviceId;
    }

    public Dtc getDtc() {
        return this.dtc;
    }

    public void setDtc(Dtc dtc) {
        this.dtc = dtc;
        this.dtcId = dtc != null ? dtc.getId() : null;
    }

    public DtcService getService() {
        return this.service;
    }

    public void setService(DtcService service) {
        this.service = service;
        this.serviceId = service != null ? service.getId() : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{id: ").append(this.getId());
        sb.append(", version: ").append(this.getVersion());
        sb.append(", nature: ").append((Object)this.nature);
        sb.append(", type: ").append((Object)this.type);
        sb.append(", description: ").append(this.description);
        sb.append(", errorDate: ").append(this.errorDate);
        sb.append(", dtcName: ").append(this.dtcName);
        sb.append(", serviceName: ").append(this.serviceName);
        sb.append(", dtcId: ").append(this.dtcId);
        sb.append(", serviceId: ").append(this.serviceId);
        sb.append("}");
        return sb.toString();
    }
}

