/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.client;

import com.caucho.hessian.client.HessianConnection;
import com.caucho.hessian.client.HessianConnectionFactory;
import com.caucho.hessian.client.HessianProxyFactory;
import com.caucho.hessian.client.HessianURLConnection;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HessianHTTPSURLConnectionFactory
implements HessianConnectionFactory {
    private static final Logger log = Logger.getLogger(HessianHTTPSURLConnectionFactory.class.getName());
    private HessianProxyFactory _proxyFactory;
    private SSLSocketFactory _socketFactory;

    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this._socketFactory = sslSocketFactory;
    }

    public void setHessianProxyFactory(HessianProxyFactory factory) {
        this._proxyFactory = factory;
    }

    public HessianConnection open(URL url) throws IOException {
        long connectTimeout;
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " open(" + url + ")");
        }
        URLConnection conn = url.openConnection();
        if (this._socketFactory != null && conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(this._socketFactory);
        }
        if ((connectTimeout = this._proxyFactory.getConnectTimeout()) >= 0L) {
            conn.setConnectTimeout((int)connectTimeout);
        }
        conn.setDoOutput(true);
        long readTimeout = this._proxyFactory.getReadTimeout();
        if (readTimeout > 0L) {
            try {
                conn.setReadTimeout((int)readTimeout);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new HessianURLConnection(url, conn);
    }
}

