/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.CompositeChannelBuffer;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DownstreamMessageEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.ReceiveBufferSizePredictor;
import org.jboss.netty.channel.socket.nio.NioAcceptedSocketChannel;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannel;
import org.jboss.netty.channel.socket.nio.NioProviderMetadata;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.internal.IoWorkerRunnable;
import org.jboss.netty.util.internal.LinkedTransferQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioWorker
implements Runnable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioWorker.class);
    private static final int CONSTRAINT_LEVEL = NioProviderMetadata.CONSTRAINT_LEVEL;
    private final int bossId;
    private final int id;
    private final Executor executor;
    private boolean started;
    private volatile Thread thread;
    volatile Selector selector;
    private final AtomicBoolean wakenUp = new AtomicBoolean();
    private final ReadWriteLock selectorGuard = new ReentrantReadWriteLock();
    private final Object startStopLock = new Object();
    private final Queue<Runnable> registerTaskQueue = new LinkedTransferQueue<Runnable>();
    private final Queue<Runnable> writeTaskQueue = new LinkedTransferQueue<Runnable>();

    NioWorker(int bossId, int id, Executor executor) {
        this.bossId = bossId;
        this.id = id;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(NioSocketChannel channel, ChannelFuture future) {
        Selector selector;
        boolean server = !(channel instanceof NioClientSocketChannel);
        RegisterTask registerTask = new RegisterTask(channel, future, server);
        Object object = this.startStopLock;
        synchronized (object) {
            if (!this.started) {
                try {
                    this.selector = selector = Selector.open();
                }
                catch (Throwable t) {
                    throw new ChannelException("Failed to create a selector.", t);
                }
                String threadName = (server ? "New I/O server worker #" : "New I/O client worker #") + this.bossId + '-' + this.id;
                boolean success = false;
                try {
                    this.executor.execute(new IoWorkerRunnable(new ThreadRenamingRunnable(this, threadName)));
                    success = true;
                }
                finally {
                    if (!success) {
                        try {
                            selector.close();
                        }
                        catch (Throwable t) {
                            logger.warn("Failed to close a selector.", t);
                        }
                        selector = null;
                        this.selector = null;
                    }
                }
            }
            selector = this.selector;
            assert (selector != null && selector.isOpen());
            this.started = true;
            boolean offered = this.registerTaskQueue.offer(registerTask);
            assert (offered);
        }
        if (this.wakenUp.compareAndSet(false, true)) {
            selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.thread = Thread.currentThread();
        boolean shutdown = false;
        Selector selector = this.selector;
        while (true) {
            this.wakenUp.set(false);
            if (CONSTRAINT_LEVEL != 0) {
                this.selectorGuard.writeLock().lock();
                this.selectorGuard.writeLock().unlock();
            }
            try {
                int selectedKeyCount = selector.select(500L);
                if (this.wakenUp.get()) {
                    selector.wakeup();
                }
                this.processRegisterTaskQueue();
                this.processWriteTaskQueue();
                if (selectedKeyCount > 0) {
                    NioWorker.processSelectedKeys(selector.selectedKeys());
                }
                if (selector.keys().isEmpty()) {
                    if (shutdown || this.executor instanceof ExecutorService && ((ExecutorService)this.executor).isShutdown()) {
                        Object object = this.startStopLock;
                        synchronized (object) {
                            if (this.registerTaskQueue.isEmpty() && selector.keys().isEmpty()) {
                                this.started = false;
                                try {
                                    selector.close();
                                }
                                catch (IOException e) {
                                    logger.warn("Failed to close a selector.", e);
                                }
                                finally {
                                    this.selector = null;
                                }
                                break;
                            }
                            shutdown = false;
                            continue;
                        }
                    }
                    shutdown = true;
                    continue;
                }
                shutdown = false;
            }
            catch (Throwable t) {
                logger.warn("Unexpected exception in the selector loop.", t);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    private void processRegisterTaskQueue() {
        Runnable task;
        while ((task = this.registerTaskQueue.poll()) != null) {
            task.run();
        }
    }

    private void processWriteTaskQueue() {
        Runnable task;
        while ((task = this.writeTaskQueue.poll()) != null) {
            task.run();
        }
    }

    private static void processSelectedKeys(Set<SelectionKey> selectedKeys) {
        Iterator<SelectionKey> i = selectedKeys.iterator();
        while (i.hasNext()) {
            SelectionKey k = i.next();
            i.remove();
            try {
                int readyOps = k.readyOps();
                if ((readyOps & 1) != 0 && !NioWorker.read(k) || (readyOps & 4) == 0) continue;
                NioWorker.write(k);
            }
            catch (CancelledKeyException e) {
                NioWorker.close(k);
            }
        }
    }

    private static boolean read(SelectionKey k) {
        ScatteringByteChannel ch = (ScatteringByteChannel)((Object)k.channel());
        NioSocketChannel channel = (NioSocketChannel)k.attachment();
        ReceiveBufferSizePredictor predictor = channel.getConfig().getReceiveBufferSizePredictor();
        ChannelBufferFactory bufferFactory = channel.getConfig().getBufferFactory();
        ChannelBuffer buffer = bufferFactory.getBuffer(predictor.nextReceiveBufferSize());
        int ret = 0;
        int readBytes = 0;
        boolean failure = true;
        try {
            while ((ret = buffer.writeBytes(ch, buffer.writableBytes())) > 0) {
                readBytes += ret;
                if (buffer.writable()) continue;
            }
            failure = false;
        }
        catch (AsynchronousCloseException e) {
        }
        catch (Throwable t) {
            Channels.fireExceptionCaught(channel, t);
        }
        if (readBytes > 0) {
            predictor.previousReceiveBufferSize(readBytes);
            Channels.fireMessageReceived(channel, (Object)buffer);
        }
        if (ret < 0 || failure) {
            NioWorker.close(k);
            return false;
        }
        return true;
    }

    private static void write(SelectionKey k) {
        NioSocketChannel ch = (NioSocketChannel)k.attachment();
        NioWorker.write(ch, false);
    }

    private static void close(SelectionKey k) {
        NioSocketChannel ch = (NioSocketChannel)k.attachment();
        NioWorker.close(ch, Channels.succeededFuture(ch));
    }

    static void write(NioSocketChannel channel, boolean mightNeedWakeup) {
        if (!channel.isConnected()) {
            NioWorker.cleanUpWriteBuffer(channel);
            return;
        }
        if (mightNeedWakeup && NioWorker.scheduleWriteIfNecessary(channel)) {
            return;
        }
        if (channel.inWriteNowLoop) {
            NioWorker.scheduleWriteIfNecessary(channel);
        } else {
            NioWorker.writeNow(channel, channel.getConfig().getWriteSpinCount());
        }
    }

    private static boolean scheduleWriteIfNecessary(NioSocketChannel channel) {
        NioWorker worker = channel.worker;
        Thread currentThread = Thread.currentThread();
        Thread workerThread = worker.thread;
        if (workerThread == null || currentThread != workerThread) {
            Selector workerSelector;
            if (channel.writeTaskInTaskQueue.compareAndSet(false, true)) {
                boolean offered = worker.writeTaskQueue.offer(channel.writeTask);
                assert (offered);
            }
            if ((!(channel instanceof NioAcceptedSocketChannel) || ((NioAcceptedSocketChannel)channel).bossThread != currentThread) && (workerSelector = worker.selector) != null && worker.wakenUp.compareAndSet(false, true)) {
                workerSelector.wakeup();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeNow(NioSocketChannel channel, int writeSpinCount) {
        boolean open = true;
        boolean addOpWrite = false;
        boolean removeOpWrite = false;
        int writtenBytes = 0;
        Queue<MessageEvent> writeBuffer = channel.writeBuffer;
        Object object = channel.writeLock;
        synchronized (object) {
            channel.inWriteNowLoop = true;
            MessageEvent evt = channel.currentWriteEvent;
            while (true) {
                int bufIdx;
                ChannelBuffer buf;
                if (evt == null) {
                    evt = writeBuffer.poll();
                    if (evt == null) {
                        channel.currentWriteEvent = null;
                        removeOpWrite = true;
                        break;
                    }
                    evt = NioWorker.consolidateComposite(evt);
                    buf = (ChannelBuffer)evt.getMessage();
                    bufIdx = buf.readerIndex();
                } else {
                    buf = (ChannelBuffer)evt.getMessage();
                    bufIdx = channel.currentWriteIndex;
                }
                try {
                    for (int i = writeSpinCount; i > 0; --i) {
                        int localWrittenBytes = buf.getBytes(bufIdx, channel.socket, buf.writerIndex() - bufIdx);
                        if (localWrittenBytes == 0) continue;
                        bufIdx += localWrittenBytes;
                        writtenBytes += localWrittenBytes;
                        break;
                    }
                    if (bufIdx == buf.writerIndex()) {
                        channel.currentWriteEvent = null;
                        evt.getFuture().setSuccess();
                        evt = null;
                        continue;
                    }
                    channel.currentWriteEvent = evt;
                    channel.currentWriteIndex = bufIdx;
                    addOpWrite = true;
                }
                catch (AsynchronousCloseException e) {
                    continue;
                }
                catch (Throwable t) {
                    evt.getFuture().setFailure(t);
                    evt = null;
                    Channels.fireExceptionCaught(channel, t);
                    if (!(t instanceof IOException)) continue;
                    open = false;
                    NioWorker.close(channel, Channels.succeededFuture(channel));
                    continue;
                }
                break;
            }
            channel.inWriteNowLoop = false;
        }
        Channels.fireWriteComplete(channel, writtenBytes);
        if (open) {
            if (addOpWrite) {
                NioWorker.setOpWrite(channel);
            } else if (removeOpWrite) {
                NioWorker.clearOpWrite(channel);
            }
        }
    }

    static MessageEvent consolidateComposite(MessageEvent e) {
        Object m = e.getMessage();
        if (m instanceof CompositeChannelBuffer) {
            e = new DownstreamMessageEvent(e.getChannel(), e.getFuture(), ((CompositeChannelBuffer)m).copy(), e.getRemoteAddress());
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setOpWrite(NioSocketChannel channel) {
        int interestOps;
        NioWorker worker = channel.worker;
        Selector selector = worker.selector;
        SelectionKey key = channel.socket.keyFor(selector);
        if (key == null) {
            return;
        }
        if (!key.isValid()) {
            NioWorker.close(key);
            return;
        }
        boolean changed = false;
        Object object = channel.interestOpsLock;
        synchronized (object) {
            interestOps = channel.getRawInterestOps();
            if ((interestOps & 4) == 0) {
                key.interestOps(interestOps |= 4);
                changed = true;
            }
        }
        if (changed) {
            channel.setRawInterestOpsNow(interestOps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearOpWrite(NioSocketChannel channel) {
        int interestOps;
        NioWorker worker = channel.worker;
        Selector selector = worker.selector;
        SelectionKey key = channel.socket.keyFor(selector);
        if (key == null) {
            return;
        }
        if (!key.isValid()) {
            NioWorker.close(key);
            return;
        }
        boolean changed = false;
        Object object = channel.interestOpsLock;
        synchronized (object) {
            interestOps = channel.getRawInterestOps();
            if ((interestOps & 4) != 0) {
                key.interestOps(interestOps &= 0xFFFFFFFB);
                changed = true;
            }
        }
        if (changed) {
            channel.setRawInterestOpsNow(interestOps);
        }
    }

    static void close(NioSocketChannel channel, ChannelFuture future) {
        NioWorker worker = channel.worker;
        Selector selector = worker.selector;
        SelectionKey key = channel.socket.keyFor(selector);
        if (key != null) {
            key.cancel();
        }
        boolean connected = channel.isConnected();
        boolean bound = channel.isBound();
        try {
            channel.socket.close();
            if (channel.setClosed()) {
                future.setSuccess();
                if (connected) {
                    Channels.fireChannelDisconnected(channel);
                }
                if (bound) {
                    Channels.fireChannelUnbound(channel);
                }
                NioWorker.cleanUpWriteBuffer(channel);
                Channels.fireChannelClosed(channel);
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUpWriteBuffer(NioSocketChannel channel) {
        Exception cause = null;
        boolean fireExceptionCaught = false;
        Object object = channel.writeLock;
        synchronized (object) {
            Queue<MessageEvent> writeBuffer;
            MessageEvent evt = channel.currentWriteEvent;
            if (evt != null) {
                channel.currentWriteEvent = null;
                channel.currentWriteIndex = 0;
                cause = channel.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
                evt.getFuture().setFailure(cause);
                fireExceptionCaught = true;
            }
            if (!(writeBuffer = channel.writeBuffer).isEmpty()) {
                if (cause == null) {
                    cause = channel.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
                }
                while ((evt = writeBuffer.poll()) != null) {
                    evt.getFuture().setFailure(cause);
                    fireExceptionCaught = true;
                }
            }
        }
        if (fireExceptionCaught) {
            Channels.fireExceptionCaught(channel, (Throwable)cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setInterestOps(NioSocketChannel channel, ChannelFuture future, int interestOps) {
        boolean changed = false;
        try {
            Object object = channel.interestOpsLock;
            synchronized (object) {
                NioWorker worker = channel.worker;
                Selector selector = worker.selector;
                SelectionKey key = channel.socket.keyFor(selector);
                if (key == null || selector == null) {
                    channel.setRawInterestOpsNow(interestOps);
                    return;
                }
                interestOps &= 0xFFFFFFFB;
                interestOps |= channel.getRawInterestOps() & 4;
                switch (CONSTRAINT_LEVEL) {
                    case 0: {
                        if (channel.getRawInterestOps() == interestOps) break;
                        key.interestOps(interestOps);
                        if (Thread.currentThread() != worker.thread && worker.wakenUp.compareAndSet(false, true)) {
                            selector.wakeup();
                        }
                        changed = true;
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (channel.getRawInterestOps() == interestOps) break;
                        if (Thread.currentThread() == worker.thread) {
                            key.interestOps(interestOps);
                            changed = true;
                            break;
                        }
                        worker.selectorGuard.readLock().lock();
                        try {
                            if (worker.wakenUp.compareAndSet(false, true)) {
                                selector.wakeup();
                            }
                            key.interestOps(interestOps);
                            changed = true;
                            break;
                        }
                        finally {
                            worker.selectorGuard.readLock().unlock();
                        }
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            future.setSuccess();
            if (changed) {
                channel.setRawInterestOpsNow(interestOps);
                Channels.fireChannelInterestChanged(channel);
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private final class RegisterTask
    implements Runnable {
        private final NioSocketChannel channel;
        private final ChannelFuture future;
        private final boolean server;

        RegisterTask(NioSocketChannel channel, ChannelFuture future, boolean server) {
            this.channel = channel;
            this.future = future;
            this.server = server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            InetSocketAddress remoteAddress;
            InetSocketAddress localAddress;
            block12: {
                localAddress = this.channel.getLocalAddress();
                remoteAddress = this.channel.getRemoteAddress();
                if (localAddress == null || remoteAddress == null) {
                    if (this.future != null) {
                        this.future.setFailure(new ClosedChannelException());
                    }
                    NioWorker.close(this.channel, Channels.succeededFuture(this.channel));
                    return;
                }
                try {
                    if (this.server) {
                        this.channel.socket.configureBlocking(false);
                    }
                    Object object = this.channel.interestOpsLock;
                    synchronized (object) {
                        this.channel.socket.register(NioWorker.this.selector, this.channel.getRawInterestOps(), this.channel);
                    }
                    if (this.future != null) {
                        this.future.setSuccess();
                    }
                }
                catch (IOException e) {
                    if (this.future != null) {
                        this.future.setFailure(e);
                    }
                    NioWorker.close(this.channel, Channels.succeededFuture(this.channel));
                    if (e instanceof ClosedChannelException) break block12;
                    throw new ChannelException("Failed to register a socket to the selector.", e);
                }
            }
            if (!this.server) {
                if (!((NioClientSocketChannel)this.channel).boundManually) {
                    Channels.fireChannelBound(this.channel, (SocketAddress)localAddress);
                }
                Channels.fireChannelConnected(this.channel, (SocketAddress)remoteAddress);
            }
        }
    }
}

