/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.commons.lang;

import com.mysema.commons.lang.Assert;

public class Pair<F, S> {
    private final F first;
    private final S second;

    public Pair(F first, S second) {
        this.first = Assert.notNull(first, "first");
        this.second = Assert.notNull(second, "second");
    }

    public static <F, S> Pair<F, S> of(F f, S s) {
        return new Pair<F, S>(f, s);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Pair) {
            return ((Pair)o).first.equals(this.first) && ((Pair)o).second.equals(this.second);
        }
        return false;
    }

    public F getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    public int hashCode() {
        return 31 * this.first.hashCode() + this.second.hashCode();
    }
}

