/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.google.common.primitives.Primitives;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionBase;
import com.mysema.query.types.ExpressionException;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.Visitor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class ConstructorExpression<T>
extends ExpressionBase<T>
implements FactoryExpression<T> {
    private static final long serialVersionUID = -602747921848073175L;
    private final List<Expression<?>> args;
    private final Class<?>[] parameterTypes;
    @Nullable
    private transient Constructor<?> constructor;

    private static Class<?> normalize(Class<?> clazz) {
        return Primitives.wrap(clazz);
    }

    private static Class<?>[] getRealParameters(Class<?> type, Class<?>[] givenTypes) {
        for (Constructor<?> c : type.getConstructors()) {
            Class<?>[] paramTypes = c.getParameterTypes();
            if (paramTypes.length != givenTypes.length) continue;
            boolean found = true;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (ConstructorExpression.normalize(paramTypes[i]).isAssignableFrom(ConstructorExpression.normalize(givenTypes[i]))) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return paramTypes;
        }
        throw new ExpressionException("Got no matching constructor");
    }

    public static <D> ConstructorExpression<D> create(Class<D> type, Expression<?> ... args) {
        Class[] paramTypes = new Class[args.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypes[i] = args[i].getType();
        }
        return new ConstructorExpression<D>(type, paramTypes, args);
    }

    public ConstructorExpression(Class<T> type, Class<?>[] paramTypes, Expression<?> ... args) {
        this(type, paramTypes, Arrays.asList(args));
    }

    public ConstructorExpression(Class<T> type, Class<?>[] paramTypes, List<Expression<?>> args) {
        super(type);
        this.parameterTypes = (Class[])ConstructorExpression.getRealParameters(type, paramTypes).clone();
        this.args = args;
    }

    public Expression<T> as(Path<T> alias) {
        return OperationImpl.create(this.getType(), Ops.ALIAS, this, alias);
    }

    public Expression<T> as(String alias) {
        return this.as(new PathImpl(this.getType(), alias));
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ConstructorExpression) {
            ConstructorExpression c = (ConstructorExpression)obj;
            return Arrays.equals(this.parameterTypes, c.parameterTypes) && ((Object)this.args).equals(c.args) && this.getType().equals(c.getType());
        }
        return false;
    }

    @Override
    public final List<Expression<?>> getArgs() {
        return this.args;
    }

    @Override
    public T newInstance(Object ... args) {
        try {
            if (this.constructor == null) {
                this.constructor = this.getType().getConstructor(this.parameterTypes);
            }
            return (T)this.constructor.newInstance(args);
        }
        catch (SecurityException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new ExpressionException(e.getMessage(), e);
        }
    }
}

