/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query;

import com.google.common.base.Objects;
import com.mysema.commons.lang.Assert;
import com.mysema.query.BooleanBuilder;
import com.mysema.query.JoinFlag;
import com.mysema.query.JoinType;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;

public final class JoinExpression
implements Serializable {
    private static final long serialVersionUID = -1131755765747174886L;
    private final BooleanBuilder condition = new BooleanBuilder();
    private final Set<JoinFlag> flags = new LinkedHashSet<JoinFlag>();
    private final Expression<?> target;
    private final JoinType type;

    public JoinExpression(JoinType type, Expression<?> target) {
        this.type = (JoinType)((Object)Assert.notNull((Object)((Object)type), (String)"type"));
        this.target = (Expression)Assert.notNull(target, (String)"target");
    }

    public Predicate getCondition() {
        return this.condition.getValue();
    }

    public void addCondition(Predicate c) {
        this.condition.and(c);
    }

    public Expression<?> getTarget() {
        return this.target;
    }

    public JoinType getType() {
        return this.type;
    }

    public void addFlag(JoinFlag flag) {
        this.flags.add(flag);
    }

    public boolean hasFlag(JoinFlag flag) {
        return this.flags.contains(flag);
    }

    public Set<JoinFlag> getFlags() {
        return this.flags;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.type).append(" ").append(this.target);
        if (this.condition.getValue() != null) {
            builder.append(" ON ").append(this.condition);
        }
        return builder.toString();
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JoinExpression) {
            JoinExpression j = (JoinExpression)o;
            return Objects.equal((Object)this.condition, (Object)j.condition) && Objects.equal(this.target, j.target) && Objects.equal((Object)((Object)this.type), (Object)((Object)j.type));
        }
        return false;
    }
}

