/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import pt.efacec.smartlighting.ITransaction;
import pt.efacec.smartlighting.IValidationCenario;
import pt.efacec.smartlighting.SMRAnalitics;
import pt.efacec.smartlighting.Statistic;
import pt.efacec.smartlighting.common.core.dto.AuditReportSearchDTO;
import pt.efacec.smartlighting.common.core.dto.DtcStateSearchDTO;
import pt.efacec.smartlighting.common.core.entity.Control;
import pt.efacec.smartlighting.common.core.entity.Period;
import pt.efacec.smartlighting.common.core.entity.Timetable;
import pt.efacec.smartlighting.common.core.entity.User;
import pt.efacec.smartlighting.common.core.lov.ModeLOV;
import pt.efacec.smartlighting.common.core.service.IManagementService;
import pt.efacec.smartlighting.common.core.service.IReportService;
import pt.efacec.smartlighting.common.util.Context;
import pt.efacec.toolkit.misc.Dates;
import pt.efacec.toolkit.misc.Strings;

public class ValidationCenario
implements IValidationCenario {
    private static final Logger logger = Logger.getLogger(ValidationCenario.class);
    private static final String PASSWORD = "DUMMY";
    @Autowired
    private ITransaction transaction;
    @Autowired
    private IManagementService managementService;
    @Autowired
    private IReportService reportService;
    private String name;
    private int session;
    private boolean fail;
    private Statistic callInsertSchedulesStat = new Statistic(String.format("Schedule Creation x%s", SMRAnalitics.SCHEDULES_BATCH_SIZE));
    private Statistic callInsertUsersStat = new Statistic(String.format("User Creation x%s", SMRAnalitics.USERS_BATCH_SIZE));
    private Statistic callUpdateSchedulesStat = new Statistic(String.format("Schedule Modification x%s", SMRAnalitics.SCHEDULES_BATCH_SIZE));
    private Statistic callSelectSchedulesStat = new Statistic(String.format("Schedule Retrieval x%s", SMRAnalitics.SCHEDULES_BATCH_SIZE));
    private Statistic callUpdateUsersStat = new Statistic(String.format("User Modification x%s", SMRAnalitics.USERS_BATCH_SIZE));
    private Statistic callDeleteSchedulesStat = new Statistic(String.format("Schedule Deletion x%s", SMRAnalitics.SCHEDULES_BATCH_SIZE));
    private Statistic callDeleteUsersStat = new Statistic(String.format("User Deletion x%s", SMRAnalitics.USERS_BATCH_SIZE));
    private Statistic callLoginStat = new Statistic(String.format("Login x%s", SMRAnalitics.LOGINS_BATCH_SIZE));
    private Statistic callLogoutStat = new Statistic(String.format("Logout x%s", SMRAnalitics.LOGINS_BATCH_SIZE));
    private Statistic callFailLoginStat = new Statistic(String.format("Failed Login x%s", SMRAnalitics.FAIL_LOGINS_BATCH_SIZE));
    private Statistic callStateReportStat = new Statistic(String.format("State Report x%s", SMRAnalitics.REPORTS_BATCH_SIZE));
    private Statistic callAuditingReportStat = new Statistic(String.format("Auditing Report x%s", SMRAnalitics.REPORTS_BATCH_SIZE));

    @Override
    public void setSession(int session) {
        this.session = session;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isFail() {
        return this.fail;
    }

    @Override
    public void setFail(boolean fail) {
        this.fail = fail;
    }

    @Override
    public Statistic getCallInsertSchedulesStat() {
        return this.callInsertSchedulesStat;
    }

    @Override
    public Statistic getCallInsertUsersStat() {
        return this.callInsertUsersStat;
    }

    @Override
    public Statistic getCallUpdateSchedulesStat() {
        return this.callUpdateSchedulesStat;
    }

    @Override
    public Statistic getCallSelectSchedulesStat() {
        return this.callSelectSchedulesStat;
    }

    @Override
    public Statistic getCallUpdateUsersStat() {
        return this.callUpdateUsersStat;
    }

    @Override
    public Statistic getCallDeleteSchedulesStat() {
        return this.callDeleteSchedulesStat;
    }

    @Override
    public Statistic getCallDeleteUsersStat() {
        return this.callDeleteUsersStat;
    }

    @Override
    public Statistic getCallLoginStat() {
        return this.callLoginStat;
    }

    @Override
    public Statistic getCallLogoutStat() {
        return this.callLogoutStat;
    }

    @Override
    public Statistic getCallFailLoginStat() {
        return this.callFailLoginStat;
    }

    @Override
    public Statistic getCallStateReportStat() {
        return this.callStateReportStat;
    }

    @Override
    public Statistic getCallAuditingReportStat() {
        return this.callAuditingReportStat;
    }

    @Override
    public void execute(int warmup) {
        Context.get().setUser(new User());
        ArrayList<String> scheduleIds = new ArrayList<String>();
        this.callInsertSchedules(scheduleIds, warmup > 0 ? warmup : SMRAnalitics.SCHEDULES_BATCH_SIZE, warmup > 0);
        ArrayList<User> users = new ArrayList<User>();
        this.callInsertUsers(users, warmup > 0 ? warmup : SMRAnalitics.USERS_BATCH_SIZE, warmup > 0);
        this.callLogin(users, warmup > 0 ? warmup : SMRAnalitics.LOGINS_BATCH_SIZE, warmup > 0);
        this.callFailLogin(users, warmup > 0 ? warmup : SMRAnalitics.FAIL_LOGINS_BATCH_SIZE, warmup > 0);
        this.callUpdateSchedules(scheduleIds, warmup > 0);
        if (warmup == 0) {
            this.compromise();
        }
        this.callUpdateUsers(users, warmup > 0);
        this.callDeleteSchedules(scheduleIds, warmup > 0);
        this.callDeleteUsers(users, warmup > 0);
        this.callStateReport(warmup > 0 ? warmup : SMRAnalitics.REPORTS_BATCH_SIZE, warmup > 0);
        this.callAuditingReport(warmup > 0 ? warmup : SMRAnalitics.REPORTS_BATCH_SIZE, warmup > 0);
    }

    public void mergeWith(IValidationCenario cenario) {
        this.callInsertSchedulesStat.addStats(cenario.getCallInsertSchedulesStat());
        this.callInsertUsersStat.addStats(cenario.getCallInsertUsersStat());
        this.callUpdateSchedulesStat.addStats(cenario.getCallUpdateSchedulesStat());
        this.callSelectSchedulesStat.addStats(cenario.getCallSelectSchedulesStat());
        this.callUpdateUsersStat.addStats(cenario.getCallUpdateUsersStat());
        this.callDeleteSchedulesStat.addStats(cenario.getCallDeleteSchedulesStat());
        this.callDeleteUsersStat.addStats(cenario.getCallDeleteUsersStat());
        this.callLoginStat.addStats(cenario.getCallLoginStat());
        this.callLogoutStat.addStats(cenario.getCallLogoutStat());
        this.callFailLoginStat.addStats(cenario.getCallFailLoginStat());
        this.callStateReportStat.addStats(cenario.getCallStateReportStat());
        this.callAuditingReportStat.addStats(cenario.getCallAuditingReportStat());
        this.fail = this.fail || cenario.isFail() || !this.callInsertSchedulesStat.isOk() || !this.callInsertUsersStat.isOk() || !this.callUpdateSchedulesStat.isOk() || !this.callSelectSchedulesStat.isOk() || !this.callUpdateUsersStat.isOk() || !this.callDeleteSchedulesStat.isOk() || !this.callDeleteUsersStat.isOk() || !this.callLoginStat.isOk() || !this.callLogoutStat.isOk() || !this.callFailLoginStat.isOk() || !this.callStateReportStat.isOk() || !this.callAuditingReportStat.isOk();
    }

    private void compromise() {
        String node = SMRAnalitics.COMPROMISE_NODE;
        if (!node.equals("")) {
            String sql = SMRAnalitics.COMPROMISE_SQL;
            logger.info((Object)("===> Launching attack: " + sql));
            try {
                Class.forName(SMRAnalitics.COMPROMISE_DRIVER);
                Connection conn = DriverManager.getConnection(node);
                Statement stmt = conn.createStatement();
                conn.setAutoCommit(true);
                try {
                    int affected = stmt.executeUpdate(sql);
                    if (affected == 0) {
                        logger.warn((Object)("No records were affected by the sql " + sql));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Unexpected error while compromising the node at " + node), (Throwable)e);
                }
                conn.close();
            }
            catch (Exception e) {
                logger.error((Object)("Unable to compromise node at " + node), (Throwable)e);
            }
        }
    }

    private void callInsertSchedules(List<String> ids, int loop, boolean warmup) {
        logger.info((Object)("===> " + this.warmUpMsg(warmup, loop) + this.callInsertSchedulesStat.getName()));
        try {
            Date start = new Date();
            Date end = Dates.moveDays((Date)start, (int)10);
            int i = 0;
            while (i < loop) {
                Timetable entity = new Timetable();
                String id = UUID.randomUUID().toString();
                ids.add(id);
                entity.setId(id);
                entity.setName("(" + this.name + ") SMR-TIMETABLE #" + i);
                HashSet<Period> periods = new HashSet<Period>();
                entity.setPeriods(periods);
                Period period = new Period();
                periods.add(period);
                String periodId = UUID.randomUUID().toString();
                period.setId(periodId);
                period.setStart(start);
                period.setEnd(end);
                period.setTimetableId(id);
                HashSet<Control> controls = new HashSet<Control>();
                period.setControls(controls);
                Control off = new Control();
                controls.add(off);
                off.setId(UUID.randomUUID().toString());
                off.setTargetState(Boolean.valueOf(false));
                off.setMode(ModeLOV.MA);
                off.setTime(new Date());
                off.setOrder(Long.valueOf(1L));
                off.setPeriodId(periodId);
                Control on = new Control();
                controls.add(on);
                on.setId(UUID.randomUUID().toString());
                on.setTargetState(Boolean.valueOf(true));
                on.setMode(ModeLOV.MA);
                on.setTime(new Date());
                on.setOrder(Long.valueOf(2L));
                on.setPeriodId(periodId);
                long now = System.currentTimeMillis();
                this.transaction.save(entity);
                if (!warmup) {
                    this.callInsertSchedulesStat.add(System.currentTimeMillis() - now);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            this.callInsertSchedulesStat.setOk(false);
            logger.error((Object)"Failed inserting schedules", (Throwable)ex);
        }
    }

    private void callInsertUsers(List<User> users, int loop, boolean warmup) {
        logger.info((Object)("===> " + this.warmUpMsg(warmup, loop) + this.callInsertUsersStat.getName()));
        try {
            String salt = Strings.generateSalt();
            String pass = Strings.getHash((String)PASSWORD, (String)salt);
            int i = 0;
            while (i < loop) {
                User entity = new User();
                String id = UUID.randomUUID().toString();
                users.add(entity);
                entity.setId(id);
                entity.setDeleted("0");
                entity.setLogin(String.valueOf(SMRAnalitics.LOGIN_PREFIX) + "-" + this.session + "-" + i);
                entity.setSalt(salt);
                entity.setPassword(pass);
                entity.setName("(" + this.name + ") SMR-USER #" + i);
                entity.setFailedLogins(Long.valueOf(0L));
                entity.setLocked(Boolean.valueOf(false));
                entity.setEmail(String.valueOf(entity.getLogin()) + "@efacec.com");
                long now = System.currentTimeMillis();
                this.transaction.save(entity);
                if (!warmup) {
                    this.callInsertUsersStat.add(System.currentTimeMillis() - now);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            this.callInsertUsersStat.setOk(false);
            logger.error((Object)"Failed inserting users", (Throwable)ex);
        }
    }

    private void callUpdateSchedules(List<String> ids, boolean warmup) {
        logger.info((Object)("===> " + this.warmUpMsg(warmup, ids.size()) + this.callUpdateSchedulesStat.getName()));
        logger.info((Object)("===> " + this.warmUpMsg(warmup, ids.size()) + this.callSelectSchedulesStat.getName()));
        try {
            Date start = Dates.beginOfDay((Date)new Date());
            start = Dates.moveDays((Date)start, (int)10);
            Date end = Dates.moveDays((Date)start, (int)10);
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            for (String id : ids) {
                Timetable entity = this.transaction.findTimetableById(id);
                String name = String.valueOf(entity.getName()) + " - UPDATED";
                entity.setName(name);
                Set periods = entity.getPeriods();
                for (Period period : periods) {
                    period.setStart(start);
                    period.setEnd(end);
                    Set controls = period.getControls();
                    for (Control control : controls) {
                        control.setMode(ModeLOV.CA);
                        control.setOffset(Long.valueOf(10L));
                        control.setTime(null);
                    }
                }
                long now = System.currentTimeMillis();
                this.transaction.save(entity);
                if (!warmup) {
                    this.callUpdateSchedulesStat.add(System.currentTimeMillis() - now);
                }
                now = System.currentTimeMillis();
                entity = this.transaction.findTimetableById(id);
                for (Period period : entity.getPeriods()) {
                    period.getControls();
                }
                if (warmup) continue;
                this.callSelectSchedulesStat.add(System.currentTimeMillis() - now);
                if (!name.equals(entity.getName())) {
                    this.callSelectSchedulesStat.setOk(false);
                    logger.error((Object)("Updated Schedule name is diferent for record " + entity.getId()));
                    continue;
                }
                for (Period period : entity.getPeriods()) {
                    if (!start.equals(period.getStart()) || !end.equals(period.getEnd())) {
                        this.callSelectSchedulesStat.setOk(false);
                        logger.error((Object)String.format("Updated Schedule Period is diferent for record %s\nExpected start: %s, end: %s\nGot start: %s end: %s", period.getId(), sdf.format(start), sdf.format(end), sdf.format(period.getStart()), sdf.format(period.getEnd())));
                        continue;
                    }
                    for (Control control : period.getControls()) {
                        if (ModeLOV.CA.equals((Object)control.getMode()) && control.getOffset().equals(10L) && control.getTime() == null) continue;
                        this.callSelectSchedulesStat.setOk(false);
                        logger.error((Object)("Updated Schedule Period Control is diferent for record " + control.getId()));
                    }
                }
            }
        }
        catch (Exception ex) {
            this.callUpdateSchedulesStat.setOk(false);
            this.callSelectSchedulesStat.setOk(false);
            logger.error((Object)"Failed updating and selecting schedules", (Throwable)ex);
        }
    }

    private void callUpdateUsers(List<User> users, boolean warmup) {
        logger.info((Object)("===> " + this.warmUpMsg(warmup, users.size()) + this.callUpdateUsersStat.getName()));
        try {
            for (User user : users) {
                User entity = this.transaction.findUserById(user.getId());
                entity.setDeleted(UUID.randomUUID().toString());
                entity.setDeathDate(new Date());
                entity.setLocked(Boolean.valueOf(true));
                entity.setLockedDate(new Date());
                long now = System.currentTimeMillis();
                this.transaction.save(entity);
                if (warmup) continue;
                this.callUpdateUsersStat.add(System.currentTimeMillis() - now);
            }
        }
        catch (Exception ex) {
            this.callUpdateUsersStat.setOk(false);
            logger.error((Object)"Failed updating users", (Throwable)ex);
        }
    }

    private void callDeleteSchedules(List<String> ids, boolean warmup) {
        logger.info((Object)("===> " + this.warmUpMsg(warmup, ids.size()) + this.callDeleteSchedulesStat.getName()));
        try {
            for (String id : ids) {
                Timetable entity = this.transaction.findTimetableById(id);
                long now = System.currentTimeMillis();
                this.transaction.remove(entity);
                if (warmup) continue;
                this.callDeleteSchedulesStat.add(System.currentTimeMillis() - now);
            }
        }
        catch (Exception ex) {
            this.callDeleteSchedulesStat.setOk(false);
            logger.error((Object)"Failed deleting schedules", (Throwable)ex);
        }
    }

    private void callDeleteUsers(List<User> users, boolean warmup) {
        logger.info((Object)("===> " + this.warmUpMsg(warmup, users.size()) + this.callDeleteUsersStat.getName()));
        try {
            for (User user : users) {
                User entity = this.transaction.findUserById(user.getId());
                long now = System.currentTimeMillis();
                this.transaction.remove(entity);
                this.callDeleteUsersStat.add(System.currentTimeMillis() - now);
            }
        }
        catch (Exception ex) {
            this.callDeleteUsersStat.setOk(false);
            logger.error((Object)"Failed deleting users", (Throwable)ex);
        }
    }

    private void callLogin(List<User> users, int loop, boolean warmup) {
        logger.info((Object)("===> " + this.warmUpMsg(warmup, loop) + this.callLoginStat.getName()));
        logger.info((Object)("===> " + this.warmUpMsg(warmup, loop) + this.callLogoutStat.getName()));
        boolean step = false;
        try {
            int i = 0;
            while (i < loop) {
                step = false;
                User u = users.get(i);
                long now = System.currentTimeMillis();
                u = this.managementService.authenticate(u.getLogin(), PASSWORD);
                this.callLoginStat.add(System.currentTimeMillis() - now);
                step = true;
                now = System.currentTimeMillis();
                this.managementService.loggingoff(u, Boolean.valueOf(false));
                if (!warmup) {
                    this.callLogoutStat.add(System.currentTimeMillis() - now);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            if (!step) {
                this.callLoginStat.setOk(false);
                logger.error((Object)"Failed logging in", (Throwable)ex);
            }
            this.callLogoutStat.setOk(false);
            logger.error((Object)"Failed logging out", (Throwable)ex);
        }
    }

    private void callFailLogin(List<User> users, int loop, boolean warmup) {
        if (loop > 0) {
            logger.info((Object)("===> " + this.warmUpMsg(warmup, loop) + this.callFailLoginStat.getName()));
            User u = null;
            try {
                int i = 0;
                while (i < loop) {
                    u = users.get(i);
                    long now = System.currentTimeMillis();
                    this.managementService.authenticate(u.getLogin(), "...");
                    if (!warmup) {
                        this.callFailLoginStat.add(System.currentTimeMillis() - now);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                this.callFailLoginStat.setOk(false);
                logger.error((Object)("Failed failing login users for user " + u.getLogin()), (Throwable)ex);
            }
        }
    }

    private void callStateReport(int loop, boolean warmup) {
        if (loop > 0) {
            logger.info((Object)("===> " + this.warmUpMsg(warmup, loop) + this.callStateReportStat.getName()));
            try {
                DtcStateSearchDTO criteria = new DtcStateSearchDTO();
                criteria.setFirstRecord(Long.valueOf(1L));
                criteria.setMaxResult(Long.valueOf(10L));
                int i = 0;
                while (i < loop) {
                    long now = System.currentTimeMillis();
                    this.reportService.searchDtcState(criteria);
                    if (!warmup) {
                        this.callStateReportStat.add(System.currentTimeMillis() - now);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                this.callStateReportStat.setOk(false);
                logger.error((Object)"Failed executing state report", (Throwable)ex);
            }
        }
    }

    private void callAuditingReport(int loop, boolean warmup) {
        if (loop > 0) {
            logger.info((Object)("===> " + this.warmUpMsg(warmup, loop) + this.callAuditingReportStat.getName()));
            try {
                AuditReportSearchDTO criteria = new AuditReportSearchDTO();
                criteria.setFirstRecord(Long.valueOf(1L));
                criteria.setMaxResult(Long.valueOf(10L));
                int i = 0;
                while (i < loop) {
                    long now = System.currentTimeMillis();
                    this.reportService.searchAudit(criteria);
                    if (!warmup) {
                        this.callAuditingReportStat.add(System.currentTimeMillis() - now);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                this.callAuditingReportStat.setOk(false);
                logger.error((Object)"Failed executing auditing report", (Throwable)ex);
            }
        }
    }

    private String warmUpMsg(boolean warmup, int loop) {
        return warmup ? "[WARMUP x" + loop + "] " : "";
    }
}

