/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import pt.efacec.smartlighting.FileProperties;
import pt.efacec.smartlighting.IValidationCenario;
import pt.efacec.smartlighting.ValidationCenario;

public class SMRAnalitics {
    private static final Logger logger = Logger.getLogger(SMRAnalitics.class);
    public static int WARMUP;
    public static int SESSIONS;
    public static int DTC_BATCH_SIZE;
    public static int PROFILES_BATCH_SIZE;
    public static int SPECIAL_DAYS_BATCH_SIZE;
    public static int SCHEDULES_BATCH_SIZE;
    public static int USERS_BATCH_SIZE;
    public static int LOGINS_BATCH_SIZE;
    public static int FAIL_LOGINS_BATCH_SIZE;
    public static int REPORTS_BATCH_SIZE;
    public static String COMPROMISE_DRIVER;
    public static String COMPROMISE_NODE;
    public static String COMPROMISE_SQL;
    public static String LOGIN_PREFIX;
    private int workers = 0;
    private String name;
    private ValidationCenario suite;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("The property file name must be specified!");
            return;
        }
        new SMRAnalitics().execute(args[0]);
        System.out.println(">> THE END <<");
        System.exit(0);
    }

    public synchronized void kill(IValidationCenario cenario) {
        this.suite.mergeWith(cenario);
        --this.workers;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String propFile) {
        try {
            LOGIN_PREFIX = String.valueOf(System.getProperty("divdb.firstclient")) + "-";
            logger.info((Object)("Setting LOGIN_PREFIX = " + LOGIN_PREFIX));
            FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext("validation-context.xml");
            FileProperties config = new FileProperties(new File(propFile));
            this.name = config.getProperty("name", "UNIQUE");
            this.workers = SESSIONS = config.getInt("sessions", 1);
            REPORTS_BATCH_SIZE = config.getInt("reportsBatchSize", 1);
            SCHEDULES_BATCH_SIZE = config.getInt("scheduleBatchSize", 1);
            USERS_BATCH_SIZE = config.getInt("userBatchSize", 1);
            LOGINS_BATCH_SIZE = config.getInt("loginBatchSize", 1);
            if (LOGINS_BATCH_SIZE > USERS_BATCH_SIZE) {
                System.out.println("The loginBatchSize must be lesser or equal than the userBatchSize!");
                return;
            }
            FAIL_LOGINS_BATCH_SIZE = config.getInt("failLoginBatchSize", 0);
            if (FAIL_LOGINS_BATCH_SIZE > USERS_BATCH_SIZE) {
                System.out.println("The failLoginBatchSize must be lesser or equal than the userBatchSize!");
                return;
            }
            WARMUP = config.getInt("warmup", 500);
            if (WARMUP > 0) {
                IValidationCenario cenario = (IValidationCenario)ctx.getBean(IValidationCenario.class);
                cenario.execute(WARMUP);
            }
            COMPROMISE_DRIVER = config.getProperty("compromise.driver", "");
            COMPROMISE_NODE = config.getProperty("compromise.node", "");
            COMPROMISE_SQL = config.getProperty("compromise.sql", "");
            this.suite = new ValidationCenario();
            int i22 = 0;
            while (i22 < SESSIONS) {
                IValidationCenario cenario = (IValidationCenario)ctx.getBean(IValidationCenario.class);
                cenario.setName(String.valueOf(this.name) + "-" + SESSIONS);
                cenario.setSession(i22);
                new Runner(cenario).start();
                ++i22;
            }
            SMRAnalitics i22 = this;
            synchronized (i22) {
                while (this.workers > 0) {
                    this.wait();
                }
            }
            try {
                File f = new File(String.valueOf(System.getProperty("user.dir")) + "/" + this.name + "-" + SESSIONS + ".csv");
                StringBuilder sb = new StringBuilder("sep=\t\n");
                if (this.suite.isFail()) {
                    sb.append("========== FAILED CENARIO (check logs) ==========\n");
                }
                sb.append("Statistics for " + SESSIONS + " sessions\n");
                sb.append("Test\tCount\tAverage (ms)\tMax (ms)\tMin (ms)\tOk\n");
                sb.append(this.suite.getCallInsertSchedulesStat().csv());
                sb.append(this.suite.getCallInsertUsersStat().csv());
                sb.append(this.suite.getCallLoginStat().csv());
                sb.append(this.suite.getCallLogoutStat().csv());
                sb.append(this.suite.getCallFailLoginStat().csv());
                sb.append(this.suite.getCallUpdateSchedulesStat().csv());
                sb.append(this.suite.getCallSelectSchedulesStat().csv());
                sb.append(this.suite.getCallUpdateUsersStat().csv());
                sb.append(this.suite.getCallDeleteSchedulesStat().csv());
                sb.append(this.suite.getCallDeleteUsersStat().csv());
                sb.append(this.suite.getCallStateReportStat().csv());
                sb.append(this.suite.getCallAuditingReportStat().csv());
                BufferedWriter bw = new BufferedWriter(new FileWriter(f));
                bw.write(sb.toString());
                bw.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class Runner
    extends Thread {
        private IValidationCenario cenario;

        public Runner(IValidationCenario cenario) {
            this.cenario = cenario;
        }

        @Override
        public void run() {
            try {
                this.cenario.execute(0);
            }
            catch (Exception e) {
                this.cenario.setFail(true);
                logger.error((Object)("Failed - " + this.cenario.getName()), (Throwable)e);
            }
            SMRAnalitics.this.kill(this.cenario);
        }
    }
}

