/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.util;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;

public class SignatureTest {
    public static void main(String[] args) throws Exception {
        byte[] signature;
        byte[] data = new byte[20];
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(1024);
        KeyPair kp = kpg.genKeyPair();
        PublicKey publicKey = kp.getPublic();
        PrivateKey privateKey = kp.getPrivate();
        Signature signEng = Signature.getInstance("SHA1withRSA");
        int i = 0;
        while (i < 1000) {
            signEng = Signature.getInstance("SHA1withRSA");
            signEng.initSign(privateKey);
            ++i;
        }
        long start = System.currentTimeMillis();
        i = 0;
        while (i < 1000) {
            signEng = Signature.getInstance("SHA1withRSA");
            signEng.initSign(privateKey);
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.println("1000 init sign: " + (end - start) + "ms");
        i = 0;
        while (i < 1000) {
            signEng.update(data);
            signature = signEng.sign();
            ++i;
        }
        start = System.currentTimeMillis();
        i = 0;
        while (i < 1000) {
            signEng.update(data);
            signature = signEng.sign();
            ++i;
        }
        end = System.currentTimeMillis();
        System.out.println("1000 sign: " + (end - start) + "ms");
        signEng.update(data);
        signature = signEng.sign();
        i = 0;
        while (i < 1000) {
            signEng = Signature.getInstance("SHA1withRSA");
            signEng.initVerify(publicKey);
            ++i;
        }
        start = System.currentTimeMillis();
        i = 0;
        while (i < 1000) {
            signEng = Signature.getInstance("SHA1withRSA");
            signEng.initVerify(publicKey);
            ++i;
        }
        end = System.currentTimeMillis();
        System.out.println("1000 init verify: " + (end - start) + "ms");
        i = 0;
        while (i < 1000) {
            signEng.update(data);
            signEng.verify(signature);
            ++i;
        }
        start = System.currentTimeMillis();
        i = 0;
        while (i < 1000) {
            signEng.update(data);
            signEng.verify(signature);
            ++i;
        }
        end = System.currentTimeMillis();
        System.out.println("1000 verify: " + (end - start) + "ms");
    }
}

