/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.util;

import bftsmart.reconfiguration.ServerViewManager;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.util.TOMUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.nio.ByteBuffer;
import java.util.Random;

public final class BatchReader {
    private ByteBuffer proposalBuffer;
    private boolean useSignatures;

    public BatchReader(byte[] batch, boolean useSignatures) {
        this.proposalBuffer = ByteBuffer.wrap(batch);
        this.useSignatures = useSignatures;
    }

    public TOMMessage[] deserialiseRequests(ServerViewManager manager) {
        long timestamp = this.proposalBuffer.getLong();
        int numberOfNonces = this.proposalBuffer.getInt();
        Random rnd = null;
        if (numberOfNonces > 0) {
            rnd = new Random(this.proposalBuffer.getLong());
        }
        int numberOfMessages = this.proposalBuffer.getInt();
        TOMMessage[] requests = new TOMMessage[numberOfMessages];
        int i = 0;
        while (i < numberOfMessages) {
            byte[] nonces;
            int messageSize = this.proposalBuffer.getInt();
            byte[] message = new byte[messageSize];
            this.proposalBuffer.get(message);
            byte[] signature = null;
            if (this.useSignatures) {
                signature = new byte[TOMUtil.getSignatureSize(manager)];
                this.proposalBuffer.get(signature);
            }
            if ((nonces = new byte[numberOfNonces]).length > 0) {
                rnd.nextBytes(nonces);
            }
            try {
                DataInputStream ois = new DataInputStream(new ByteArrayInputStream(message));
                TOMMessage tm = new TOMMessage();
                tm.rExternal(ois);
                tm.serializedMessage = message;
                tm.serializedMessageSignature = signature;
                tm.nonces = nonces;
                tm.timestamp = timestamp;
                requests[i] = tm;
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            ++i;
        }
        return requests;
    }
}

