/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.util;

import bftsmart.reconfiguration.ServerViewManager;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.util.TOMUtil;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Random;

public final class BatchBuilder {
    private Random rnd = new Random();

    private byte[] createBatch(long timestamp, int numberOfNonces, int numberOfMessages, int totalMessagesSize, boolean useSignatures, byte[][] messages, byte[][] signatures, ServerViewManager manager) {
        int size = 20 + (numberOfNonces > 0 ? 8 : 0) + numberOfMessages * (4 + (useSignatures ? TOMUtil.getSignatureSize(manager) : 0)) + totalMessagesSize;
        ByteBuffer proposalBuffer = ByteBuffer.allocate(size);
        proposalBuffer.putLong(timestamp);
        proposalBuffer.putInt(numberOfNonces);
        if (numberOfNonces > 0) {
            proposalBuffer.putLong(this.rnd.nextLong());
        }
        proposalBuffer.putInt(numberOfMessages);
        int i = 0;
        while (i < numberOfMessages) {
            this.putMessage(proposalBuffer, messages[i], false, signatures[i]);
            ++i;
        }
        return proposalBuffer.array();
    }

    private void putMessage(ByteBuffer proposalBuffer, byte[] message, boolean isHash, byte[] signature) {
        proposalBuffer.putInt(isHash ? 0 : message.length);
        proposalBuffer.put(message);
        if (signature != null) {
            proposalBuffer.put(signature);
        }
    }

    public byte[] makeBatch(Collection<TOMMessage> msgs, int numNounces, long timestamp, ServerViewManager reconfManager) {
        int numMsgs = msgs.size();
        int totalMessageSize = 0;
        byte[][] messages = new byte[numMsgs][];
        byte[][] signatures = new byte[numMsgs][];
        int i = 0;
        for (TOMMessage msg : msgs) {
            messages[i] = msg.serializedMessage;
            signatures[i] = msg.serializedMessageSignature;
            totalMessageSize += messages[i].length;
            ++i;
        }
        return this.createBatch(timestamp, numNounces, numMsgs, totalMessageSize, reconfManager.getStaticConf().getUseSignatures() == 1, messages, signatures, reconfManager);
    }
}

