/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.server.defaultservices.durability;

import bftsmart.statemanagement.strategy.durability.CSTRequest;
import bftsmart.statemanagement.strategy.durability.CSTRequestF1;
import bftsmart.statemanagement.strategy.durability.CSTState;
import bftsmart.tom.server.defaultservices.CommandsInfo;
import bftsmart.tom.server.defaultservices.FileRecoverer;
import bftsmart.tom.server.defaultservices.StateLog;
import bftsmart.tom.util.TOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class DurableStateLog
extends StateLog {
    private int id;
    public static final String DEFAULT_DIR = "files".concat(System.getProperty("file.separator"));
    private static final int INT_BYTE_SIZE = 4;
    private static final int EOF = 0;
    private RandomAccessFile log;
    private boolean syncLog;
    private String logPath;
    private String lastCkpPath;
    private boolean syncCkp;
    private boolean isToLog;
    private ReentrantLock checkpointLock = new ReentrantLock();
    private Map<Integer, Long> logPointers;

    public DurableStateLog(int id, byte[] initialState, byte[] initialHash, boolean isToLog, boolean syncLog, boolean syncCkp) {
        super(initialState, initialHash);
        this.id = id;
        this.isToLog = isToLog;
        this.syncLog = syncLog;
        this.syncCkp = syncCkp;
        this.logPointers = new HashMap<Integer, Long>();
        if (isToLog) {
            this.createLogFile();
        }
    }

    private void createLogFile() {
        this.logPath = String.valueOf(DEFAULT_DIR) + String.valueOf(this.id) + "." + System.currentTimeMillis() + ".log";
        try {
            this.log = new RandomAccessFile(this.logPath, this.syncLog ? "rwd" : "rw");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addMessageBatch(byte[][] commands, int round, int leader) {
        CommandsInfo command = new CommandsInfo(commands, round, leader);
        if (this.isToLog) {
            this.writeCommandToDisk(command);
        }
    }

    private void writeCommandToDisk(CommandsInfo commandsInfo) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(commandsInfo);
            oos.flush();
            byte[] batchBytes = bos.toByteArray();
            ByteBuffer bf = ByteBuffer.allocate(8 + batchBytes.length);
            bf.putInt(batchBytes.length);
            bf.put(batchBytes);
            bf.putInt(0);
            this.log.write(bf.array());
            this.log.seek(this.log.length() - 4L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void newCheckpoint(byte[] state, byte[] stateHash) {
        String ckpPath = String.valueOf(DEFAULT_DIR) + String.valueOf(this.id) + "." + System.currentTimeMillis() + ".tmp";
        try {
            try {
                this.checkpointLock.lock();
                RandomAccessFile ckp = new RandomAccessFile(ckpPath, this.syncCkp ? "rwd" : "rw");
                ByteBuffer bf = ByteBuffer.allocate(state.length + stateHash.length + 12);
                bf.putInt(state.length);
                bf.put(state);
                bf.putInt(stateHash.length);
                bf.put(stateHash);
                bf.putInt(0);
                byte[] ckpState = bf.array();
                ckp.write(ckpState);
                if (this.isToLog) {
                    this.deleteLogFile();
                }
                this.deleteLastCkp();
                this.renameCkp(ckpPath);
                if (this.isToLog) {
                    this.createLogFile();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                this.checkpointLock.unlock();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.checkpointLock.unlock();
            }
        }
        finally {
            this.checkpointLock.unlock();
        }
    }

    private void renameCkp(String ckpPath) {
        String finalCkpPath = ckpPath.replace(".tmp", ".ckp");
        new File(ckpPath).renameTo(new File(finalCkpPath));
        this.lastCkpPath = finalCkpPath;
    }

    private void deleteLastCkp() {
        if (this.lastCkpPath != null) {
            new File(this.lastCkpPath).delete();
        }
    }

    private void deleteLogFile() {
        try {
            this.log.close();
            new File(this.logPath).delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CSTState getState(CSTRequest cstRequest) {
        int eid = cstRequest.getEid();
        int lastCheckpointEid = this.getLastCheckpointEid();
        int lastEid = this.getLastEid();
        System.out.println("LAST CKP EID = " + lastCheckpointEid);
        System.out.println("EID = " + eid);
        System.out.println("LAST EID = " + lastEid);
        FileRecoverer fr = new FileRecoverer(this.id, DEFAULT_DIR);
        if (cstRequest instanceof CSTRequestF1) {
            CSTRequestF1 requestF1 = (CSTRequestF1)cstRequest;
            if (this.id == requestF1.getCheckpointReplica()) {
                this.checkpointLock.lock();
                byte[] ckpState = fr.getCkpState();
                this.checkpointLock.unlock();
                System.out.println("--- sending checkpoint: " + ckpState.length);
                CommandsInfo[] logLower = fr.getLogState(requestF1.getLogLowerSize());
                CommandsInfo[] logUpper = fr.getLogState(this.logPointers.get(requestF1.getLogUpper()), 0, requestF1.getLogUpperSize());
                byte[] logLowerBytes = TOMUtil.getBytes(logLower);
                System.out.println(String.valueOf(logLower.length) + " Log lower bytes size: " + logLowerBytes.length);
                byte[] logLowerHash = TOMUtil.computeHash(logLowerBytes);
                byte[] logUpperBytes = TOMUtil.getBytes(logUpper);
                System.out.println(String.valueOf(logUpper.length) + " Log upper bytes size: " + logUpperBytes.length);
                byte[] logUpperHash = TOMUtil.computeHash(logUpperBytes);
                CSTState cstState = new CSTState(ckpState, null, null, logLowerHash, null, logUpperHash, lastCheckpointEid, lastEid);
                return cstState;
            }
            if (this.id == requestF1.getLogLower()) {
                System.out.print("--- sending lower log: " + requestF1.getLogLowerSize() + " from " + this.logPointers.get(requestF1.getCheckpointReplica()));
                CommandsInfo[] logLower = fr.getLogState(this.logPointers.get(requestF1.getCheckpointReplica()), 0, requestF1.getLogLowerSize());
                System.out.println(" " + TOMUtil.getBytes(logLower).length + " bytes");
                CSTState cstState = new CSTState(null, null, logLower, null, null, null, lastCheckpointEid, lastEid);
                return cstState;
            }
            System.out.println("--- sending upper log: " + requestF1.getLogUpperSize());
            this.checkpointLock.lock();
            fr.recoverCkpHash();
            byte[] ckpHash = fr.getCkpStateHash();
            byte[] ckpState = fr.getCkpState();
            this.checkpointLock.unlock();
            CommandsInfo[] logUpper = fr.getLogState(requestF1.getLogUpperSize());
            System.out.println(" " + TOMUtil.getBytes(logUpper).length + " bytes");
            System.out.println("--- State size: " + ckpState.length + " Current state Hash: " + ckpHash);
            int lastEidInState = lastCheckpointEid + requestF1.getLogUpperSize();
            CSTState cstState = new CSTState(null, ckpHash, null, null, logUpper, null, lastCheckpointEid, lastEidInState);
            return cstState;
        }
        return null;
    }

    public void transferApplicationState(SocketChannel sChannel, int eid) {
        FileRecoverer fr = new FileRecoverer(this.id, DEFAULT_DIR);
        fr.transferCkpState(sChannel);
    }

    public void setLastEid(int eid, int checkpointPeriod, int checkpointPortion) {
        super.setLastEid(eid);
        if (eid % checkpointPeriod % checkpointPortion == checkpointPortion - 1) {
            int ckpReplicaIndex = (eid % checkpointPeriod + 1) / checkpointPortion - 1;
            try {
                System.out.println(" --- Replica " + ckpReplicaIndex + " took checkpoint. My current log pointer is " + this.log.getFilePointer());
                this.logPointers.put(ckpReplicaIndex, this.log.getFilePointer());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void update(CSTState state) {
        this.newCheckpoint(state.getSerializedState(), state.getStateHash());
        this.setLastCheckpointEid(state.getCheckpointEid());
    }
}

