/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.server.defaultservices.durability;

import bftsmart.reconfiguration.util.TOMConfiguration;
import bftsmart.statemanagement.ApplicationState;
import bftsmart.statemanagement.StateManager;
import bftsmart.statemanagement.strategy.durability.CSTRequest;
import bftsmart.statemanagement.strategy.durability.CSTState;
import bftsmart.statemanagement.strategy.durability.DurableStateManager;
import bftsmart.tom.MessageContext;
import bftsmart.tom.ReplicaContext;
import bftsmart.tom.server.BatchExecutable;
import bftsmart.tom.server.Recoverable;
import bftsmart.tom.server.defaultservices.durability.DurableStateLog;
import bftsmart.tom.util.Logger;
import bftsmart.tom.util.TOMUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public abstract class DurabilityCoordinator
implements Recoverable,
BatchExecutable {
    private ReentrantLock logLock = new ReentrantLock();
    private ReentrantLock hashLock = new ReentrantLock();
    private ReentrantLock stateLock = new ReentrantLock();
    private TOMConfiguration config;
    private MessageDigest md;
    private DurableStateLog log;
    private StateManager stateManager;
    private int lastCkpEid;
    private int globalCheckpointPeriod;
    private int checkpointPortion;
    private int replicaCkpIndex;

    public DurabilityCoordinator() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            java.util.logging.Logger.getLogger(DurabilityCoordinator.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public byte[][] executeBatch(byte[][] commands, MessageContext[] msgCtx) {
        int eid = msgCtx[msgCtx.length - 1].getConsensusId();
        int[] eids = this.consensusIds(msgCtx);
        int checkpointIndex = this.findCheckpointPosition(eids);
        Object replies = new byte[commands.length][];
        if (checkpointIndex == -1) {
            this.stateLock.lock();
            replies = this.appExecuteBatch(commands, msgCtx);
            this.stateLock.unlock();
            Logger.println("(DurabilityCoordinator.executeBatch) Storing message batch in the state log for consensus " + eid);
            this.saveCommands(commands, eids);
        } else {
            byte[][] firstHalf = new byte[checkpointIndex + 1][];
            int[] firstHalfEids = new int[firstHalf.length];
            byte[][] secondHalf = new byte[commands.length - (checkpointIndex + 1)][];
            int[] secondHalfEids = new int[secondHalf.length];
            System.arraycopy(commands, 0, firstHalf, 0, checkpointIndex + 1);
            System.arraycopy(eids, 0, firstHalfEids, 0, checkpointIndex + 1);
            if (secondHalf.length > 0) {
                System.arraycopy(commands, checkpointIndex + 1, secondHalf, 0, commands.length - (checkpointIndex + 1));
                System.arraycopy(eids, checkpointIndex + 1, secondHalfEids, 0, commands.length - (checkpointIndex + 1));
            } else {
                firstHalfEids = eids;
            }
            Object firstHalfReplies = new byte[firstHalf.length][];
            Object secondHalfReplies = new byte[secondHalf.length][];
            eid = msgCtx[checkpointIndex].getConsensusId();
            this.stateLock.lock();
            firstHalfReplies = this.appExecuteBatch(firstHalf, msgCtx);
            this.stateLock.unlock();
            if (eid % this.globalCheckpointPeriod == this.replicaCkpIndex && this.lastCkpEid < eid) {
                Logger.println("(DurabilityCoordinator.executeBatch) Performing checkpoint for consensus " + eid);
                this.stateLock.lock();
                byte[] snapshot = this.getSnapshot();
                this.stateLock.unlock();
                this.saveState(snapshot, eid, 0, 0);
                this.lastCkpEid = eid;
            } else {
                Logger.println("(DurabilityCoordinator.executeBatch) Storing message batch in the state log for consensus " + eid);
                this.saveCommands(firstHalf, firstHalfEids);
            }
            System.arraycopy(firstHalfReplies, 0, replies, 0, ((byte[][])firstHalfReplies).length);
            if (secondHalf.length > 0) {
                eid = msgCtx[msgCtx.length - 1].getConsensusId();
                this.stateLock.lock();
                secondHalfReplies = this.appExecuteBatch(secondHalf, msgCtx);
                this.stateLock.unlock();
                Logger.println("(DurabilityCoordinator.executeBatch) Storing message batch in the state log for consensus " + eid);
                this.saveCommands(secondHalf, secondHalfEids);
                System.arraycopy(secondHalfReplies, 0, replies, ((byte[][])firstHalfReplies).length, ((byte[][])secondHalfReplies).length);
            }
        }
        return replies;
    }

    private int findCheckpointPosition(int[] eids) {
        if (this.config.getGlobalCheckpointPeriod() < 1) {
            return -1;
        }
        if (eids.length == 0) {
            throw new IllegalArgumentException();
        }
        int firstEid = eids[0];
        if ((firstEid + 1) % this.checkpointPortion == 0) {
            return this.eidPosition(eids, firstEid);
        }
        int nextCkpIndex = (firstEid / this.checkpointPortion + 1) * this.checkpointPortion - 1;
        if (nextCkpIndex <= eids[eids.length - 1]) {
            return this.eidPosition(eids, nextCkpIndex);
        }
        return -1;
    }

    private int eidPosition(int[] eids, int eid) {
        int index = -1;
        if (eids[eids.length - 1] == eid) {
            return eids.length - 1;
        }
        int i = 0;
        while (i < eids.length) {
            if (eids[i] > eid) break;
            ++index;
            ++i;
        }
        System.out.println("--- Checkpoint is in position " + index);
        return index;
    }

    @Override
    public ApplicationState getState(int eid, boolean sendState) {
        this.logLock.lock();
        ApplicationState ret = null;
        this.logLock.unlock();
        return ret;
    }

    @Override
    public int setState(ApplicationState recvState) {
        int lastEid = -1;
        if (recvState instanceof CSTState) {
            CSTState state = (CSTState)recvState;
            int lastCheckpointEid = state.getCheckpointEid();
            lastEid = state.getLastEid();
            Logger.println("(DurabilityCoordinator.setState) I'm going to update myself from EID " + lastCheckpointEid + " to EID " + lastEid);
            this.stateLock.lock();
            if (state.getSerializedState() != null) {
                System.out.println("The state is not null. Will install it");
                this.log.update(state);
                this.installSnapshot(state.getSerializedState());
            }
            System.out.print("--- Installing log from " + (lastCheckpointEid + 1) + " to " + lastEid);
            int eid = lastCheckpointEid + 1;
            while (eid <= lastEid) {
                try {
                    Logger.println("(DurabilityCoordinator.setState) interpreting and verifying batched requests for eid " + eid);
                    byte[][] commands = state.getMessageBatch((int)eid).commands;
                    if (commands != null && commands.length > 0) {
                        this.appExecuteBatch(commands, null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                ++eid;
            }
            System.out.println("--- Installed");
            this.stateLock.unlock();
        }
        return lastEid;
    }

    private final byte[] computeHash(byte[] data) {
        byte[] ret = null;
        this.hashLock.lock();
        ret = this.md.digest(data);
        this.hashLock.unlock();
        return ret;
    }

    private void saveState(byte[] snapshot, int lastEid, int decisionRound, int leader) {
        this.logLock.lock();
        Logger.println("(TOMLayer.saveState) Saving state of EID " + lastEid + ", round " + decisionRound + " and leader " + leader);
        this.log.newCheckpoint(snapshot, this.computeHash(snapshot));
        this.log.setLastEid(-1);
        this.log.setLastCheckpointEid(lastEid);
        this.log.setLastCheckpointRound(decisionRound);
        this.log.setLastCheckpointLeader(leader);
        this.logLock.unlock();
        Logger.println("(TOMLayer.saveState) Finished saving state of EID " + lastEid + ", round " + decisionRound + " and leader " + leader);
    }

    private void saveCommands(byte[][] commands, int[] eids) {
        if (!this.config.isToLog()) {
            return;
        }
        if (commands.length != eids.length) {
            System.out.println("----SIZE OF COMMANDS AND EIDS IS DIFFERENT----");
        }
        this.logLock.lock();
        int decisionRound = 0;
        int leader = 0;
        int eid = eids[0];
        int batchStart = 0;
        int i = 0;
        while (i <= eids.length) {
            byte[][] batch;
            if (i == eids.length) {
                batch = (byte[][])Arrays.copyOfRange(commands, batchStart, i);
                this.log.addMessageBatch(batch, decisionRound, leader);
                this.log.setLastEid(eid, this.globalCheckpointPeriod, this.checkpointPortion);
            } else if (eids[i] > eid) {
                batch = (byte[][])Arrays.copyOfRange(commands, batchStart, i);
                this.log.addMessageBatch(batch, decisionRound, leader);
                this.log.setLastEid(eid, this.globalCheckpointPeriod, this.checkpointPortion);
                eid = eids[i];
                batchStart = i;
            }
            ++i;
        }
        this.logLock.unlock();
    }

    public CSTState getState(CSTRequest cstRequest) {
        CSTState ret = this.log.getState(cstRequest);
        return ret;
    }

    @Override
    public void setReplicaContext(ReplicaContext replicaContext) {
        this.config = replicaContext.getStaticConfiguration();
        if (this.log == null) {
            this.globalCheckpointPeriod = this.config.getGlobalCheckpointPeriod();
            this.replicaCkpIndex = this.getCheckpointPortionIndex();
            this.checkpointPortion = this.globalCheckpointPeriod / this.config.getN();
            if (this.config.isToLog()) {
                int replicaId = this.config.getProcessId();
                boolean isToLog = this.config.isToLog();
                boolean syncLog = this.config.isToWriteSyncLog();
                boolean syncCkp = this.config.isToWriteSyncCkp();
                this.log = new DurableStateLog(replicaId, null, null, isToLog, syncLog, syncCkp);
            }
        }
    }

    private int getCheckpointPortionIndex() {
        int numberOfReplicas = this.config.getN();
        int ckpIndex = this.globalCheckpointPeriod / numberOfReplicas * (this.config.getProcessId() + 1) - 1;
        return ckpIndex;
    }

    private int[] consensusIds(MessageContext[] ctxs) {
        int[] eids = new int[ctxs.length];
        int i = 0;
        while (i < ctxs.length) {
            eids[i] = ctxs[i].getConsensusId();
            ++i;
        }
        return eids;
    }

    @Override
    public StateManager getStateManager() {
        if (this.stateManager == null) {
            this.stateManager = new DurableStateManager();
        }
        return this.stateManager;
    }

    public byte[] getCurrentStateHash() {
        byte[] currentState = this.getSnapshot();
        byte[] currentStateHash = TOMUtil.computeHash(currentState);
        System.out.println("--- State size: " + currentState.length + " Current state Hash: " + Arrays.toString(currentStateHash));
        return currentStateHash;
    }

    public abstract void installSnapshot(byte[] var1);

    public abstract byte[] getSnapshot();

    public abstract byte[][] appExecuteBatch(byte[][] var1, MessageContext[] var2);
}

