/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.server.defaultservices;

import bftsmart.tom.server.defaultservices.CommandsInfo;
import bftsmart.tom.server.defaultservices.DefaultApplicationState;

public class StateLog {
    private CommandsInfo[] messageBatches;
    private int lastCheckpointEid;
    private int lastCheckpointRound;
    private int lastCheckpointLeader;
    private byte[] state;
    private byte[] stateHash;
    private int position;
    private int lastEid;

    public StateLog(int k, byte[] initialState, byte[] initialHash) {
        this.messageBatches = new CommandsInfo[k - 1];
        this.lastCheckpointEid = -1;
        this.lastCheckpointRound = -1;
        this.lastCheckpointLeader = -1;
        this.state = initialState;
        this.stateHash = initialHash;
        this.position = 0;
        this.lastEid = -1;
    }

    public StateLog(int k) {
        this.messageBatches = new CommandsInfo[k - 1];
        this.lastCheckpointEid = -1;
        this.lastCheckpointRound = -1;
        this.lastCheckpointLeader = -1;
        this.state = null;
        this.stateHash = null;
        this.position = 0;
        this.lastEid = -1;
    }

    public StateLog(byte[] initialState, byte[] initialHash) {
        this.lastCheckpointEid = -1;
        this.lastCheckpointRound = -1;
        this.lastCheckpointLeader = -1;
        this.state = initialState;
        this.stateHash = initialHash;
        this.lastEid = -1;
    }

    public void newCheckpoint(byte[] state, byte[] stateHash) {
        int i = 0;
        while (i < this.messageBatches.length) {
            this.messageBatches[i] = null;
            ++i;
        }
        this.position = 0;
        this.state = state;
        this.stateHash = stateHash;
    }

    public void setLastCheckpointEid(int lastCheckpointEid) {
        this.lastCheckpointEid = lastCheckpointEid;
    }

    public int getLastCheckpointEid() {
        return this.lastCheckpointEid;
    }

    public void setLastCheckpointRound(int lastCheckpointRound) {
        this.lastCheckpointRound = lastCheckpointRound;
    }

    public int getLastCheckpointRound() {
        return this.lastCheckpointRound;
    }

    public void setLastCheckpointLeader(int lastCheckpointLeader) {
        this.lastCheckpointLeader = lastCheckpointLeader;
    }

    public int getLastCheckpointLeader() {
        return this.lastCheckpointLeader;
    }

    public void setLastEid(int lastEid) {
        this.lastEid = lastEid;
    }

    public int getLastEid() {
        return this.lastEid;
    }

    public byte[] getState() {
        return this.state;
    }

    public byte[] getStateHash() {
        return this.stateHash;
    }

    public void addMessageBatch(byte[][] commands, int round, int leader) {
        if (this.position < this.messageBatches.length) {
            this.messageBatches[this.position] = new CommandsInfo(commands, round, leader);
            ++this.position;
        }
    }

    public CommandsInfo getMessageBatch(int eid) {
        if (eid > this.lastCheckpointEid && eid <= this.lastEid) {
            return this.messageBatches[eid - this.lastCheckpointEid - 1];
        }
        return null;
    }

    public CommandsInfo[] getMessageBatches() {
        return this.messageBatches;
    }

    public int getNumBatches() {
        return this.position;
    }

    public DefaultApplicationState getApplicationState(int eid, boolean setState) {
        System.out.println("--- Eid requested: " + eid + ". Last checkpoint: " + this.lastCheckpointEid);
        CommandsInfo[] batches = null;
        int lastEid = -1;
        if (eid >= this.lastCheckpointEid && eid <= this.lastEid) {
            int size = eid - this.lastCheckpointEid;
            if (size > 0) {
                batches = new CommandsInfo[size];
                int i = 0;
                while (i < size) {
                    batches[i] = this.messageBatches[i];
                    ++i;
                }
            }
            lastEid = eid;
            return new DefaultApplicationState(batches, this.lastCheckpointEid, this.lastCheckpointRound, this.lastCheckpointLeader, lastEid, setState ? this.state : null, this.stateHash);
        }
        return null;
    }

    public void update(DefaultApplicationState transState) {
        this.position = 0;
        if (transState.getMessageBatches() != null) {
            int i = 0;
            while (i < transState.getMessageBatches().length) {
                this.messageBatches[i] = transState.getMessageBatches()[i];
                this.position = ++i;
            }
        }
        this.lastCheckpointEid = transState.getLastCheckpointEid();
        this.state = transState.getState();
        this.stateHash = transState.getStateHash();
        this.lastEid = transState.getLastEid();
    }
}

