/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.server.defaultservices;

import bftsmart.tom.server.defaultservices.CommandsInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;

public class FileRecoverer {
    private static final int EOF = 0;
    private int processId;
    private String defaultDirectory;
    private byte[] ckpHash;

    public FileRecoverer(int id, String filesDir) {
        this.processId = id;
        this.defaultDirectory = filesDir;
    }

    public CommandsInfo[] getLogState(int index) {
        String file = this.getTSLogsPathes(".log");
        RandomAccessFile log = null;
        log = this.openLogFile(file);
        if (log != null) {
            System.out.println("GETTING STATE FROM " + file);
            CommandsInfo[] logState = this.recoverLogState(log, index);
            try {
                log.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return logState;
        }
        return null;
    }

    public CommandsInfo[] getLogState(long pointer, int startOffset, int number) {
        String file = this.getTSLogsPathes(".log");
        RandomAccessFile log = null;
        log = this.openLogFile(file);
        if (log != null) {
            System.out.println("GETTING STATE FROM " + file);
            CommandsInfo[] logState = this.recoverLogState(log, pointer, startOffset, number);
            try {
                log.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return logState;
        }
        return null;
    }

    public byte[] getCkpState() {
        String file = this.getTSLogsPathes(".ckp");
        RandomAccessFile ckp = null;
        ckp = this.openLogFile(file);
        if (ckp != null) {
            System.out.println("GETTING STATE FROM " + file);
            byte[] ckpState = this.recoverCkpState(ckp);
            try {
                ckp.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return ckpState;
        }
        return null;
    }

    public void recoverCkpHash() {
        String file = this.getTSLogsPathes(".ckp");
        RandomAccessFile ckp = null;
        ckp = this.openLogFile(file);
        if (ckp != null) {
            System.out.println("GETTING HASH FROM " + file);
            byte[] ckpHash = null;
            try {
                int ckpSize = ckp.readInt();
                ckp.skipBytes(ckpSize);
                int hashLength = ckp.readInt();
                ckpHash = new byte[hashLength];
                ckp.read(ckpHash);
                System.out.println("--- Last ckp size: " + ckpSize + " Last ckp hash: " + Arrays.toString(ckpHash));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("State recover was aborted due to an unexpected exception");
            }
            this.ckpHash = ckpHash;
        }
    }

    private byte[] recoverCkpState(RandomAccessFile ckp) {
        byte[] ckpState = null;
        try {
            long logLength = ckp.length();
            boolean mayRead = true;
            while (mayRead) {
                try {
                    if (ckp.getFilePointer() < logLength) {
                        int size = ckp.readInt();
                        if (size > 0) {
                            ckpState = new byte[size];
                            int read = ckp.read(ckpState);
                            if (read == size) {
                                int hashSize = ckp.readInt();
                                if (size <= 0) continue;
                                this.ckpHash = new byte[hashSize];
                                read = ckp.read(this.ckpHash);
                                if (read == hashSize) {
                                    mayRead = false;
                                    continue;
                                }
                                this.ckpHash = null;
                                ckpState = null;
                                continue;
                            }
                            mayRead = false;
                            ckp = null;
                            continue;
                        }
                        mayRead = false;
                        continue;
                    }
                    mayRead = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ckp = null;
                    mayRead = false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("State recover was aborted due to an unexpected exception");
        }
        return ckpState;
    }

    public void transferLog(SocketChannel sChannel, int index) {
        String file = this.getTSLogsPathes(".log");
        RandomAccessFile log = null;
        log = this.openLogFile(file);
        if (log != null) {
            System.out.println("GETTING STATE FROM LOG " + file);
            this.transferLog(log, sChannel, index);
        }
    }

    private void transferLog(RandomAccessFile logFile, SocketChannel sChannel, int index) {
        try {
            long totalBytes = logFile.length();
            System.out.println("---Called transferLog." + totalBytes + " " + (sChannel == null));
            FileChannel fileChannel = logFile.getChannel();
            long bytesTransfered = 0L;
            while (bytesTransfered < totalBytes) {
                long bytesSent;
                long bufferSize = 65536L;
                if (totalBytes - bytesTransfered < bufferSize && (bufferSize = (long)((int)(totalBytes - bytesTransfered))) <= 0L) {
                    bufferSize = (int)totalBytes;
                }
                if ((bytesSent = fileChannel.transferTo(bytesTransfered, bufferSize, sChannel)) <= 0L) continue;
                bytesTransfered += bytesSent;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("State recover was aborted due to an unexpected exception");
        }
    }

    public void transferCkpState(SocketChannel sChannel) {
        String file = this.getTSLogsPathes(".ckp");
        RandomAccessFile ckp = null;
        ckp = this.openLogFile(file);
        if (ckp != null) {
            System.out.println("GETTING STATE FROM " + file);
            this.transferCkpState(ckp, sChannel);
            try {
                ckp.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void transferCkpState(RandomAccessFile ckp, SocketChannel sChannel) {
        try {
            long milliInit = System.currentTimeMillis();
            System.out.println("--- Sending checkpoint." + ckp.length() + " " + (sChannel == null));
            FileChannel fileChannel = ckp.getChannel();
            long totalBytes = ckp.length();
            long bytesTransfered = 0L;
            while (bytesTransfered < totalBytes) {
                long bytesRead;
                long bufferSize = 65536L;
                if (totalBytes - bytesTransfered < bufferSize && (bufferSize = (long)((int)(totalBytes - bytesTransfered))) <= 0L) {
                    bufferSize = (int)totalBytes;
                }
                if ((bytesRead = fileChannel.transferTo(bytesTransfered, bufferSize, sChannel)) <= 0L) continue;
                bytesTransfered += bytesRead;
            }
            System.out.println("---Took " + (System.currentTimeMillis() - milliInit) + " milliseconds to transfer the checkpoint");
            fileChannel.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("State recover was aborted due to an unexpected exception");
        }
    }

    public byte[] getCkpStateHash() {
        return this.ckpHash;
    }

    private String getTSLogsPathes(String extention) {
        File directory = new File(this.defaultDirectory);
        ArrayList<String> files = new ArrayList<String>();
        if (directory.isDirectory()) {
            File[] serverLogs;
            File[] fileArray = serverLogs = directory.listFiles(new FileListFilter(this.processId, extention));
            int n = serverLogs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                files.add(f.getAbsolutePath());
                ++n2;
            }
        }
        return (String)files.get(0);
    }

    private RandomAccessFile openLogFile(String file) {
        try {
            return new RandomAccessFile(file, "r");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private CommandsInfo[] recoverLogState(RandomAccessFile log, int endOffset) {
        try {
            long logLength = log.length();
            ArrayList<CommandsInfo> state = new ArrayList<CommandsInfo>();
            int recoveredBatches = 0;
            boolean mayRead = true;
            System.out.println("filepointer: " + log.getFilePointer() + " loglength " + logLength + " endoffset " + endOffset);
            while (mayRead) {
                try {
                    if (log.getFilePointer() < logLength) {
                        int size = log.readInt();
                        if (size > 0) {
                            byte[] bytes = new byte[size];
                            int read = log.read(bytes);
                            if (read == size) {
                                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                                ObjectInputStream ois = new ObjectInputStream(bis);
                                state.add((CommandsInfo)ois.readObject());
                                if (++recoveredBatches != endOffset) continue;
                                System.out.println("read all " + endOffset + " log messages");
                                return state.toArray(new CommandsInfo[state.size()]);
                            }
                            mayRead = false;
                            System.out.println("STATE CLEAR");
                            state.clear();
                            continue;
                        }
                        System.out.println("ELSE 1");
                        mayRead = false;
                        continue;
                    }
                    System.out.println("ELSE 2 " + recoveredBatches);
                    mayRead = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    state.clear();
                    mayRead = false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("State recover was aborted due to an unexpected exception");
        }
        return null;
    }

    private CommandsInfo[] recoverLogState(RandomAccessFile log, long pointer, int startOffset, int number) {
        try {
            byte[] bytes;
            long logLength = log.length();
            ArrayList<CommandsInfo> state = new ArrayList<CommandsInfo>();
            int recoveredBatches = 0;
            boolean mayRead = true;
            log.seek(pointer);
            int index = 0;
            while (index < startOffset) {
                int size = log.readInt();
                bytes = new byte[size];
                log.read(bytes);
                ++index;
            }
            while (mayRead) {
                try {
                    if (log.getFilePointer() < logLength) {
                        int size = log.readInt();
                        if (size > 0) {
                            bytes = new byte[size];
                            int read = log.read(bytes);
                            if (read == size) {
                                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                                ObjectInputStream ois = new ObjectInputStream(bis);
                                state.add((CommandsInfo)ois.readObject());
                                if (++recoveredBatches != number) continue;
                                return state.toArray(new CommandsInfo[state.size()]);
                            }
                            System.out.println("recoverLogState (pointer,offset,number) STATE CLEAR");
                            mayRead = false;
                            state.clear();
                            continue;
                        }
                        System.out.println("recoverLogState (pointer,offset,number) ELSE 1");
                        mayRead = false;
                        continue;
                    }
                    System.out.println("recoverLogState (pointer,offset,number) ELSE 2 " + recoveredBatches);
                    mayRead = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    state.clear();
                    mayRead = false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("State recover was aborted due to an unexpected exception");
        }
        return null;
    }

    private class FileListFilter
    implements FilenameFilter {
        private int id;
        private String extention;

        public FileListFilter(int id, String extention) {
            this.id = id;
            this.extention = extention;
        }

        @Override
        public boolean accept(File directory, String filename) {
            boolean fileOK = false;
            if (this.id >= 0 && filename.startsWith(String.valueOf(this.id) + ".") && filename.endsWith(this.extention)) {
                fileOK = true;
            }
            return fileOK;
        }
    }
}

