/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.server.defaultservices;

import bftsmart.statemanagement.ApplicationState;
import bftsmart.statemanagement.StateManager;
import bftsmart.statemanagement.strategy.StandardStateManager;
import bftsmart.tom.MessageContext;
import bftsmart.tom.server.Recoverable;
import bftsmart.tom.server.SingleExecutable;
import bftsmart.tom.server.defaultservices.DefaultApplicationState;
import bftsmart.tom.server.defaultservices.StateLog;
import bftsmart.tom.util.Logger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public abstract class DefaultSingleRecoverable
implements Recoverable,
SingleExecutable {
    public static final int CHECKPOINT_PERIOD = 60;
    private ReentrantLock logLock = new ReentrantLock();
    private ReentrantLock hashLock = new ReentrantLock();
    private ReentrantLock stateLock = new ReentrantLock();
    private MessageDigest md;
    private StateLog log;
    private List<byte[]> commands = new ArrayList<byte[]>();
    private StateManager stateManager;

    public DefaultSingleRecoverable() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            java.util.logging.Logger.getLogger(DefaultSingleRecoverable.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.log = new StateLog(60);
    }

    @Override
    public byte[] executeOrdered(byte[] command, MessageContext msgCtx) {
        int eid = msgCtx.getConsensusId();
        this.stateLock.lock();
        byte[] reply = this.appExecuteOrdered(command, msgCtx);
        this.stateLock.unlock();
        this.commands.add(command);
        if (msgCtx.isLastInBatch()) {
            if (eid > 0 && eid % 60 == 0) {
                Logger.println("(DurabilityCoordinator.executeBatch) Performing checkpoint for consensus " + eid);
                this.stateLock.lock();
                byte[] snapshot = this.getSnapshot();
                this.stateLock.unlock();
                this.saveState(snapshot, eid, 0, 0);
            } else {
                Logger.println("(DurabilityCoordinator.executeBatch) Storing message batch in the state log for consensus " + eid);
                this.saveCommands((byte[][])this.commands.toArray((T[])new byte[0][]), eid, 0, 0);
            }
            this.commands = new ArrayList<byte[]>();
        }
        return reply;
    }

    public final byte[] computeHash(byte[] data) {
        byte[] ret = null;
        this.hashLock.lock();
        ret = this.md.digest(data);
        this.hashLock.unlock();
        return ret;
    }

    private StateLog getLog() {
        return this.log;
    }

    private void saveState(byte[] snapshot, int lastEid, int decisionRound, int leader) {
        StateLog thisLog = this.getLog();
        this.logLock.lock();
        Logger.println("(TOMLayer.saveState) Saving state of EID " + lastEid + ", round " + decisionRound + " and leader " + leader);
        thisLog.newCheckpoint(snapshot, this.computeHash(snapshot));
        thisLog.setLastEid(-1);
        thisLog.setLastCheckpointEid(lastEid);
        thisLog.setLastCheckpointRound(decisionRound);
        thisLog.setLastCheckpointLeader(leader);
        this.logLock.unlock();
        Logger.println("(TOMLayer.saveState) Finished saving state of EID " + lastEid + ", round " + decisionRound + " and leader " + leader);
    }

    private void saveCommands(byte[][] commands, int lastEid, int decisionRound, int leader) {
        StateLog thisLog = this.getLog();
        this.logLock.lock();
        Logger.println("(TOMLayer.saveBatch) Saving batch of EID " + lastEid + ", round " + decisionRound + " and leader " + leader);
        thisLog.addMessageBatch(commands, decisionRound, leader);
        thisLog.setLastEid(lastEid);
        this.logLock.unlock();
        Logger.println("(TOMLayer.saveBatch) Finished saving batch of EID " + lastEid + ", round " + decisionRound + " and leader " + leader);
    }

    @Override
    public ApplicationState getState(int eid, boolean sendState) {
        this.logLock.lock();
        DefaultApplicationState ret = eid > -1 ? this.getLog().getApplicationState(eid, sendState) : new DefaultApplicationState();
        this.logLock.unlock();
        return ret;
    }

    @Override
    public int setState(ApplicationState recvState) {
        int lastEid = -1;
        if (recvState instanceof DefaultApplicationState) {
            DefaultApplicationState state = (DefaultApplicationState)recvState;
            System.out.println("(DurabilityCoordinator.setState) last eid in state: " + state.getLastEid());
            this.getLog().update(state);
            int lastCheckpointEid = state.getLastCheckpointEid();
            lastEid = state.getLastEid();
            Logger.println("(DurabilityCoordinator.setState) I'm going to update myself from EID " + lastCheckpointEid + " to EID " + lastEid);
            this.stateLock.lock();
            this.installSnapshot(state.getState());
            int eid = lastCheckpointEid + 1;
            while (eid <= lastEid) {
                block7: {
                    try {
                        byte[][] commands;
                        Logger.println("(DurabilityCoordinator.setState) interpreting and verifying batched requests for eid " + eid);
                        if (state.getMessageBatch(eid) == null) {
                            System.out.println("(DurabilityCoordinator.setState) " + eid + " NULO!!!");
                        }
                        if ((commands = state.getMessageBatch((int)eid).commands) != null && commands.length > 0) {
                            byte[][] byArray = commands;
                            int n = commands.length;
                            int n2 = 0;
                            while (n2 < n) {
                                byte[] command = byArray[n2];
                                this.appExecuteOrdered(command, null);
                                ++n2;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        if (!(e instanceof ArrayIndexOutOfBoundsException)) break block7;
                        System.out.println("Eid do ultimo checkpoint: " + state.getLastCheckpointEid());
                        System.out.println("Eid do ultimo consenso: " + state.getLastEid());
                        System.out.println("numero de mensagens supostamente no batch: " + (state.getLastEid() - state.getLastCheckpointEid() + 1));
                        System.out.println("numero de mensagens realmente no batch: " + state.getMessageBatches().length);
                    }
                }
                ++eid;
            }
            this.stateLock.unlock();
        }
        return lastEid;
    }

    @Override
    public StateManager getStateManager() {
        if (this.stateManager == null) {
            this.stateManager = new StandardStateManager();
        }
        return this.stateManager;
    }

    public abstract void installSnapshot(byte[] var1);

    public abstract byte[] getSnapshot();

    public abstract byte[] appExecuteOrdered(byte[] var1, MessageContext var2);
}

