/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.server.defaultservices;

import bftsmart.reconfiguration.util.TOMConfiguration;
import bftsmart.statemanagement.ApplicationState;
import bftsmart.statemanagement.StateManager;
import bftsmart.statemanagement.strategy.StandardStateManager;
import bftsmart.tom.MessageContext;
import bftsmart.tom.ReplicaContext;
import bftsmart.tom.server.BatchExecutable;
import bftsmart.tom.server.Recoverable;
import bftsmart.tom.server.defaultservices.DefaultApplicationState;
import bftsmart.tom.server.defaultservices.DiskStateLog;
import bftsmart.tom.server.defaultservices.StateLog;
import bftsmart.tom.util.Logger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public abstract class DefaultRecoverable
implements Recoverable,
BatchExecutable {
    private int checkpointPeriod;
    private ReentrantLock logLock = new ReentrantLock();
    private ReentrantLock hashLock = new ReentrantLock();
    private ReentrantLock stateLock = new ReentrantLock();
    private TOMConfiguration config;
    private MessageDigest md;
    private StateLog log;
    private StateManager stateManager;

    public DefaultRecoverable() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            java.util.logging.Logger.getLogger(DefaultRecoverable.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public byte[][] executeBatch(byte[][] commands, MessageContext[] msgCtxs) {
        int eid = msgCtxs[0].getConsensusId();
        int[] eids = this.consensusIds(msgCtxs);
        int checkpointIndex = this.findCheckpointPosition(eids);
        Object replies = new byte[commands.length][];
        if (checkpointIndex == -1) {
            this.stateLock.lock();
            replies = this.appExecuteBatch(commands, msgCtxs);
            this.stateLock.unlock();
            this.saveCommands(commands, eids);
        } else {
            byte[][] firstHalf = new byte[checkpointIndex + 1][];
            int[] firstHalfEids = new int[firstHalf.length];
            byte[][] secondHalf = new byte[commands.length - (checkpointIndex + 1)][];
            int[] secondHalfEids = new int[secondHalf.length];
            System.arraycopy(commands, 0, firstHalf, 0, checkpointIndex + 1);
            System.arraycopy(eids, 0, firstHalfEids, 0, checkpointIndex + 1);
            if (secondHalf.length > 0) {
                System.arraycopy(commands, checkpointIndex + 1, secondHalf, 0, commands.length - (checkpointIndex + 1));
                System.arraycopy(eids, checkpointIndex + 1, secondHalfEids, 0, commands.length - (checkpointIndex + 1));
            } else {
                firstHalfEids = eids;
            }
            Object firstHalfReplies = new byte[firstHalf.length][];
            Object secondHalfReplies = new byte[secondHalf.length][];
            eid = msgCtxs[checkpointIndex].getConsensusId();
            this.stateLock.lock();
            firstHalfReplies = this.appExecuteBatch(firstHalf, msgCtxs);
            this.stateLock.unlock();
            System.out.println("(DefaultRecoverable.executeBatch) Performing checkpoint for consensus " + eid);
            this.stateLock.lock();
            byte[] snapshot = this.getSnapshot();
            this.stateLock.unlock();
            this.saveState(snapshot, eid, 0, 0);
            System.arraycopy(firstHalfReplies, 0, replies, 0, ((byte[][])firstHalfReplies).length);
            if (secondHalf.length > 0) {
                eid = msgCtxs[msgCtxs.length - 1].getConsensusId();
                this.stateLock.lock();
                secondHalfReplies = this.appExecuteBatch(secondHalf, msgCtxs);
                this.stateLock.unlock();
                Logger.println("(DurabilityCoordinator.executeBatch) Storing message batch in the state log for consensus " + eid);
                this.saveCommands(secondHalf, secondHalfEids);
                System.arraycopy(secondHalfReplies, 0, replies, ((byte[][])firstHalfReplies).length, ((byte[][])secondHalfReplies).length);
            }
        }
        return replies;
    }

    public final byte[] computeHash(byte[] data) {
        byte[] ret = null;
        this.hashLock.lock();
        ret = this.md.digest(data);
        this.hashLock.unlock();
        return ret;
    }

    private StateLog getLog() {
        return this.log;
    }

    private void saveState(byte[] snapshot, int lastEid, int decisionRound, int leader) {
        StateLog thisLog = this.getLog();
        this.logLock.lock();
        Logger.println("(TOMLayer.saveState) Saving state of EID " + lastEid + ", round " + decisionRound + " and leader " + leader);
        thisLog.newCheckpoint(snapshot, this.computeHash(snapshot));
        thisLog.setLastEid(-1);
        thisLog.setLastCheckpointEid(lastEid);
        thisLog.setLastCheckpointRound(decisionRound);
        thisLog.setLastCheckpointLeader(leader);
        this.logLock.unlock();
        Logger.println("(TOMLayer.saveState) Finished saving state of EID " + lastEid + ", round " + decisionRound + " and leader " + leader);
    }

    public void saveCommands(byte[][] commands, int lastEid, int decisionRound, int leader) {
        StateLog thisLog = this.getLog();
        this.logLock.lock();
        Logger.println("(TOMLayer.saveBatch) Saving batch of EID " + lastEid + ", round " + decisionRound + " and leader " + leader);
        thisLog.addMessageBatch(commands, decisionRound, leader);
        thisLog.setLastEid(lastEid);
        this.logLock.unlock();
        Logger.println("(TOMLayer.saveBatch) Finished saving batch of EID " + lastEid + ", round " + decisionRound + " and leader " + leader);
    }

    private void saveCommands(byte[][] commands, int[] eids) {
        if (!this.config.isToLog()) {
            return;
        }
        if (commands.length != eids.length) {
            System.out.println("----SIZE OF COMMANDS AND EIDS IS DIFFERENT----");
        }
        this.logLock.lock();
        int decisionRound = 0;
        int leader = 0;
        int eid = eids[0];
        int batchStart = 0;
        int i = 0;
        while (i <= eids.length) {
            byte[][] batch;
            if (i == eids.length) {
                batch = (byte[][])Arrays.copyOfRange(commands, batchStart, i);
                this.log.addMessageBatch(batch, decisionRound, leader);
                this.log.setLastEid(eid);
            } else if (eids[i] > eid) {
                batch = (byte[][])Arrays.copyOfRange(commands, batchStart, i);
                this.log.addMessageBatch(batch, decisionRound, leader);
                this.log.setLastEid(eid);
                eid = eids[i];
                batchStart = i;
            }
            ++i;
        }
        this.logLock.unlock();
    }

    @Override
    public ApplicationState getState(int eid, boolean sendState) {
        this.logLock.lock();
        DefaultApplicationState ret = eid > -1 ? this.getLog().getApplicationState(eid, sendState) : new DefaultApplicationState();
        this.logLock.unlock();
        return ret;
    }

    @Override
    public int setState(ApplicationState recvState) {
        int lastEid = -1;
        if (recvState instanceof DefaultApplicationState) {
            DefaultApplicationState state = (DefaultApplicationState)recvState;
            this.getLog().update(state);
            int lastCheckpointEid = state.getLastCheckpointEid();
            lastEid = state.getLastEid();
            Logger.println("(DurabilityCoordinator.setState) I'm going to update myself from EID " + lastCheckpointEid + " to EID " + lastEid);
            this.stateLock.lock();
            this.installSnapshot(state.getState());
            int eid = lastCheckpointEid + 1;
            while (eid <= lastEid) {
                block6: {
                    try {
                        byte[][] commands;
                        Logger.println("(DurabilityCoordinator.setState) interpreting and verifying batched requests for eid " + eid);
                        if (state.getMessageBatch(eid) == null) {
                            System.out.println("(DurabilityCoordinator.setState) " + eid + " NULO!!!");
                        }
                        if ((commands = state.getMessageBatch((int)eid).commands) != null && commands.length > 0) {
                            this.appExecuteBatch(commands, null);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        if (!(e instanceof ArrayIndexOutOfBoundsException)) break block6;
                        System.out.println("Eid do ultimo checkpoint: " + state.getLastCheckpointEid());
                        System.out.println("Eid do ultimo consenso: " + state.getLastEid());
                        System.out.println("numero de mensagens supostamente no batch: " + (state.getLastEid() - state.getLastCheckpointEid() + 1));
                        System.out.println("numero de mensagens realmente no batch: " + state.getMessageBatches().length);
                    }
                }
                ++eid;
            }
            this.stateLock.unlock();
        }
        return lastEid;
    }

    private int[] consensusIds(MessageContext[] ctxs) {
        int[] eids = new int[ctxs.length];
        int i = 0;
        while (i < ctxs.length) {
            eids[i] = ctxs[i].getConsensusId();
            ++i;
        }
        return eids;
    }

    private int findCheckpointPosition(int[] eids) {
        if (this.checkpointPeriod < 1) {
            return -1;
        }
        if (eids.length == 0) {
            throw new IllegalArgumentException();
        }
        int firstEid = eids[0];
        if ((firstEid + 1) % this.checkpointPeriod == 0) {
            return this.eidPosition(eids, firstEid);
        }
        int nextCkpIndex = (firstEid / this.checkpointPeriod + 1) * this.checkpointPeriod - 1;
        if (nextCkpIndex <= eids[eids.length - 1]) {
            return this.eidPosition(eids, nextCkpIndex);
        }
        return -1;
    }

    private int eidPosition(int[] eids, int eid) {
        int index = -1;
        if (eids[eids.length - 1] == eid) {
            return eids.length - 1;
        }
        int i = 0;
        while (i < eids.length) {
            if (eids[i] > eid) break;
            ++index;
            ++i;
        }
        System.out.println("--- Checkpoint is in position " + index);
        return index;
    }

    @Override
    public void setReplicaContext(ReplicaContext replicaContext) {
        this.config = replicaContext.getStaticConfiguration();
        if (this.log == null) {
            this.checkpointPeriod = this.config.getCheckpointPeriod();
            byte[] state = this.getSnapshot();
            if (this.config.isToLog() && this.config.logToDisk()) {
                int replicaId = this.config.getProcessId();
                boolean isToLog = this.config.isToLog();
                boolean syncLog = this.config.isToWriteSyncLog();
                boolean syncCkp = this.config.isToWriteSyncCkp();
                this.log = new DiskStateLog(replicaId, state, this.computeHash(state), isToLog, syncLog, syncCkp);
            } else {
                this.log = new StateLog(this.checkpointPeriod, state, this.computeHash(state));
            }
        }
    }

    @Override
    public StateManager getStateManager() {
        if (this.stateManager == null) {
            this.stateManager = new StandardStateManager();
        }
        return this.stateManager;
    }

    public abstract void installSnapshot(byte[] var1);

    public abstract byte[] getSnapshot();

    public abstract byte[][] appExecuteBatch(byte[][] var1, MessageContext[] var2);
}

