/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.server.defaultservices;

import bftsmart.statemanagement.ApplicationState;
import bftsmart.tom.server.defaultservices.CommandsInfo;
import java.util.Arrays;

public class DefaultApplicationState
implements ApplicationState {
    private static final long serialVersionUID = 6771081456095596363L;
    protected byte[] state;
    protected byte[] stateHash;
    protected int lastEid = -1;
    protected boolean hasState;
    private CommandsInfo[] messageBatches;
    private int lastCheckpointEid;
    private int lastCheckpointRound;
    private int lastCheckpointLeader;
    private byte[] logHash;

    public DefaultApplicationState(CommandsInfo[] messageBatches, int lastCheckpointEid, int lastCheckpointRound, int lastCheckpointLeader, int lastEid, byte[] state, byte[] stateHash) {
        this.messageBatches = messageBatches;
        this.lastCheckpointEid = lastCheckpointEid;
        this.lastCheckpointRound = lastCheckpointRound;
        this.lastCheckpointLeader = lastCheckpointLeader;
        this.lastEid = lastEid;
        this.state = state;
        this.stateHash = stateHash;
        this.hasState = true;
    }

    public DefaultApplicationState(CommandsInfo[] messageBatches, byte[] logHash, int lastCheckpointEid, int lastCheckpointRound, int lastCheckpointLeader, int lastEid, byte[] state, byte[] stateHash) {
        this(messageBatches, lastCheckpointEid, lastCheckpointRound, lastCheckpointLeader, lastEid, state, stateHash);
        this.logHash = logHash;
    }

    public DefaultApplicationState() {
        this.messageBatches = null;
        this.lastCheckpointEid = -1;
        this.lastCheckpointRound = -1;
        this.lastCheckpointLeader = -1;
        this.lastEid = -1;
        this.state = null;
        this.stateHash = null;
        this.hasState = false;
    }

    @Override
    public void setSerializedState(byte[] state) {
        this.state = state;
    }

    @Override
    public byte[] getSerializedState() {
        return this.state;
    }

    @Override
    public boolean hasState() {
        return this.hasState;
    }

    @Override
    public int getLastEid() {
        return this.lastEid;
    }

    public byte[] getState() {
        return this.state;
    }

    @Override
    public byte[] getStateHash() {
        return this.stateHash;
    }

    public void setState(byte[] state) {
        this.state = state;
    }

    public CommandsInfo[] getMessageBatches() {
        return this.messageBatches;
    }

    public void setMessageBatches(CommandsInfo[] messageBatches) {
        this.messageBatches = messageBatches;
    }

    public CommandsInfo getMessageBatch(int eid) {
        if (eid >= this.lastCheckpointEid && eid <= this.lastEid) {
            return this.messageBatches[eid - this.lastCheckpointEid - 1];
        }
        return null;
    }

    public int getLastCheckpointEid() {
        return this.lastCheckpointEid;
    }

    public int getLastCheckpointRound() {
        return this.lastCheckpointRound;
    }

    public int getLastCheckpointLeader() {
        return this.lastCheckpointLeader;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DefaultApplicationState) {
            DefaultApplicationState tState = (DefaultApplicationState)obj;
            if (this.messageBatches != null && tState.messageBatches == null || this.messageBatches == null && tState.messageBatches != null) {
                return false;
            }
            if (this.messageBatches != null && tState.messageBatches != null) {
                if (this.messageBatches.length != tState.messageBatches.length) {
                    return false;
                }
                int i = 0;
                while (i < this.messageBatches.length) {
                    if (this.messageBatches[i] == null && tState.messageBatches[i] != null) {
                        return false;
                    }
                    if (this.messageBatches[i] != null && tState.messageBatches[i] == null) {
                        return false;
                    }
                    if (!(this.messageBatches[i] == null && tState.messageBatches[i] == null || this.messageBatches[i].equals(tState.messageBatches[i]))) {
                        return false;
                    }
                    ++i;
                }
            }
            return Arrays.equals(this.stateHash, tState.stateHash) && tState.lastCheckpointEid == this.lastCheckpointEid && tState.lastCheckpointRound == this.lastCheckpointRound && tState.lastCheckpointLeader == this.lastCheckpointLeader && tState.lastEid == this.lastEid && tState.hasState == this.hasState;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int i;
        int hash = 1;
        hash = hash * 31 + this.lastCheckpointEid;
        hash = hash * 31 + this.lastCheckpointRound;
        hash = hash * 31 + this.lastCheckpointLeader;
        hash = hash * 31 + this.lastEid;
        hash = hash * 31 + (this.hasState ? 1 : 0);
        if (this.stateHash != null) {
            i = 0;
            while (i < this.stateHash.length) {
                hash = hash * 31 + this.stateHash[i];
                ++i;
            }
        } else {
            hash = hash * 31 + 0;
        }
        if (this.messageBatches != null) {
            i = 0;
            while (i < this.messageBatches.length) {
                hash = this.messageBatches[i] != null ? hash * 31 + this.messageBatches[i].hashCode() : hash * 31 + 0;
                ++i;
            }
        } else {
            hash = hash * 31 + 0;
        }
        return hash;
    }
}

