/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.leaderchange;

import bftsmart.paxosatwar.executionmanager.TimestampValuePair;
import bftsmart.paxosatwar.messages.PaxosMessage;
import bftsmart.reconfiguration.ServerViewManager;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.leaderchange.CollectData;
import bftsmart.tom.leaderchange.LastEidData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignedObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class LCManager {
    private int lastreg;
    private int nextreg;
    private List<TOMMessage> currentRequestTimedOut = null;
    private HashMap<Integer, HashSet<Integer>> stops;
    private HashMap<Integer, HashSet<LastEidData>> lastEids;
    private HashMap<Integer, HashSet<SignedObject>> collects;
    private ServerViewManager SVManager;
    private MessageDigest md;
    private TOMLayer tomLayer;
    private int currentLeader;
    private Cipher cipher;

    public LCManager(TOMLayer tomLayer, ServerViewManager reconfManager, MessageDigest md) {
        this.tomLayer = tomLayer;
        this.lastreg = 0;
        this.nextreg = 0;
        this.currentLeader = 0;
        this.stops = new HashMap();
        this.lastEids = new HashMap();
        this.collects = new HashMap();
        this.SVManager = reconfManager;
        this.md = md;
        try {
            this.cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException ex) {
            ex.printStackTrace();
        }
    }

    public int getNewLeader() {
        int[] proc = this.SVManager.getCurrentViewProcesses();
        int minProc = proc[0];
        int maxProc = proc[0];
        int[] nArray = proc;
        int n = proc.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            if (p < minProc) {
                minProc = p;
            }
            if (p > maxProc) {
                maxProc = p;
            }
            ++n2;
        }
        do {
            ++this.currentLeader;
            if (this.currentLeader <= maxProc) continue;
            this.currentLeader = minProc;
        } while (!this.SVManager.isCurrentViewMember(this.currentLeader));
        return this.currentLeader;
    }

    public void setNewLeader(int leader) {
        this.currentLeader = leader;
    }

    public void setCurrentRequestTimedOut(List<TOMMessage> currentRequestTimedOut) {
        this.currentRequestTimedOut = currentRequestTimedOut;
    }

    public List<TOMMessage> getCurrentRequestTimedOut() {
        return this.currentRequestTimedOut;
    }

    public void setLastReg(int lastreg) {
        this.lastreg = lastreg;
    }

    public int getLastReg() {
        return this.lastreg;
    }

    public void setNextReg(int nextreg) {
        this.nextreg = nextreg;
    }

    public int getNextReg() {
        return this.nextreg;
    }

    public void addStop(int regency, int pid) {
        HashSet<Integer> pids = this.stops.get(regency);
        if (pids == null) {
            pids = new HashSet();
        }
        pids.add(pid);
        this.stops.put(regency, pids);
    }

    public void removeStops(int regency) {
        Integer[] keys = new Integer[this.stops.keySet().size()];
        this.stops.keySet().toArray(keys);
        int i = 0;
        while (i < keys.length) {
            if (keys[i] <= regency) {
                this.stops.remove(keys[i]);
            }
            ++i;
        }
    }

    public int getStopsSize(int regency) {
        HashSet<Integer> pids = this.stops.get(regency);
        return pids == null ? 0 : pids.size();
    }

    public void addLastEid(int regency, LastEidData lastEid) {
        HashSet<LastEidData> last = this.lastEids.get(regency);
        if (last == null) {
            last = new HashSet();
        }
        last.add(lastEid);
        this.lastEids.put(regency, last);
    }

    public void removeLastEids(int regency) {
        Integer[] keys = new Integer[this.lastEids.keySet().size()];
        this.lastEids.keySet().toArray(keys);
        int i = 0;
        while (i < keys.length) {
            if (keys[i] <= regency) {
                this.lastEids.remove(keys[i]);
            }
            ++i;
        }
    }

    public int getLastEidsSize(int regency) {
        HashSet<LastEidData> last = this.lastEids.get(regency);
        return last == null ? 0 : last.size();
    }

    public HashSet<LastEidData> getLastEids(int regency) {
        return this.lastEids.get(regency);
    }

    public void setLastEids(int regency, HashSet<LastEidData> lasts) {
        this.lastEids.put(regency, lasts);
    }

    public void addCollect(int regency, SignedObject signedCollect) {
        HashSet<SignedObject> c = this.collects.get(regency);
        if (c == null) {
            c = new HashSet();
        }
        c.add(signedCollect);
        this.collects.put(regency, c);
    }

    public void removeCollects(int regency) {
        Integer[] keys = new Integer[this.collects.keySet().size()];
        this.collects.keySet().toArray(keys);
        int i = 0;
        while (i < keys.length) {
            if (keys[i] <= regency) {
                this.collects.remove(keys[i]);
            }
            ++i;
        }
    }

    public int getCollectsSize(int regency) {
        HashSet<SignedObject> c = this.collects.get(regency);
        return c == null ? 0 : c.size();
    }

    public HashSet<SignedObject> getCollects(int regency) {
        return this.collects.get(regency);
    }

    public void setCollects(int regency, HashSet<SignedObject> colls) {
        this.collects.put(regency, colls);
    }

    public boolean sound(HashSet<CollectData> collects) {
        if (collects == null) {
            return false;
        }
        HashSet<Integer> timestamps = new HashSet<Integer>();
        HashSet<byte[]> values = new HashSet<byte[]>();
        for (CollectData c : collects) {
            timestamps.add(c.getQuorumWeaks().getRound());
            if (!Arrays.equals(c.getQuorumWeaks().getValue(), new byte[0])) {
                boolean insert = true;
                for (byte[] b : values) {
                    if (!Arrays.equals(b, c.getQuorumWeaks().getValue())) continue;
                    insert = false;
                    break;
                }
                if (insert) {
                    values.add(c.getQuorumWeaks().getValue());
                }
            }
            for (TimestampValuePair rv : c.getWriteSet()) {
                timestamps.add(rv.getRound());
                boolean insert = true;
                for (byte[] b : values) {
                    if (!Arrays.equals(b, rv.getHashedValue())) continue;
                    insert = false;
                    break;
                }
                if (!insert) continue;
                values.add(rv.getHashedValue());
            }
        }
        Iterator<CollectData> iterator = timestamps.iterator();
        while (iterator.hasNext()) {
            int r = (Integer)((Object)iterator.next());
            for (byte[] v : values) {
                if (!this.binds(r, v, collects)) continue;
                return true;
            }
        }
        return this.unbound(collects);
    }

    public boolean binds(int timestamp, byte[] value, HashSet<CollectData> collects) {
        return value != null && collects != null && collects.size() > this.SVManager.getCurrentViewN() - this.SVManager.getCurrentViewF() && this.quorumHighest(timestamp, value, collects) && this.certifiedValue(timestamp, value, collects);
    }

    public byte[] getBindValue(HashSet<CollectData> collects) {
        if (collects == null) {
            return null;
        }
        HashSet<Integer> timestamps = new HashSet<Integer>();
        HashSet<byte[]> values = new HashSet<byte[]>();
        for (CollectData c : collects) {
            timestamps.add(c.getQuorumWeaks().getRound());
            if (!Arrays.equals(c.getQuorumWeaks().getValue(), new byte[0])) {
                boolean insert = true;
                for (byte[] b : values) {
                    if (!Arrays.equals(b, c.getQuorumWeaks().getValue())) continue;
                    insert = false;
                    break;
                }
                if (insert) {
                    values.add(c.getQuorumWeaks().getValue());
                }
            }
            for (TimestampValuePair rv : c.getWriteSet()) {
                timestamps.add(rv.getRound());
                boolean insert = true;
                for (byte[] b : values) {
                    if (!Arrays.equals(b, rv.getHashedValue())) continue;
                    insert = false;
                    break;
                }
                if (!insert) continue;
                values.add(rv.getHashedValue());
            }
        }
        Iterator<CollectData> iterator = timestamps.iterator();
        while (iterator.hasNext()) {
            int r = (Integer)((Object)iterator.next());
            for (byte[] v : values) {
                if (r < 0 || !this.binds(r, v, collects)) continue;
                for (CollectData c : collects) {
                    for (TimestampValuePair rv : c.getWriteSet()) {
                        for (byte[] b : values) {
                            if (rv.getValue() == null || !Arrays.equals(v, rv.getHashedValue())) continue;
                            return rv.getValue();
                        }
                    }
                }
            }
        }
        return null;
    }

    public boolean unbound(HashSet<CollectData> collects) {
        if (collects == null) {
            return false;
        }
        boolean unbound = false;
        int count = 0;
        if (collects.size() >= this.SVManager.getCurrentViewN() - this.SVManager.getCurrentViewF()) {
            for (CollectData c : collects) {
                if (c.getQuorumWeaks().getRound() != 0) continue;
                ++count;
            }
        } else {
            return false;
        }
        unbound = this.SVManager.getStaticConf().isBFT() ? count > (this.SVManager.getCurrentViewN() + this.SVManager.getCurrentViewF()) / 2 : count > this.SVManager.getCurrentViewN() / 2;
        return unbound;
    }

    public boolean quorumHighest(int timestamp, byte[] value, HashSet<CollectData> collects) {
        if (collects == null || value == null) {
            return false;
        }
        boolean appears = false;
        boolean quorum = false;
        for (CollectData c : collects) {
            if (c.getQuorumWeaks().getRound() != timestamp || !Arrays.equals(value, c.getQuorumWeaks().getValue())) continue;
            appears = true;
            break;
        }
        int count = 0;
        for (CollectData c : collects) {
            if (c.getQuorumWeaks().getRound() >= timestamp && (c.getQuorumWeaks().getRound() != timestamp || !Arrays.equals(value, c.getQuorumWeaks().getValue()))) continue;
            ++count;
        }
        if (this.SVManager.getStaticConf().isBFT()) {
            quorum = count > (this.SVManager.getCurrentViewN() + this.SVManager.getCurrentViewF()) / 2;
        } else {
            boolean bl = quorum = count > this.SVManager.getCurrentViewN() / 2;
        }
        return appears && quorum;
    }

    public boolean certifiedValue(int timestamp, byte[] value, HashSet<CollectData> collects) {
        if (collects == null || value == null) {
            return false;
        }
        boolean certified = false;
        int count = 0;
        for (CollectData c : collects) {
            for (TimestampValuePair pv : c.getWriteSet()) {
                if (pv.getRound() < timestamp || !Arrays.equals(value, pv.getHashedValue())) continue;
                ++count;
            }
        }
        certified = this.SVManager.getStaticConf().isBFT() ? count > this.SVManager.getCurrentViewF() : count > 0;
        return certified;
    }

    public HashSet<CollectData> selectCollects(int regency, int eid) {
        HashSet<SignedObject> c = this.collects.get(regency);
        if (c == null) {
            return null;
        }
        return this.normalizeCollects(this.getSignedCollects(c), eid);
    }

    public HashSet<CollectData> selectCollects(HashSet<SignedObject> signedObjects, int eid) {
        if (signedObjects == null) {
            return null;
        }
        return this.normalizeCollects(this.getSignedCollects(signedObjects), eid);
    }

    private HashSet<CollectData> getSignedCollects(HashSet<SignedObject> signedCollects) {
        HashSet<CollectData> colls = new HashSet<CollectData>();
        for (SignedObject so : signedCollects) {
            try {
                CollectData c = (CollectData)so.getObject();
                int sender = c.getPid();
                if (!this.tomLayer.verifySignature(so, sender)) continue;
                colls.add(c);
            }
            catch (IOException ex) {
                Logger.getLogger(LCManager.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(LCManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return colls;
    }

    private HashSet<CollectData> normalizeCollects(HashSet<CollectData> collects, int eid) {
        HashSet<CollectData> result = new HashSet<CollectData>();
        for (CollectData c : collects) {
            if (c.getEid() == eid) {
                result.add(c);
                continue;
            }
            result.add(new CollectData(c.getPid(), eid, new TimestampValuePair(0, new byte[0]), new HashSet<TimestampValuePair>()));
        }
        for (CollectData c : result) {
            for (TimestampValuePair rv : c.getWriteSet()) {
                if (rv.getValue() != null && rv.getValue().length > 0) {
                    rv.setHashedValue(this.md.digest(rv.getValue()));
                    continue;
                }
                rv.setHashedValue(new byte[0]);
            }
        }
        return result;
    }

    public LastEidData getHighestLastEid(int ts) {
        LastEidData highest = new LastEidData(-2, -2, null, null);
        HashSet<LastEidData> lasts = this.lastEids.get(ts);
        if (lasts == null) {
            return null;
        }
        for (LastEidData l : lasts) {
            if (this.tomLayer.reconfManager.getStaticConf().isBFT() && this.hasValidProof(l) && l.getEid() > highest.getEid()) {
                highest = l;
                continue;
            }
            if (l.getEid() <= highest.getEid()) continue;
            highest = l;
        }
        return highest;
    }

    private boolean hasValidProof(LastEidData led) {
        byte[] hashedValue = this.md.digest(led.getEidDecision());
        Set<PaxosMessage> PaxosMessages = led.getEidProof();
        int myId = this.tomLayer.reconfManager.getStaticConf().getProcessId();
        int certificate = 2 * this.tomLayer.reconfManager.getCurrentViewF() + 1;
        int countValid = 0;
        for (PaxosMessage paxosMsg : PaxosMessages) {
            HashMap macVector = (HashMap)paxosMsg.getMACVector();
            byte[] recvMAC = (byte[])macVector.get(myId);
            PaxosMessage pm = new PaxosMessage(44783, paxosMsg.getNumber(), paxosMsg.getRound(), paxosMsg.getSender(), paxosMsg.getValue());
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(248);
            try {
                new ObjectOutputStream(bOut).writeObject(pm);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            byte[] data = bOut.toByteArray();
            byte[] hash = this.tomLayer.computeHash(data);
            byte[] myMAC = null;
            SecretKeySpec key = new SecretKeySpec(this.tomLayer.getCommunication().getServersConn().getSecretKey(paxosMsg.getSender()).getEncoded(), "DES");
            try {
                this.cipher.init(1, key);
                myMAC = this.cipher.doFinal(hash);
            }
            catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException ex) {
                ex.printStackTrace();
            }
            if (recvMAC == null || myMAC == null || !Arrays.equals(recvMAC, myMAC) || !Arrays.equals(paxosMsg.getValue(), hashedValue) || paxosMsg.getNumber() != led.getEid()) continue;
            ++countValid;
        }
        return countValid >= certificate;
    }

    public byte[] getLastEidValue(int regency, int eid) {
        HashSet<LastEidData> lasts = this.lastEids.get(regency);
        if (lasts == null) {
            return null;
        }
        byte[] result = null;
        for (LastEidData l : lasts) {
            if (l.getEid() != eid) continue;
            result = l.getEidDecision();
            break;
        }
        return result;
    }
}

