/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.core.timer;

import bftsmart.communication.ServerCommunicationSystem;
import bftsmart.reconfiguration.ServerViewManager;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.leaderchange.LCMessage;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RequestsTimer {
    private Timer timer = new Timer("request timer");
    private RequestTimerTask rtTask = null;
    private TOMLayer tomLayer;
    private long timeout;
    private long shortTimeout;
    private TreeSet<TOMMessage> watched = new TreeSet();
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private boolean enabled = true;
    private ServerCommunicationSystem communication;
    private ServerViewManager reconfManager;

    public RequestsTimer(TOMLayer tomLayer, ServerCommunicationSystem communication, ServerViewManager reconfManager) {
        this.tomLayer = tomLayer;
        this.communication = communication;
        this.reconfManager = reconfManager;
        this.timeout = this.reconfManager.getStaticConf().getRequestTimeout();
        this.shortTimeout = -1L;
    }

    public void setShortTimeout(long shortTimeout) {
        this.shortTimeout = shortTimeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimer() {
        return this.timeout;
    }

    public void startTimer() {
        if (this.rtTask == null) {
            long t = this.shortTimeout > -1L ? this.shortTimeout : this.timeout;
            this.rtTask = new RequestTimerTask();
            if (this.reconfManager.getCurrentViewN() > 1) {
                this.timer.schedule((TimerTask)this.rtTask, t);
            }
        }
    }

    public void stopTimer() {
        if (this.rtTask != null) {
            this.rtTask.cancel();
            this.rtTask = null;
        }
    }

    public void Enabled(boolean phase) {
        this.enabled = phase;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void watch(TOMMessage request) {
        this.rwLock.writeLock().lock();
        this.watched.add(request);
        if (this.watched.size() >= 1 && this.enabled) {
            this.startTimer();
        }
        this.rwLock.writeLock().unlock();
    }

    public void unwatch(TOMMessage request) {
        this.rwLock.writeLock().lock();
        if (this.watched.remove(request) && this.watched.isEmpty()) {
            this.stopTimer();
        }
        this.rwLock.writeLock().unlock();
    }

    public void clearAll() {
        TOMMessage[] requests = new TOMMessage[this.watched.size()];
        this.rwLock.writeLock().lock();
        this.watched.toArray(requests);
        TOMMessage[] tOMMessageArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            TOMMessage request = tOMMessageArray[n2];
            if (request != null && this.watched.remove(request) && this.watched.isEmpty() && this.rtTask != null) {
                this.rtTask.cancel();
                this.rtTask = null;
            }
            ++n2;
        }
        this.rwLock.writeLock().unlock();
    }

    public void run_lc_protocol() {
        long t = this.shortTimeout > -1L ? this.shortTimeout : this.timeout;
        this.rwLock.readLock().lock();
        LinkedList<TOMMessage> pendingRequests = new LinkedList<TOMMessage>();
        for (TOMMessage request : this.watched) {
            if (request.receptionTime + System.currentTimeMillis() <= t) break;
            pendingRequests.add(request);
        }
        if (!pendingRequests.isEmpty()) {
            ListIterator li = pendingRequests.listIterator();
            while (li.hasNext()) {
                TOMMessage request;
                request = (TOMMessage)li.next();
                if (request.timeout) continue;
                request.signed = request.serializedMessageSignature != null;
                this.tomLayer.forwardRequestToLeader(request);
                request.timeout = true;
                li.remove();
            }
            if (!pendingRequests.isEmpty()) {
                System.out.println("Timeout for messages: " + pendingRequests);
                this.tomLayer.triggerTimeout(pendingRequests);
            } else {
                this.rtTask = new RequestTimerTask();
                this.timer.schedule((TimerTask)this.rtTask, t);
            }
        } else {
            this.rtTask = null;
            this.timer.purge();
        }
        this.rwLock.readLock().unlock();
    }

    class RequestTimerTask
    extends TimerTask {
        RequestTimerTask() {
        }

        @Override
        public void run() {
            int[] myself = new int[]{RequestsTimer.this.reconfManager.getStaticConf().getProcessId()};
            RequestsTimer.this.communication.send(myself, new LCMessage(-1, 8, -1, null));
        }
    }
}

