/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.core.timer;

import bftsmart.communication.SystemMessage;
import bftsmart.tom.core.messages.TOMMessage;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class ForwardedMessage
extends SystemMessage {
    private TOMMessage request;

    public ForwardedMessage() {
    }

    public ForwardedMessage(int senderId, TOMMessage request) {
        super(senderId);
        this.request = request;
    }

    public TOMMessage getRequest() {
        return this.request;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.request.serializedMessage.length);
        out.write(this.request.serializedMessage);
        out.writeBoolean(this.request.signed);
        if (this.request.signed) {
            out.writeInt(this.request.serializedMessageSignature.length);
            out.write(this.request.serializedMessageSignature);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte[] serReq = new byte[in.readInt()];
        in.readFully(serReq);
        this.request = TOMMessage.bytesToMessage(serReq);
        this.request.serializedMessage = serReq;
        boolean signed = in.readBoolean();
        if (signed) {
            byte[] serReqSign = new byte[in.readInt()];
            in.readFully(serReqSign);
            this.request.serializedMessageSignature = serReqSign;
        }
    }
}

