/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.core;

import bftsmart.clientsmanagement.ClientsManager;
import bftsmart.clientsmanagement.RequestList;
import bftsmart.communication.ServerCommunicationSystem;
import bftsmart.communication.client.RequestReceiver;
import bftsmart.paxosatwar.Consensus;
import bftsmart.paxosatwar.executionmanager.Execution;
import bftsmart.paxosatwar.executionmanager.ExecutionManager;
import bftsmart.paxosatwar.executionmanager.LeaderModule;
import bftsmart.paxosatwar.executionmanager.Round;
import bftsmart.paxosatwar.executionmanager.TimestampValuePair;
import bftsmart.paxosatwar.roles.Acceptor;
import bftsmart.reconfiguration.ServerViewManager;
import bftsmart.reconfiguration.StatusReply;
import bftsmart.statemanagement.StateManager;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.core.DeliveryThread;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import bftsmart.tom.core.timer.ForwardedMessage;
import bftsmart.tom.core.timer.RequestsTimer;
import bftsmart.tom.leaderchange.CollectData;
import bftsmart.tom.leaderchange.LCManager;
import bftsmart.tom.leaderchange.LCMessage;
import bftsmart.tom.leaderchange.LastEidData;
import bftsmart.tom.server.Recoverable;
import bftsmart.tom.util.BatchBuilder;
import bftsmart.tom.util.BatchReader;
import bftsmart.tom.util.Logger;
import bftsmart.tom.util.TOMUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignedObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.apache.commons.codec.binary.Base64;

public final class TOMLayer
extends Thread
implements RequestReceiver {
    public ExecutionManager execManager;
    public LeaderModule lm;
    public Acceptor acceptor;
    private ServerCommunicationSystem communication;
    private DeliveryThread dt;
    private StateManager stateManager = null;
    public RequestsTimer requestsTimer;
    public ClientsManager clientsManager;
    private int inExecution = -1;
    private int lastExecuted = -1;
    private MessageDigest md;
    private Signature engine;
    private BatchBuilder bb = new BatchBuilder();
    private ReentrantLock leaderLock = new ReentrantLock();
    private Condition iAmLeader = this.leaderLock.newCondition();
    private ReentrantLock messagesLock = new ReentrantLock();
    private Condition haveMessages = this.messagesLock.newCondition();
    private ReentrantLock proposeLock = new ReentrantLock();
    private Condition canPropose = this.proposeLock.newCondition();
    private LCManager lcManager;
    private PrivateKey prk;
    public ServerViewManager reconfManager;
    ReentrantLock hashLock = new ReentrantLock();
    private int tempRegency = -1;
    private LastEidData tempLastHighestEid = null;
    private int tempCurrentEid = -1;
    private HashSet<SignedObject> tempSignedCollects = null;
    private byte[] tempPropose = null;
    private int tempBatchSize = -1;
    private boolean tempIAmLeader = false;

    public TOMLayer(ExecutionManager manager, ServiceReplica receiver, Recoverable recoverer, LeaderModule lm, Acceptor a, ServerCommunicationSystem cs, ServerViewManager recManager) {
        super("TOM Layer");
        this.execManager = manager;
        this.lm = lm;
        this.acceptor = a;
        this.communication = cs;
        this.reconfManager = recManager;
        this.requestsTimer = this.reconfManager.getStaticConf().getRequestTimeout() == 0 ? null : new RequestsTimer(this, this.communication, this.reconfManager);
        this.clientsManager = new ClientsManager(this.reconfManager, this.requestsTimer);
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        try {
            this.engine = Signature.getInstance("SHA1withRSA");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.prk = this.reconfManager.getStaticConf().getRSAPrivateKey();
        this.lcManager = new LCManager(this, recManager, this.md);
        this.dt = new DeliveryThread(this, receiver, recoverer, this.reconfManager);
        this.dt.start();
        this.stateManager = recoverer.getStateManager();
        this.stateManager.init(this, this.dt);
    }

    public final byte[] computeHash(byte[] data) {
        byte[] ret = null;
        this.hashLock.lock();
        ret = this.md.digest(data);
        this.hashLock.unlock();
        return ret;
    }

    public SignedObject sign(Serializable obj) {
        try {
            return new SignedObject(obj, this.prk, this.engine);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public boolean verifySignature(SignedObject so, int sender) {
        try {
            return so.verify(this.reconfManager.getStaticConf().getRSAPublicKey(), this.engine);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public ServerCommunicationSystem getCommunication() {
        return this.communication;
    }

    public void imAmTheLeader() {
        this.leaderLock.lock();
        this.iAmLeader.signal();
        this.leaderLock.unlock();
    }

    public void setLastExec(int last) {
        this.lastExecuted = last;
    }

    public int getLastExec() {
        return this.lastExecuted;
    }

    public void setInExec(int inEx) {
        this.proposeLock.lock();
        Logger.println("(TOMLayer.setInExec) modifying inExec from " + this.inExecution + " to " + inEx);
        this.inExecution = inEx;
        if (inEx == -1 && !this.isRetrievingState()) {
            this.canPropose.signalAll();
        }
        this.proposeLock.unlock();
    }

    public void waitForPaxosToFinish() {
        this.proposeLock.lock();
        this.canPropose.awaitUninterruptibly();
        this.proposeLock.unlock();
    }

    public int getInExec() {
        return this.inExecution;
    }

    @Override
    public void requestReceived(TOMMessage msg) {
        boolean readOnly;
        boolean bl = readOnly = msg.getReqType() == TOMMessageType.UNORDERED_REQUEST;
        if (readOnly) {
            this.dt.deliverUnordered(msg, this.lcManager.getLastReg());
        } else if (msg.getReqType() == TOMMessageType.ASK_STATUS) {
            msg.reply = null;
            msg.reply = this.isRetrievingState() ? new TOMMessage(this.reconfManager.getStaticConf().getProcessId(), msg.getSession(), msg.getSequence(), TOMUtil.getBytes(StatusReply.UPDATING_STATE.toString()), this.reconfManager.getCurrentViewId()) : (this.execManager.stopped() ? new TOMMessage(this.reconfManager.getStaticConf().getProcessId(), msg.getSession(), msg.getSequence(), TOMUtil.getBytes(StatusReply.LEADER_CHANGE.toString()), this.reconfManager.getCurrentViewId()) : new TOMMessage(this.reconfManager.getStaticConf().getProcessId(), msg.getSession(), msg.getSequence(), TOMUtil.getBytes(StatusReply.READY.toString()), this.reconfManager.getCurrentViewId(), TOMMessageType.STATUS_REPLY));
            this.communication.send(new int[]{msg.getSender()}, msg.reply);
        } else if (this.clientsManager.requestReceived(msg, true, this.communication)) {
            this.messagesLock.lock();
            this.haveMessages.signal();
            this.messagesLock.unlock();
        } else {
            Logger.println("(TOMLayer.requestReceive) the received TOMMessage " + msg + " was discarded.");
        }
    }

    private byte[] createPropose(Consensus cons) {
        RequestList pendingRequests = this.clientsManager.getPendingRequests();
        int numberOfMessages = pendingRequests.size();
        int numberOfNonces = this.reconfManager.getStaticConf().getNumberOfNonces();
        if (cons.getId() > -1) {
            cons.firstMessageProposed = (TOMMessage)pendingRequests.getFirst();
            cons.firstMessageProposed.consensusStartTime = System.nanoTime();
        }
        cons.batchSize = numberOfMessages;
        Logger.println("(TOMLayer.run) creating a PROPOSE with " + numberOfMessages + " msgs");
        return this.bb.makeBatch(pendingRequests, numberOfNonces, System.currentTimeMillis(), this.reconfManager);
    }

    @Override
    public void run() {
        Logger.println("Running.");
        while (true) {
            this.leaderLock.lock();
            Logger.println("Next leader for eid=" + (this.getLastExec() + 1) + ": " + this.lm.getCurrentLeader());
            if (this.lm.getCurrentLeader() != this.reconfManager.getStaticConf().getProcessId()) {
                this.iAmLeader.awaitUninterruptibly();
            }
            this.leaderLock.unlock();
            this.proposeLock.lock();
            if (this.getInExec() != -1) {
                Logger.println("(TOMLayer.run) Waiting for consensus " + this.getInExec() + " termination.");
                this.canPropose.awaitUninterruptibly();
            }
            this.proposeLock.unlock();
            Logger.println("(TOMLayer.run) I'm the leader.");
            this.messagesLock.lock();
            if (!this.clientsManager.havePendingRequests()) {
                this.haveMessages.awaitUninterruptibly();
            }
            this.messagesLock.unlock();
            Logger.println("(TOMLayer.run) There are messages to be ordered.");
            Logger.println("(TOMLayer.run) I can try to propose.");
            if (this.lm.getCurrentLeader() != this.reconfManager.getStaticConf().getProcessId() || !this.clientsManager.havePendingRequests() || this.getInExec() != -1) continue;
            int execId = this.getLastExec() + 1;
            this.setInExec(execId);
            Consensus cons = this.execManager.getExecution(execId).getLearner();
            if (this.reconfManager.getCurrentViewN() == 1) {
                Logger.println("(TOMLayer.run) Only one replica, bypassing consensus.");
                byte[] value = this.createPropose(cons);
                Execution execution = this.execManager.getExecution(cons.getId());
                Round round = execution.getRound(0, this.reconfManager);
                round.propValue = value;
                round.propValueHash = this.computeHash(value);
                round.getExecution().addWritten(value);
                round.deserializedPropValue = this.checkProposedValue(value, true);
                round.getExecution().getLearner().firstMessageProposed = round.deserializedPropValue[0];
                cons.decided(round);
                this.dt.delivery(cons);
                continue;
            }
            this.execManager.getProposer().startExecution(execId, this.createPropose(cons));
        }
    }

    public void decided(Consensus cons) {
        this.dt.delivery(cons);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TOMMessage[] checkProposedValue(byte[] proposedValue, boolean addToClientManager) {
        Logger.println("(TOMLayer.isProposedValueValid) starting");
        BatchReader batchReader = new BatchReader(proposedValue, this.reconfManager.getStaticConf().getUseSignatures() == 1);
        TOMMessage[] requests = null;
        try {
            requests = batchReader.deserialiseRequests(this.reconfManager);
            if (addToClientManager) {
                int i = 0;
                while (i < requests.length) {
                    if (!this.clientsManager.requestReceived(requests[i], false)) {
                        this.clientsManager.getClientsLock().unlock();
                        Logger.println("(TOMLayer.isProposedValueValid) finished, return=false");
                        System.out.println("failure in deserialize batch");
                        return null;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.clientsManager.getClientsLock().unlock();
            Logger.println("(TOMLayer.isProposedValueValid) finished, return=false");
            return null;
        }
        Logger.println("(TOMLayer.isProposedValueValid) finished, return=true");
        return requests;
    }

    public void forwardRequestToLeader(TOMMessage request) {
        int leaderId = this.lm.getCurrentLeader();
        if (this.reconfManager.isCurrentViewMember(leaderId)) {
            Logger.println("(TOMLayer.forwardRequestToLeader) forwarding " + request + " to " + leaderId);
            this.communication.send(new int[]{leaderId}, new ForwardedMessage(this.reconfManager.getStaticConf().getProcessId(), request));
        }
    }

    public boolean isRetrievingState() {
        boolean result = this.stateManager != null && this.stateManager.isRetrievingState();
        return result;
    }

    public void setNoExec() {
        Logger.println("(TOMLayer.setNoExec) modifying inExec from " + this.inExecution + " to " + -1);
        this.proposeLock.lock();
        this.inExecution = -1;
        this.canPropose.signalAll();
        this.proposeLock.unlock();
    }

    public void processOutOfContext() {
        int nextExecution = this.getLastExec() + 1;
        while (this.execManager.receivedOutOfContextPropose(nextExecution)) {
            this.execManager.processOutOfContextPropose(this.execManager.getExecution(nextExecution));
            nextExecution = this.getLastExec() + 1;
        }
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public LCManager getLCManager() {
        return this.lcManager;
    }

    public void triggerTimeout(List<TOMMessage> requestList) {
        ObjectOutputStream out = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.requestsTimer.stopTimer();
        this.requestsTimer.Enabled(false);
        if (this.lcManager.getNextReg() == this.lcManager.getLastReg()) {
            int regency;
            block14: {
                Logger.println("(TOMLayer.triggerTimeout) initialize synch phase");
                this.lcManager.setNextReg(this.lcManager.getLastReg() + 1);
                regency = this.lcManager.getNextReg();
                this.lcManager.setCurrentRequestTimedOut(requestList);
                this.lcManager.addStop(regency, this.reconfManager.getStaticConf().getProcessId());
                this.execManager.stop();
                try {
                    try {
                        out = new ObjectOutputStream(bos);
                        if (this.lcManager.getCurrentRequestTimedOut() != null) {
                            byte[] msgs = this.bb.makeBatch(this.lcManager.getCurrentRequestTimedOut(), 0, 0L, this.reconfManager);
                            out.writeBoolean(true);
                            out.writeObject(msgs);
                        } else {
                            out.writeBoolean(false);
                        }
                        byte[] payload = bos.toByteArray();
                        out.flush();
                        bos.flush();
                        out.close();
                        bos.close();
                        Logger.println("(TOMLayer.triggerTimeout) sending STOP message to install regency " + regency);
                        this.communication.send(this.reconfManager.getCurrentViewOtherAcceptors(), new LCMessage(this.reconfManager.getStaticConf().getProcessId(), 3, regency, payload));
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        java.util.logging.Logger.getLogger(TOMLayer.class.getName()).log(Level.SEVERE, null, ex);
                        try {
                            out.close();
                            bos.close();
                        }
                        catch (IOException ex2) {
                            ex2.printStackTrace();
                            java.util.logging.Logger.getLogger(TOMLayer.class.getName()).log(Level.SEVERE, null, ex2);
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        out.close();
                        bos.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        java.util.logging.Logger.getLogger(TOMLayer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    throw throwable;
                }
                try {
                    out.close();
                    bos.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    java.util.logging.Logger.getLogger(TOMLayer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.evaluateStops(regency);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void evaluateStops(int nextReg) {
        block47: {
            block48: {
                block46: {
                    enterFirstPhase = this.reconfManager.getStaticConf().isBFT();
                    condition = false;
                    out = null;
                    bos = null;
                    if (enterFirstPhase && this.lcManager.getStopsSize(nextReg) > this.reconfManager.getQuorumF() && this.lcManager.getNextReg() == this.lcManager.getLastReg()) {
                        Logger.println("(TOMLayer.evaluateStops) initialize synch phase");
                        this.requestsTimer.Enabled(false);
                        this.requestsTimer.stopTimer();
                        this.lcManager.setNextReg(this.lcManager.getLastReg() + 1);
                        regency = this.lcManager.getNextReg();
                        this.lcManager.addStop(regency, this.reconfManager.getStaticConf().getProcessId());
                        this.execManager.stop();
                        try {
                            try {
                                bos = new ByteArrayOutputStream();
                                out = new ObjectOutputStream(bos);
                                if (this.lcManager.getCurrentRequestTimedOut() != null) {
                                    out.writeBoolean(true);
                                    msgs = this.bb.makeBatch(this.lcManager.getCurrentRequestTimedOut(), 0, 0L, this.reconfManager);
                                    out.writeObject(msgs);
                                } else {
                                    out.writeBoolean(false);
                                }
                                out.flush();
                                bos.flush();
                                payload = bos.toByteArray();
                                out.close();
                                bos.close();
                                Logger.println("(TOMLayer.evaluateStops) sending STOP message to install regency " + regency);
                                this.communication.send(this.reconfManager.getCurrentViewOtherAcceptors(), new LCMessage(this.reconfManager.getStaticConf().getProcessId(), 3, regency, payload));
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                                java.util.logging.Logger.getLogger(TOMLayer.class.getName()).log(Level.SEVERE, null, ex);
                                try {
                                    out.close();
                                    bos.close();
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                    java.util.logging.Logger.getLogger(TOMLayer.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                break block46;
                            }
                        }
                        catch (Throwable var8_15) {
                            try {
                                out.close();
                                bos.close();
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                                java.util.logging.Logger.getLogger(TOMLayer.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            throw var8_15;
                        }
                        try {
                            out.close();
                            bos.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            java.util.logging.Logger.getLogger(TOMLayer.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                if (this.reconfManager.getStaticConf().isBFT()) {
                    condition = this.lcManager.getStopsSize(nextReg) > this.reconfManager.getCertificateQuorum() && this.lcManager.getNextReg() > this.lcManager.getLastReg();
                } else {
                    v0 = condition = this.lcManager.getStopsSize(nextReg) > this.reconfManager.getQuorumStrong() && this.lcManager.getNextReg() > this.lcManager.getLastReg();
                }
                if (!condition) break block47;
                Logger.println("(TOMLayer.evaluateStops) installing regency " + this.lcManager.getNextReg());
                this.lcManager.setLastReg(this.lcManager.getNextReg());
                regency = this.lcManager.getLastReg();
                this.lcManager.removeStops(nextReg);
                this.requestsTimer.Enabled(true);
                this.requestsTimer.setShortTimeout(-1L);
                this.requestsTimer.setTimeout(this.requestsTimer.getTimer() * 2L);
                this.requestsTimer.startTimer();
                leader = this.lcManager.getNewLeader();
                in = this.getInExec();
                last = this.getLastExec();
                this.lm.setNewLeader(leader);
                if (leader == this.reconfManager.getStaticConf().getProcessId()) break block48;
                try {
                    bos = new ByteArrayOutputStream();
                    out = new ObjectOutputStream(bos);
                    if (last <= -1) ** GOTO lbl102
                    out.writeBoolean(true);
                    out.writeInt(last);
                    exec = this.execManager.getExecution(last);
                    if (exec.getDecisionRound() == null || exec.getDecisionRound().propValue == null) {
                        System.out.println("[DEBUG INFO FOR LAST EID #1]");
                        if (exec.getDecisionRound() == null) {
                            System.out.println("No decision round for eid " + last);
                        } else {
                            System.out.println("round for eid: " + last + ": " + exec.getDecisionRound().toString());
                        }
                        if (exec.getDecisionRound().propValue == null) {
                            System.out.println("No propose for eid " + last);
                        } else {
                            System.out.println("Propose hash for eid " + last + ": " + Base64.encodeBase64String((byte[])this.computeHash(exec.getDecisionRound().propValue)));
                        }
                        return;
                    }
                    try {
                        block49: {
                            decision = exec.getDecisionRound().propValue;
                            proof = exec.getDecisionRound().getProof();
                            out.writeObject(decision);
                            out.writeObject(proof);
                            break block49;
lbl102:
                            // 1 sources

                            out.writeBoolean(false);
                        }
                        if (in > -1) {
                            exec = this.execManager.getExecution(in);
                            quorumWeaks = exec.getQuorumWeaks();
                            writeSet = exec.getWriteSet();
                            collect = new CollectData(this.reconfManager.getStaticConf().getProcessId(), in, quorumWeaks, writeSet);
                            signedCollect = this.sign(collect);
                            out.writeObject(signedCollect);
                        } else {
                            collect = new CollectData(this.reconfManager.getStaticConf().getProcessId(), -1, new TimestampValuePair(-1, new byte[0]), new HashSet<TimestampValuePair>());
                            signedCollect = this.sign(collect);
                            out.writeObject(signedCollect);
                        }
                        out.flush();
                        bos.flush();
                        payload = bos.toByteArray();
                        out.close();
                        bos.close();
                        b = new int[]{leader};
                        Logger.println("(TOMLayer.evaluateStops) sending STOPDATA of regency " + regency);
                        this.communication.send(b, new LCMessage(this.reconfManager.getStaticConf().getProcessId(), 4, regency, payload));
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        java.util.logging.Logger.getLogger(TOMLayer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                finally {
                    try {
                        out.close();
                        bos.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        java.util.logging.Logger.getLogger(TOMLayer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            Logger.println("(TOMLayer.evaluateStops) I'm the leader for this new regency");
            lastData = null;
            collect = null;
            if (last > -1) {
                exec = this.execManager.getExecution(last);
                if (exec.getDecisionRound() == null || exec.getDecisionRound().propValue == null) {
                    System.out.println("[DEBUG INFO FOR LAST EID #2]");
                    if (exec.getDecisionRound() == null) {
                        System.out.println("No decision round for eid " + last);
                    } else {
                        System.out.println("round for eid: " + last + ": " + exec.getDecisionRound().toString());
                    }
                    if (exec.getDecisionRound().propValue == null) {
                        System.out.println("No propose for eid " + last);
                    } else {
                        System.out.println("Propose hash for eid " + last + ": " + Base64.encodeBase64String((byte[])this.computeHash(exec.getDecisionRound().propValue)));
                    }
                    return;
                }
                decision = exec.getDecisionRound().propValue;
                proof = exec.getDecisionRound().getProof();
                lastData = new LastEidData(this.reconfManager.getStaticConf().getProcessId(), last, decision, proof);
            } else {
                lastData = new LastEidData(this.reconfManager.getStaticConf().getProcessId(), last, null, null);
            }
            this.lcManager.addLastEid(regency, lastData);
            if (in > -1) {
                exec = this.execManager.getExecution(in);
                quorumWeaks = exec.getQuorumWeaks();
                writeSet = exec.getWriteSet();
                collect = new CollectData(this.reconfManager.getStaticConf().getProcessId(), in, quorumWeaks, writeSet);
            } else {
                collect = new CollectData(this.reconfManager.getStaticConf().getProcessId(), -1, new TimestampValuePair(-1, new byte[0]), new HashSet<TimestampValuePair>());
            }
            signedCollect = this.sign(collect);
            this.lcManager.addCollect(regency, signedCollect);
        }
    }

    public void deliverTimeoutRequest(LCMessage msg) {
        ByteArrayInputStream bis = null;
        ObjectInputStream ois = null;
        switch (msg.getType()) {
            case 3: {
                if (msg.getReg() != this.lcManager.getLastReg() + 1) break;
                Logger.println("(TOMLayer.deliverTimeoutRequest) received regency change request");
                try {
                    bis = new ByteArrayInputStream(msg.getPayload());
                    ois = new ObjectInputStream(bis);
                    boolean hasReqs = ois.readBoolean();
                    this.clientsManager.getClientsLock().lock();
                    if (hasReqs) {
                        byte[] temp = (byte[])ois.readObject();
                        BatchReader batchReader = new BatchReader(temp, this.reconfManager.getStaticConf().getUseSignatures() == 1);
                        TOMMessage[] tOMMessageArray = batchReader.deserialiseRequests(this.reconfManager);
                    }
                    this.clientsManager.getClientsLock().unlock();
                    ois.close();
                    bis.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    java.util.logging.Logger.getLogger(TOMLayer.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                    java.util.logging.Logger.getLogger(TOMLayer.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.lcManager.addStop(msg.getReg(), msg.getSender());
                this.evaluateStops(msg.getReg());
                break;
            }
            case 4: {
                int regency = msg.getReg();
                if (regency != this.lcManager.getLastReg() || this.reconfManager.getStaticConf().getProcessId() != this.lm.getCurrentLeader()) break;
                Logger.println("(TOMLayer.deliverTimeoutRequest) I'm the new leader and I received a STOPDATA");
                LastEidData lastData = null;
                SignedObject signedCollect = null;
                int last = -1;
                byte[] lastValue = null;
                Set proof = null;
                try {
                    boolean conditionCFT;
                    bis = new ByteArrayInputStream(msg.getPayload());
                    ois = new ObjectInputStream(bis);
                    if (ois.readBoolean()) {
                        last = ois.readInt();
                        lastValue = (byte[])ois.readObject();
                        proof = (Set)ois.readObject();
                    }
                    lastData = new LastEidData(msg.getSender(), last, lastValue, proof);
                    this.lcManager.addLastEid(regency, lastData);
                    signedCollect = (SignedObject)ois.readObject();
                    ois.close();
                    bis.close();
                    this.lcManager.addCollect(regency, signedCollect);
                    int bizantineQuorum = (this.reconfManager.getCurrentViewN() + this.reconfManager.getCurrentViewF()) / 2;
                    int cftQuorum = this.reconfManager.getCurrentViewN() / 2;
                    boolean conditionBFT = this.reconfManager.getStaticConf().isBFT() && this.lcManager.getLastEidsSize(regency) > bizantineQuorum && this.lcManager.getCollectsSize(regency) > bizantineQuorum;
                    boolean bl = conditionCFT = this.lcManager.getLastEidsSize(regency) > cftQuorum && this.lcManager.getCollectsSize(regency) > cftQuorum;
                    if (!conditionBFT && !conditionCFT) break;
                    this.catch_up(regency);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace(System.err);
                }
                break;
            }
            case 5: {
                int regency = msg.getReg();
                if (msg.getReg() != this.lcManager.getLastReg() || msg.getReg() != this.lcManager.getNextReg() || msg.getSender() != this.lm.getCurrentLeader()) break;
                LastEidData lastHighestEid = null;
                int currentEid = -1;
                HashSet signedCollects = null;
                byte[] propose = null;
                int batchSize = -1;
                try {
                    bis = new ByteArrayInputStream(msg.getPayload());
                    ois = new ObjectInputStream(bis);
                    lastHighestEid = (LastEidData)ois.readObject();
                    currentEid = ois.readInt();
                    signedCollects = (HashSet)ois.readObject();
                    propose = (byte[])ois.readObject();
                    batchSize = ois.readInt();
                    this.lcManager.setCollects(regency, signedCollects);
                    if (this.lcManager.sound(this.lcManager.selectCollects(regency, currentEid))) {
                        this.finalise(regency, lastHighestEid, currentEid, signedCollects, propose, batchSize, false);
                    }
                    ois.close();
                    bis.close();
                    break;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    java.util.logging.Logger.getLogger(TOMLayer.class.getName()).log(Level.SEVERE, null, ex);
                    break;
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                    java.util.logging.Logger.getLogger(TOMLayer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private void catch_up(int regency) {
        Logger.println("(TOMLayer.catch_up) verify STOPDATA info");
        ObjectOutputStream out = null;
        ByteArrayOutputStream bos = null;
        LastEidData lastHighestEid = this.lcManager.getHighestLastEid(regency);
        int currentEid = lastHighestEid.getEid() + 1;
        HashSet<SignedObject> signedCollects = null;
        byte[] propose = null;
        int batchSize = -1;
        if (this.lcManager.sound(this.lcManager.selectCollects(regency, currentEid))) {
            Logger.println("(TOMLayer.catch_up) sound predicate is true");
            signedCollects = this.lcManager.getCollects(regency);
            Consensus cons = new Consensus(-1);
            propose = this.createPropose(cons);
            batchSize = cons.batchSize;
            try {
                try {
                    bos = new ByteArrayOutputStream();
                    out = new ObjectOutputStream(bos);
                    out.writeObject(lastHighestEid);
                    out.writeInt(currentEid);
                    out.writeObject(signedCollects);
                    out.writeObject(propose);
                    out.writeInt(batchSize);
                    out.flush();
                    bos.flush();
                    byte[] payload = bos.toByteArray();
                    out.close();
                    bos.close();
                    Logger.println("(TOMLayer.catch_up) sending SYNC message for regency " + regency);
                    this.communication.send(this.reconfManager.getCurrentViewOtherAcceptors(), new LCMessage(this.reconfManager.getStaticConf().getProcessId(), 5, regency, payload));
                    this.finalise(regency, lastHighestEid, currentEid, signedCollects, propose, batchSize, true);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    java.util.logging.Logger.getLogger(TOMLayer.class.getName()).log(Level.SEVERE, null, ex);
                    try {
                        out.close();
                        bos.close();
                    }
                    catch (IOException ex2) {
                        ex2.printStackTrace();
                        java.util.logging.Logger.getLogger(TOMLayer.class.getName()).log(Level.SEVERE, null, ex2);
                    }
                }
            }
            finally {
                try {
                    out.close();
                    bos.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    java.util.logging.Logger.getLogger(TOMLayer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public void resumeLC() {
        Execution exec = this.execManager.getExecution(this.tempLastHighestEid.getEid());
        Round r = exec.getLastRound();
        if (r == null) {
            r = exec.createRound(this.reconfManager);
        } else {
            r.clear();
        }
        byte[] hash = this.computeHash(this.tempLastHighestEid.getEidDecision());
        r.propValueHash = hash;
        r.propValue = this.tempLastHighestEid.getEidDecision();
        r.deserializedPropValue = this.checkProposedValue(this.tempLastHighestEid.getEidDecision(), false);
        this.finalise(this.tempRegency, this.tempLastHighestEid, this.tempCurrentEid, this.tempSignedCollects, this.tempPropose, this.tempBatchSize, this.tempIAmLeader);
    }

    private void finalise(int regency, LastEidData lastHighestEid, int currentEid, HashSet<SignedObject> signedCollects, byte[] propose, int batchSize, boolean iAmLeader) {
        Logger.println("(TOMLayer.finalise) final stage of LC protocol");
        int me = this.reconfManager.getStaticConf().getProcessId();
        Execution exec = null;
        Round r = null;
        if (this.getLastExec() + 1 < lastHighestEid.getEid()) {
            System.out.println("NEEDING TO USE STATE TRANSFER!! (" + lastHighestEid.getEid() + ")");
            this.tempRegency = regency;
            this.tempLastHighestEid = lastHighestEid;
            this.tempCurrentEid = currentEid;
            this.tempSignedCollects = signedCollects;
            this.tempPropose = propose;
            this.tempBatchSize = batchSize;
            this.tempIAmLeader = iAmLeader;
            this.execManager.getStoppedMsgs().add(this.acceptor.getFactory().createPropose(currentEid, 0, propose, null));
            this.stateManager.requestAppState(lastHighestEid.getEid());
            return;
        }
        if (this.getLastExec() + 1 == lastHighestEid.getEid()) {
            System.out.println("I'm still at the eid before the most recent one!!! (" + lastHighestEid.getEid() + ")");
            exec = this.execManager.getExecution(lastHighestEid.getEid());
            r = exec.getLastRound();
            if (r == null) {
                r = exec.createRound(this.reconfManager);
            } else {
                r.clear();
            }
            byte[] hash = this.computeHash(lastHighestEid.getEidDecision());
            r.propValueHash = hash;
            r.propValue = lastHighestEid.getEidDecision();
            r.deserializedPropValue = this.checkProposedValue(lastHighestEid.getEidDecision(), false);
            exec.decided(r, hash);
        }
        byte[] tmpval = null;
        HashSet<CollectData> selectedColls = this.lcManager.selectCollects(signedCollects, currentEid);
        tmpval = this.lcManager.getBindValue(selectedColls);
        if (tmpval == null && this.lcManager.unbound(selectedColls)) {
            Logger.println("(TOMLayer.finalise) did not found a value that might have already been decided");
            tmpval = propose;
        } else {
            Logger.println("(TOMLayer.finalise) found a value that might have been decided");
        }
        if (tmpval != null) {
            Logger.println("(TOMLayer.finalise) resuming normal phase");
            this.lcManager.removeCollects(regency);
            exec = this.execManager.getExecution(currentEid);
            exec.incEts();
            exec.removeWritten(tmpval);
            exec.addWritten(tmpval);
            r = exec.getLastRound();
            if (r == null) {
                r = exec.createRound(this.reconfManager);
            } else {
                r.clear();
            }
            byte[] hash = this.computeHash(tmpval);
            r.propValueHash = hash;
            r.propValue = tmpval;
            r.deserializedPropValue = this.checkProposedValue(tmpval, false);
            if (exec.getLearner().firstMessageProposed == null) {
                exec.getLearner().firstMessageProposed = r.deserializedPropValue != null && r.deserializedPropValue.length > 0 ? r.deserializedPropValue[0] : new TOMMessage();
            }
            r.setWeak(me, hash);
            this.execManager.restart();
            this.setInExec(currentEid);
            if (iAmLeader) {
                Logger.println("(TOMLayer.finalise) wake up proposer thread");
                this.imAmTheLeader();
            }
            Logger.println("(TOMLayer.finalise) sending WEAK message");
            this.communication.send(this.reconfManager.getCurrentViewOtherAcceptors(), this.acceptor.getFactory().createWeak(currentEid, r.getNumber(), r.propValueHash));
        } else {
            Logger.println("(TOMLayer.finalise) sync phase failed for regency" + regency);
        }
    }
}

