/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom.core;

import bftsmart.paxosatwar.Consensus;
import bftsmart.reconfiguration.ServerViewManager;
import bftsmart.statemanagement.ApplicationState;
import bftsmart.tom.MessageContext;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import bftsmart.tom.server.Recoverable;
import bftsmart.tom.util.BatchReader;
import bftsmart.tom.util.Logger;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class DeliveryThread
extends Thread {
    private LinkedBlockingQueue<Consensus> decided = new LinkedBlockingQueue();
    private TOMLayer tomLayer;
    private ServiceReplica receiver;
    private Recoverable recoverer;
    private ServerViewManager manager;
    private Lock decidedLock = new ReentrantLock();
    private Condition notEmptyQueue = this.decidedLock.newCondition();
    private ExecutorService execSvc = Executors.newFixedThreadPool(10);
    private ReentrantLock deliverLock = new ReentrantLock();
    private Condition canDeliver = this.deliverLock.newCondition();

    public DeliveryThread(TOMLayer tomLayer, ServiceReplica receiver, Recoverable recoverer, ServerViewManager manager) {
        super("Delivery Thread");
        this.tomLayer = tomLayer;
        this.receiver = receiver;
        this.recoverer = recoverer;
        this.manager = manager;
    }

    public Recoverable getRecoverer() {
        return this.recoverer;
    }

    public void delivery(Consensus cons) {
        if (!this.containsGoodReconfig(cons)) {
            Logger.println("(DeliveryThread.delivery) Consensus ID " + cons.getId() + " does not contain good reconfiguration");
            this.tomLayer.setLastExec(cons.getId());
            this.tomLayer.setInExec(-1);
        }
        try {
            this.decidedLock.lock();
            this.decided.put(cons);
            TOMMessage[] requests = this.extractMessagesFromDecision(cons);
            this.tomLayer.clientsManager.requestsOrdered(requests);
            this.notEmptyQueue.signalAll();
            this.decidedLock.unlock();
            Logger.println("(DeliveryThread.delivery) Consensus " + cons.getId() + " finished. Decided size=" + this.decided.size());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private boolean containsGoodReconfig(Consensus cons) {
        TOMMessage[] decidedMessages;
        TOMMessage[] tOMMessageArray = decidedMessages = cons.getDeserializedDecision();
        int n = decidedMessages.length;
        int n2 = 0;
        while (n2 < n) {
            TOMMessage decidedMessage = tOMMessageArray[n2];
            if (decidedMessage.getReqType() == TOMMessageType.RECONFIG && decidedMessage.getViewID() == this.manager.getCurrentViewId()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void deliverLock() {
        this.decidedLock.lock();
        this.notEmptyQueue.signalAll();
        this.decidedLock.unlock();
        this.deliverLock.lock();
    }

    public void deliverUnlock() {
        this.deliverLock.unlock();
    }

    public void canDeliver() {
        this.canDeliver.signalAll();
    }

    public void update(ApplicationState state) {
        int lastEid = this.recoverer.setState(state);
        System.out.println("Setting last EID to " + lastEid);
        this.tomLayer.setLastExec(lastEid);
        if (lastEid > 2) {
            int stableConsensus = lastEid - 3;
            this.tomLayer.execManager.removeOutOfContexts(stableConsensus);
        }
        this.tomLayer.setNoExec();
        System.out.print("Current decided size: " + this.decided.size());
        this.decided.clear();
        System.out.println("(DeliveryThread.update) All finished up to " + lastEid);
    }

    @Override
    public void run() {
        while (true) {
            this.deliverLock();
            while (this.tomLayer.isRetrievingState()) {
                System.out.println("(DeliveryThread.run) Retrieving State.");
                this.canDeliver.awaitUninterruptibly();
                System.out.println("(DeliveryThread.run) canDeliver unleashed.");
            }
            try {
                ArrayList consensuses = new ArrayList();
                this.decidedLock.lock();
                if (this.decided.isEmpty()) {
                    this.notEmptyQueue.await();
                }
                this.decided.drainTo(consensuses);
                this.decidedLock.unlock();
                if (consensuses.size() > 0) {
                    int eid;
                    TOMMessage[][] requests = new TOMMessage[consensuses.size()][];
                    int[] consensusIds = new int[requests.length];
                    int count = 0;
                    for (Consensus c : consensuses) {
                        requests[count] = this.extractMessagesFromDecision(c);
                        consensusIds[count] = c.getId();
                        if (requests[count][0].equals(c.firstMessageProposed)) {
                            long time = requests[count][0].timestamp;
                            requests[count][0] = c.firstMessageProposed;
                            requests[count][0].timestamp = time;
                        }
                        ++count;
                    }
                    Consensus lastConsensus = (Consensus)consensuses.get(consensuses.size() - 1);
                    if (requests != null && requests.length > 0) {
                        this.deliverMessages(consensusIds, this.tomLayer.getLCManager().getLastReg(), requests);
                        if (this.manager.hasUpdates()) {
                            this.processReconfigMessages(lastConsensus.getId(), lastConsensus.getDecisionRound().getNumber());
                            this.tomLayer.setLastExec(lastConsensus.getId());
                            this.tomLayer.setInExec(-1);
                        }
                    }
                    if ((eid = lastConsensus.getId()) > 2) {
                        int stableConsensus = eid - 3;
                        this.tomLayer.lm.removeStableConsenusInfos(stableConsensus);
                        this.tomLayer.execManager.removeExecution(stableConsensus);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.deliverUnlock();
        }
    }

    private TOMMessage[] extractMessagesFromDecision(Consensus cons) {
        TOMMessage[] requests = cons.getDeserializedDecision();
        if (requests == null) {
            Logger.println("(DeliveryThread.run) interpreting and verifying batched requests.");
            BatchReader batchReader = new BatchReader(cons.getDecision(), this.manager.getStaticConf().getUseSignatures() == 1);
            requests = batchReader.deserialiseRequests(this.manager);
        } else {
            Logger.println("(DeliveryThread.run) using cached requests from the propose.");
        }
        return requests;
    }

    protected void deliverUnordered(TOMMessage request, int regency) {
        MessageContext msgCtx = new MessageContext(System.currentTimeMillis(), new byte[0], regency, -1, request.getSender(), null);
        this.receiver.receiveReadonlyMessage(request, msgCtx);
    }

    private void deliverMessages(int[] consId, int regency, TOMMessage[][] requests) {
        this.receiver.receiveMessages(consId, regency, requests);
    }

    private void processReconfigMessages(int consId, int decisionRoundNumber) {
        byte[] response = this.manager.executeUpdates(consId, decisionRoundNumber);
        TOMMessage[] dests = this.manager.clearUpdates();
        int i = 0;
        while (i < dests.length) {
            this.tomLayer.getCommunication().send(new int[]{dests[i].getSender()}, new TOMMessage(this.manager.getStaticConf().getProcessId(), dests[i].getSession(), dests[i].getSequence(), response, this.manager.getCurrentViewId(), TOMMessageType.RECONFIG));
            ++i;
        }
        this.tomLayer.getCommunication().updateServersConnections();
    }
}

