/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom;

import bftsmart.communication.client.CommunicationSystemClientSide;
import bftsmart.communication.client.CommunicationSystemClientSideFactory;
import bftsmart.communication.client.ReplyReceiver;
import bftsmart.reconfiguration.ClientViewManager;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class TOMSender
implements ReplyReceiver {
    private int me;
    private ClientViewManager viewManager;
    private int session = 0;
    private int sequence = 0;
    private int unorderedMessageSequence = 0;
    private CommunicationSystemClientSide cs;
    private Lock lock = new ReentrantLock();
    private boolean useSignatures = false;
    private AtomicInteger opCounter = new AtomicInteger(0);

    public void close() {
        this.cs.close();
    }

    public CommunicationSystemClientSide getCommunicationSystem() {
        return this.cs;
    }

    public ClientViewManager getViewManager() {
        return this.viewManager;
    }

    public void init(int processId) {
        this.viewManager = new ClientViewManager(processId);
        this.startsCS();
    }

    public void init(int processId, String configHome) {
        this.viewManager = new ClientViewManager(processId, configHome);
        this.startsCS();
    }

    private void startsCS() {
        this.cs = CommunicationSystemClientSideFactory.getCommunicationSystemClientSide(this.viewManager);
        this.cs.setReplyReceiver(this);
        this.me = this.viewManager.getStaticConf().getProcessId();
        this.useSignatures = this.viewManager.getStaticConf().getUseSignatures() == 1;
        this.session = new Random().nextInt();
    }

    public int getProcessId() {
        return this.me;
    }

    public int generateRequestId(TOMMessageType type) {
        this.lock.lock();
        int id = type == TOMMessageType.ORDERED_REQUEST ? this.sequence++ : this.unorderedMessageSequence++;
        this.lock.unlock();
        return id;
    }

    public int generateOperationId() {
        return this.opCounter.getAndIncrement();
    }

    public void TOMulticast(TOMMessage sm) {
        this.cs.send(this.useSignatures, this.viewManager.getCurrentViewProcesses(), sm);
    }

    public void TOMulticast(byte[] m, int reqId, TOMMessageType reqType) {
        this.cs.send(this.useSignatures, this.viewManager.getCurrentViewProcesses(), new TOMMessage(this.me, this.session, reqId, m, this.viewManager.getCurrentViewId(), reqType));
    }

    public void TOMulticast(byte[] m, int reqId, int operationId, TOMMessageType reqType) {
        this.cs.send(this.useSignatures, this.viewManager.getCurrentViewProcesses(), new TOMMessage(this.me, this.session, reqId, operationId, m, this.viewManager.getCurrentViewId(), reqType));
    }

    public void sendMessageToTargets(byte[] m, int reqId, int[] targets, TOMMessageType type) {
        if (this.getViewManager().getStaticConf().isTheTTP()) {
            type = TOMMessageType.ASK_STATUS;
        }
        this.cs.send(this.useSignatures, targets, new TOMMessage(this.me, this.session, reqId, m, this.viewManager.getCurrentViewId(), type));
    }

    public void sendMessageToTargets(byte[] m, int reqId, int operationId, int[] targets, TOMMessageType type) {
        if (this.getViewManager().getStaticConf().isTheTTP()) {
            type = TOMMessageType.ASK_STATUS;
        }
        this.cs.send(this.useSignatures, targets, new TOMMessage(this.me, this.session, reqId, operationId, m, this.viewManager.getCurrentViewId(), type));
    }
}

