/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom;

import bftsmart.communication.ServerCommunicationSystem;
import bftsmart.paxosatwar.executionmanager.ExecutionManager;
import bftsmart.paxosatwar.executionmanager.LeaderModule;
import bftsmart.paxosatwar.messages.MessageFactory;
import bftsmart.paxosatwar.roles.Acceptor;
import bftsmart.paxosatwar.roles.Proposer;
import bftsmart.reconfiguration.Reconfiguration;
import bftsmart.reconfiguration.ReconfigureReply;
import bftsmart.reconfiguration.ServerViewManager;
import bftsmart.reconfiguration.TTPMessage;
import bftsmart.tom.MessageContext;
import bftsmart.tom.ReplicaContext;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import bftsmart.tom.server.BatchExecutable;
import bftsmart.tom.server.Executable;
import bftsmart.tom.server.FIFOExecutable;
import bftsmart.tom.server.Recoverable;
import bftsmart.tom.server.Replier;
import bftsmart.tom.server.SingleExecutable;
import bftsmart.tom.server.defaultservices.DefaultReplier;
import bftsmart.tom.util.Logger;
import bftsmart.tom.util.ShutdownHookThread;
import bftsmart.tom.util.TOMUtil;
import java.util.ArrayList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

public class ServiceReplica {
    private int id;
    private ServerCommunicationSystem cs = null;
    private ServerViewManager SVManager;
    private boolean isToJoin = false;
    private ReentrantLock waitTTPJoinMsgLock = new ReentrantLock();
    private Condition canProceed = this.waitTTPJoinMsgLock.newCondition();
    private Executable executor = null;
    private Recoverable recoverer = null;
    private TOMLayer tomLayer = null;
    private boolean tomStackCreated = false;
    private ReplicaContext replicaCtx = null;
    private Replier replier = null;

    public ServiceReplica(int id, Executable executor, Recoverable recoverer) {
        this(id, "", executor, recoverer);
    }

    public ServiceReplica(int id, String configHome, Executable executor, Recoverable recoverer) {
        this(id, configHome, false, executor, recoverer);
    }

    public ServiceReplica(int id, boolean isToJoin, Executable executor, Recoverable recoverer) {
        this(id, "", isToJoin, executor, recoverer);
    }

    public ServiceReplica(int id, String configHome, boolean isToJoin, Executable executor, Recoverable recoverer) {
        this.isToJoin = isToJoin;
        this.id = id;
        this.SVManager = new ServerViewManager(id, configHome);
        this.executor = executor;
        this.recoverer = recoverer;
        this.replier = new DefaultReplier();
        this.init();
        this.recoverer.setReplicaContext(this.replicaCtx);
        this.replier.setReplicaContext(this.replicaCtx);
    }

    public void setReplyController(Replier replier) {
        this.replier = replier;
    }

    private void init() {
        try {
            this.cs = new ServerCommunicationSystem(this.SVManager, this);
        }
        catch (Exception ex) {
            java.util.logging.Logger.getLogger(ServiceReplica.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException("Unable to build a communication system.");
        }
        if (this.SVManager.isInCurrentView()) {
            System.out.println("In current view: " + this.SVManager.getCurrentView());
            this.initTOMLayer(-1, -1);
        } else {
            System.out.println("Not in current view: " + this.SVManager.getCurrentView());
            if (this.isToJoin) {
                System.out.println("Sending join: " + this.SVManager.getCurrentView());
                int port = this.SVManager.getStaticConf().getServerToServerPort(this.id) - 1;
                String ip = this.SVManager.getStaticConf().getServerToServerRemoteAddress(this.id).getAddress().getHostAddress();
                ReconfigureReply r = null;
                Reconfiguration rec = new Reconfiguration(this.id);
                do {
                    rec.addServer(this.id, ip, port);
                } while (!(r = rec.execute()).getView().isMember(this.id));
                rec.close();
                this.SVManager.processJoinResult(r);
                this.initTOMLayer(r.getLastExecConsId(), r.getExecLeader());
                this.cs.updateServersConnections();
                this.cs.joinViewReceived();
            } else {
                System.out.println("Waiting for the TTP: " + this.SVManager.getCurrentView());
                this.waitTTPJoinMsgLock.lock();
                try {
                    this.canProceed.awaitUninterruptibly();
                }
                finally {
                    this.waitTTPJoinMsgLock.unlock();
                }
            }
        }
        this.initReplica();
    }

    public void joinMsgReceived(TTPMessage msg) {
        ReconfigureReply r = msg.getReply();
        if (r.getView().isMember(this.id)) {
            this.SVManager.processJoinResult(r);
            this.initTOMLayer(r.getLastExecConsId(), r.getExecLeader());
            this.cs.updateServersConnections();
            this.cs.joinViewReceived();
            this.waitTTPJoinMsgLock.lock();
            this.canProceed.signalAll();
            this.waitTTPJoinMsgLock.unlock();
        }
    }

    private void initReplica() {
        this.cs.start();
    }

    public final void receiveReadonlyMessage(TOMMessage message, MessageContext msgCtx) {
        byte[] response = null;
        response = this.executor instanceof FIFOExecutable ? ((FIFOExecutable)this.executor).executeUnorderedFIFO(message.getContent(), msgCtx, message.getSender(), message.getOperationId()) : this.executor.executeUnordered(message.getContent(), msgCtx);
        message.reply = new TOMMessage(this.id, message.getSession(), message.getSequence(), response, this.SVManager.getCurrentViewId(), TOMMessageType.UNORDERED_REQUEST);
        this.cs.send(new int[]{message.getSender()}, message.reply);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void receiveMessages(int[] consId, int regency, TOMMessage[][] requests) {
        TOMMessage request;
        int numRequests = 0;
        int consensusCount = 0;
        ArrayList<TOMMessage> toBatch = new ArrayList<TOMMessage>();
        ArrayList<MessageContext> msgCtxts = new ArrayList<MessageContext>();
        TOMMessage[][] tOMMessageArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            TOMMessage[] requestsFromConsensus = tOMMessageArray[n2];
            TOMMessage firstRequest = requestsFromConsensus[0];
            TOMMessage[] tOMMessageArray2 = requestsFromConsensus;
            int n3 = requestsFromConsensus.length;
            int n4 = 0;
            while (n4 < n3) {
                request = tOMMessageArray2[n4];
                if (request.getViewID() == this.SVManager.getCurrentViewId()) {
                    if (request.getReqType() == TOMMessageType.ORDERED_REQUEST) {
                        byte[] response;
                        ++numRequests;
                        MessageContext msgCtx = new MessageContext(firstRequest.timestamp, firstRequest.nonces, regency, consId[consensusCount], request.getSender(), firstRequest);
                        if (consensusCount + 1 == requestsFromConsensus.length) {
                            msgCtx.setLastInBatch();
                        }
                        request.deliveryTime = System.nanoTime();
                        if (this.executor instanceof BatchExecutable) {
                            msgCtxts.add(msgCtx);
                            toBatch.add(request);
                        } else if (this.executor instanceof FIFOExecutable) {
                            response = ((FIFOExecutable)this.executor).executeOrderedFIFO(request.getContent(), msgCtx, request.getSender(), request.getOperationId());
                            request.reply = new TOMMessage(this.id, request.getSession(), request.getSequence(), response, this.SVManager.getCurrentViewId());
                            Logger.println("(ServiceReplica.receiveMessages) sending reply to " + request.getSender());
                            this.replier.manageReply(request, msgCtx);
                        } else {
                            if (!(this.executor instanceof SingleExecutable)) throw new UnsupportedOperationException("Interface not existent");
                            response = ((SingleExecutable)this.executor).executeOrdered(request.getContent(), msgCtx);
                            request.reply = new TOMMessage(this.id, request.getSession(), request.getSequence(), response, this.SVManager.getCurrentViewId());
                            this.replier.manageReply(request, msgCtx);
                        }
                    } else {
                        if (request.getReqType() != TOMMessageType.RECONFIG) throw new RuntimeException("Should never reach here!");
                        this.SVManager.enqueueUpdate(request);
                    }
                } else if (request.getViewID() < this.SVManager.getCurrentViewId()) {
                    this.tomLayer.getCommunication().send(new int[]{request.getSender()}, new TOMMessage(this.SVManager.getStaticConf().getProcessId(), request.getSession(), request.getSequence(), TOMUtil.getBytes(this.SVManager.getCurrentView()), this.SVManager.getCurrentViewId()));
                }
                ++n4;
            }
            ++consensusCount;
            ++n2;
        }
        if (!(this.executor instanceof BatchExecutable) || numRequests <= 0) return;
        byte[][] batch = new byte[numRequests][];
        int line = 0;
        for (TOMMessage m : toBatch) {
            batch[line] = m.getContent();
            ++line;
        }
        MessageContext[] msgContexts = new MessageContext[msgCtxts.size()];
        msgContexts = msgCtxts.toArray(msgContexts);
        byte[][] replies = ((BatchExecutable)this.executor).executeBatch(batch, msgContexts);
        int index = 0;
        while (index < toBatch.size()) {
            request = (TOMMessage)toBatch.get(index);
            request.reply = new TOMMessage(this.id, request.getSession(), request.getSequence(), replies[index], this.SVManager.getCurrentViewId());
            this.cs.send(new int[]{request.getSender()}, request.reply);
            ++index;
        }
        Logger.println("BATCHEXECUTOR END");
    }

    public void leave() {
        ReconfigureReply r = null;
        Reconfiguration rec = new Reconfiguration(this.id);
        do {
            rec.removeServer(this.id);
        } while ((r = rec.execute()).getView().isMember(this.id));
        rec.close();
        this.cs.updateServersConnections();
    }

    private void initTOMLayer(int lastExec, int lastLeader) {
        if (this.tomStackCreated) {
            return;
        }
        if (!this.SVManager.isInCurrentView()) {
            throw new RuntimeException("I'm not an acceptor!");
        }
        MessageFactory messageFactory = new MessageFactory(this.id);
        LeaderModule lm = new LeaderModule();
        Acceptor acceptor = new Acceptor(this.cs, messageFactory, lm, this.SVManager);
        this.cs.setAcceptor(acceptor);
        Proposer proposer = new Proposer(this.cs, messageFactory, this.SVManager);
        ExecutionManager executionManager = new ExecutionManager(this.SVManager, acceptor, proposer, this.id);
        acceptor.setExecutionManager(executionManager);
        this.tomLayer = new TOMLayer(executionManager, this, this.recoverer, lm, acceptor, this.cs, this.SVManager);
        executionManager.setTOMLayer(this.tomLayer);
        this.SVManager.setTomLayer(this.tomLayer);
        this.cs.setTOMLayer(this.tomLayer);
        this.cs.setRequestReceiver(this.tomLayer);
        acceptor.setTOMLayer(this.tomLayer);
        if (this.SVManager.getStaticConf().isShutdownHookEnabled()) {
            Runtime.getRuntime().addShutdownHook(new ShutdownHookThread(this.cs, lm, acceptor, executionManager, this.tomLayer));
        }
        this.tomLayer.start();
        this.tomStackCreated = true;
        this.replicaCtx = new ReplicaContext(this.cs, this.SVManager);
    }

    public final ReplicaContext getReplicaContext() {
        return this.replicaCtx;
    }

    class MessageContextPair {
        TOMMessage message;
        MessageContext msgCtx;

        MessageContextPair(TOMMessage message, MessageContext msgCtx) {
            this.message = message;
            this.msgCtx = msgCtx;
        }
    }
}

