/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom;

import bftsmart.communication.client.ReplyListener;
import bftsmart.reconfiguration.ReconfigureReply;
import bftsmart.reconfiguration.StatusReply;
import bftsmart.reconfiguration.views.View;
import bftsmart.tom.TOMSender;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import bftsmart.tom.util.Extractor;
import bftsmart.tom.util.Logger;
import bftsmart.tom.util.TOMUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class ServiceProxy
extends TOMSender {
    private ReentrantLock canReceiveLock = new ReentrantLock();
    private ReentrantLock canSendLock = new ReentrantLock();
    private Semaphore sm = new Semaphore(0);
    private int reqId = -1;
    private int operationId = -1;
    private TOMMessageType requestType;
    private int replyQuorum = 0;
    private TOMMessage[] replies = null;
    private int receivedReplies = 0;
    private TOMMessage response = null;
    private int invokeTimeout = 40;
    private Comparator<byte[]> comparator;
    private Extractor extractor;
    private ReplyListener replyListener = null;

    public ServiceProxy(int processId) {
        this(processId, null, null, null);
    }

    public ServiceProxy(int processId, String configHome) {
        this(processId, configHome, null, null);
    }

    public ServiceProxy(int processId, String configHome, Comparator<byte[]> replyComparator, Extractor replyExtractor) {
        if (configHome == null) {
            this.init(processId);
        } else {
            this.init(processId, configHome);
        }
        this.replies = new TOMMessage[this.getViewManager().getCurrentViewN()];
        this.comparator = replyComparator != null ? replyComparator : new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                return Arrays.equals(o1, o2) ? 0 : -1;
            }
        };
        this.extractor = replyExtractor != null ? replyExtractor : new Extractor(){

            @Override
            public TOMMessage extractResponse(TOMMessage[] replies, int sameContent, int lastReceived) {
                return replies[lastReceived];
            }
        };
        this.replyListener = null;
    }

    public int getInvokeTimeout() {
        return this.invokeTimeout;
    }

    public void setInvokeTimeout(int invokeTimeout) {
        this.invokeTimeout = invokeTimeout;
    }

    public byte[] invokeOrdered(byte[] request) {
        return this.invoke(request, TOMMessageType.ORDERED_REQUEST);
    }

    public byte[] invokeUnordered(byte[] request) {
        return this.invoke(request, TOMMessageType.UNORDERED_REQUEST);
    }

    public void invokeAsynchronous(byte[] request, ReplyListener listener, int[] targets, TOMMessageType type) {
        this.canSendLock.lock();
        this.receivedReplies = 0;
        this.reqId = this.generateRequestId(type);
        this.operationId = this.generateOperationId();
        this.requestType = type;
        this.replyQuorum = this.getReplyQuorum();
        this.replyListener = listener;
        if (this.getViewManager().getStaticConf().isTheTTP()) {
            type = TOMMessageType.STATUS_REPLY;
            try {
                this.sendMessageToTargets(request, this.reqId, this.operationId, targets, type);
            }
            catch (RuntimeException re) {
                if (re.getMessage().equals("Server not connected")) {
                    TOMMessage tm = new TOMMessage(targets[0], 0, this.reqId, TOMUtil.getBytes(StatusReply.OFFLINE.toString()), 0, type);
                    listener.replyReceived(tm);
                }
            }
        } else {
            this.sendMessageToTargets(request, this.reqId, this.operationId, targets, type);
        }
        this.canSendLock.unlock();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] invoke(byte[] request, TOMMessageType reqType) {
        this.canSendLock.lock();
        Arrays.fill(this.replies, null);
        this.receivedReplies = 0;
        this.response = null;
        this.replyListener = null;
        this.replyQuorum = this.getReplyQuorum();
        this.reqId = this.generateRequestId(reqType);
        this.operationId = this.generateOperationId();
        this.requestType = reqType;
        this.TOMulticast(request, this.reqId, this.operationId, reqType);
        Logger.println("Sending request (" + (Object)((Object)reqType) + ") with reqId=" + this.reqId);
        Logger.println("Expected number of matching replies: " + this.replyQuorum);
        try {
            if (!this.sm.tryAcquire(this.invokeTimeout, TimeUnit.SECONDS)) {
                Logger.println("###################TIMEOUT#######################");
                Logger.println("Reply timeout for reqId=" + this.reqId);
                System.out.print(String.valueOf(this.getProcessId()) + " // " + this.reqId + " // TIMEOUT // ");
                System.out.println("Replies received: " + this.receivedReplies);
                this.canSendLock.unlock();
                return null;
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        Logger.println("Response extracted = " + this.response);
        byte[] ret = null;
        if (this.response == null) {
            Logger.println("Received n-f replies and no response could be extracted.");
            this.canSendLock.unlock();
            if (reqType == TOMMessageType.UNORDERED_REQUEST) {
                return this.invokeOrdered(request);
            }
            throw new RuntimeException("Received n-f replies without f+1 of them matching.");
        }
        if (reqType == TOMMessageType.ORDERED_REQUEST) {
            if (this.response.getViewID() != this.getViewManager().getCurrentViewId()) {
                this.reconfigureTo((View)TOMUtil.getObject(this.response.getContent()));
                this.canSendLock.unlock();
                return this.invoke(request, reqType);
            }
            ret = this.response.getContent();
        } else if (this.response.getViewID() > this.getViewManager().getCurrentViewId()) {
            Logger.println("Reconfiguration request' reply received!");
            Object r = TOMUtil.getObject(this.response.getContent());
            if (r instanceof View) {
                this.reconfigureTo((View)r);
                this.canSendLock.unlock();
                return this.invoke(request, reqType);
            }
            this.reconfigureTo(((ReconfigureReply)r).getView());
            ret = this.response.getContent();
        } else {
            ret = this.response.getContent();
        }
        this.canSendLock.unlock();
        return ret;
    }

    private void reconfigureTo(View v) {
        Logger.println("Installing a most up-to-date view with id=" + v.getId());
        this.getViewManager().reconfigureTo(v);
        this.replies = new TOMMessage[this.getViewManager().getCurrentViewN()];
        this.getCommunicationSystem().updateConnections();
    }

    @Override
    public void replyReceived(TOMMessage reply) {
        try {
            this.canReceiveLock.lock();
            if (this.reqId == -1) {
                Logger.println("throwing out request: sender=" + reply.getSender() + " reqId=" + reply.getSequence());
                this.canReceiveLock.unlock();
                return;
            }
            int pos = this.getViewManager().getCurrentViewPos(reply.getSender());
            if (pos < 0) {
                this.canReceiveLock.unlock();
                return;
            }
            if (reply.getSequence() == this.reqId && reply.getReqType() == this.requestType) {
                if (this.replyListener != null) {
                    this.replyListener.replyReceived(reply);
                    this.canReceiveLock.unlock();
                    return;
                }
                Logger.println("Receiving reply from " + reply.getSender() + " with reqId:" + reply.getSequence() + ". Putting on pos=" + pos);
                if (this.replies[pos] == null) {
                    ++this.receivedReplies;
                }
                this.replies[pos] = reply;
                int sameContent = 1;
                int i = 0;
                while (i < this.replies.length) {
                    if ((i != pos || this.getViewManager().getCurrentViewN() == 1) && this.replies[i] != null && this.comparator.compare(this.replies[i].getContent(), reply.getContent()) == 0 && ++sameContent >= this.replyQuorum) {
                        this.response = this.extractor.extractResponse(this.replies, sameContent, pos);
                        this.reqId = -1;
                        this.sm.release();
                        this.canReceiveLock.unlock();
                        return;
                    }
                    ++i;
                }
                if (this.response == null) {
                    if (this.requestType.equals((Object)TOMMessageType.ORDERED_REQUEST)) {
                        if (this.receivedReplies == this.getViewManager().getCurrentViewN()) {
                            this.reqId = -1;
                            this.sm.release();
                        }
                    } else if (this.receivedReplies != sameContent) {
                        this.reqId = -1;
                        this.sm.release();
                    }
                }
            }
            this.canReceiveLock.unlock();
        }
        catch (Exception ex) {
            System.out.println("Problem at ServiceProxy.ReplyReceived()");
            ex.printStackTrace();
            this.canReceiveLock.unlock();
        }
    }

    private int getReplyQuorum() {
        if (this.getViewManager().getStaticConf().isBFT()) {
            return (int)Math.ceil((this.getViewManager().getCurrentViewN() + this.getViewManager().getCurrentViewF()) / 2) + 1;
        }
        return (int)Math.ceil(this.getViewManager().getCurrentViewN() / 2) + 1;
    }
}

