/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom;

import bftsmart.communication.ServerCommunicationSystem;
import bftsmart.tom.MessageContext;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import bftsmart.tom.server.FIFOExecutable;

public class FIFOWorker
implements Runnable {
    private final TOMMessage message;
    private final MessageContext msgCtx;
    private final int clientId;
    private final int operationId;
    private final FIFOExecutable executor;
    private final ServerCommunicationSystem cs;
    private final int replicaId;
    private final int viewId;

    public FIFOWorker(int replicaId, int viewId, FIFOExecutable executor, ServerCommunicationSystem cs, TOMMessage message, MessageContext msgCtx, int clientId, int operationId) {
        this.executor = executor;
        this.cs = cs;
        this.message = message;
        this.msgCtx = msgCtx;
        this.clientId = clientId;
        this.operationId = operationId;
        this.replicaId = replicaId;
        this.viewId = viewId;
    }

    @Override
    public void run() {
        byte[] response = this.executor.executeUnorderedFIFO(this.message.getContent(), this.msgCtx, this.clientId, this.operationId);
        TOMMessage reply = new TOMMessage(this.replicaId, this.message.getSession(), this.message.getSequence(), response, this.viewId, TOMMessageType.UNORDERED_REQUEST);
        this.cs.send(new int[]{this.message.getSender()}, reply);
    }
}

