/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom;

import bftsmart.communication.ServerCommunicationSystem;
import bftsmart.tom.FIFOWorker;
import bftsmart.tom.MessageContext;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.server.FIFOExecutable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FIFODeliverer {
    private static volatile FIFODeliverer uniqueInstance;
    private final ExecutorService executorSvc;
    private FIFOExecutable executor;
    private ServerCommunicationSystem cs;
    private int replicaId;

    private FIFODeliverer() {
        this.executorSvc = null;
    }

    private FIFODeliverer(FIFOExecutable executor, ServerCommunicationSystem cs, int replicaId) {
        this.executorSvc = Executors.newCachedThreadPool();
        this.executor = executor;
        this.cs = cs;
        this.replicaId = replicaId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FIFODeliverer getInstance(FIFOExecutable executor, ServerCommunicationSystem cs, int replicaId) {
        if (uniqueInstance != null) return uniqueInstance;
        Class<FIFODeliverer> clazz = FIFODeliverer.class;
        synchronized (FIFODeliverer.class) {
            if (uniqueInstance != null) return uniqueInstance;
            uniqueInstance = new FIFODeliverer(executor, cs, replicaId);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return uniqueInstance;
        }
    }

    public byte[] executeOrdered(byte[] command, MessageContext msgCtx, int clientId, int operationId) {
        return this.executor.executeOrderedFIFO(command, msgCtx, clientId, operationId);
    }

    public void executeUnordered(int viewId, TOMMessage message, MessageContext msgCtx, int clientId, int operationId) {
        FIFOWorker worker = new FIFOWorker(this.replicaId, viewId, this.executor, this.cs, message, msgCtx, clientId, operationId);
        this.executorSvc.execute(worker);
    }
}

