/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.statemanagement.strategy.durability;

import bftsmart.statemanagement.ApplicationState;
import bftsmart.tom.server.defaultservices.CommandsInfo;

public class CSTState
implements ApplicationState {
    private static final long serialVersionUID = -7624656762922101703L;
    private final byte[] hashLogUpper;
    private final byte[] hashLogLower;
    private final byte[] hashCheckpoint;
    private final int checkpointEid;
    private final int lastEid;
    private final CommandsInfo[] logUpper;
    private final CommandsInfo[] logLower;
    private byte[] state;

    public CSTState(byte[] state, byte[] hashCheckpoint, CommandsInfo[] logLower, byte[] hashLogLower, CommandsInfo[] logUpper, byte[] hashLogUpper, int checkpointEid, int lastEid) {
        this.setSerializedState(state);
        this.hashLogUpper = hashLogUpper;
        this.hashLogLower = hashLogLower;
        this.hashCheckpoint = hashCheckpoint;
        this.logUpper = logUpper;
        this.logLower = logLower;
        this.checkpointEid = checkpointEid;
        this.lastEid = lastEid;
    }

    @Override
    public boolean hasState() {
        return this.getSerializedState() != null;
    }

    @Override
    public byte[] getSerializedState() {
        return this.state;
    }

    @Override
    public byte[] getStateHash() {
        return this.hashCheckpoint;
    }

    @Override
    public void setSerializedState(byte[] state) {
        this.state = state;
    }

    @Override
    public int getLastEid() {
        return this.lastEid;
    }

    public int getCheckpointEid() {
        return this.checkpointEid;
    }

    public CommandsInfo getMessageBatch(int eid) {
        if (eid >= this.checkpointEid && eid <= this.lastEid) {
            if (this.logLower != null) {
                return this.logLower[eid - this.checkpointEid - 1];
            }
            return this.logUpper[eid - this.checkpointEid - 1];
        }
        return null;
    }

    public byte[] getHashLogUpper() {
        return this.hashLogUpper;
    }

    public byte[] getHashLogLower() {
        return this.hashLogLower;
    }

    public CommandsInfo[] getLogUpper() {
        return this.logUpper;
    }

    public CommandsInfo[] getLogLower() {
        return this.logLower;
    }

    public byte[] getHashCheckpoint() {
        return this.hashCheckpoint;
    }
}

