/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.statemanagement.strategy;

import bftsmart.paxosatwar.executionmanager.ExecutionManager;
import bftsmart.paxosatwar.messages.PaxosMessage;
import bftsmart.reconfiguration.views.View;
import bftsmart.statemanagement.ApplicationState;
import bftsmart.statemanagement.SMMessage;
import bftsmart.statemanagement.strategy.BaseStateManager;
import bftsmart.statemanagement.strategy.StandardSMMessage;
import bftsmart.tom.core.DeliveryThread;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.leaderchange.LCManager;
import bftsmart.tom.util.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;

public class StandardStateManager
extends BaseStateManager {
    private int replica;
    private ReentrantLock lockTimer = new ReentrantLock();
    private Timer stateTimer = null;
    private static final long INIT_TIMEOUT = 40000L;
    private long timeout = 40000L;
    private DeliveryThread dt;
    private LCManager lcManager;
    private ExecutionManager execManager;

    @Override
    public void init(TOMLayer tomLayer, DeliveryThread dt) {
        this.SVManager = tomLayer.reconfManager;
        this.tomLayer = tomLayer;
        this.dt = dt;
        this.lcManager = tomLayer.getLCManager();
        this.execManager = tomLayer.execManager;
        this.replica = 0;
        if (this.SVManager.getCurrentViewN() > 1 && this.replica == this.SVManager.getStaticConf().getProcessId()) {
            this.changeReplica();
        }
        this.state = null;
        this.lastEid = 1;
        this.waitingEid = -1;
        this.appStateOnly = false;
    }

    private void changeReplica() {
        int pos = -1;
        do {
            pos = this.SVManager.getCurrentViewPos(this.replica);
            this.replica = this.SVManager.getCurrentViewProcesses()[(pos + 1) % this.SVManager.getCurrentViewN()];
        } while (this.replica == this.SVManager.getStaticConf().getProcessId());
    }

    @Override
    protected void requestState() {
        if (this.tomLayer.requestsTimer != null) {
            this.tomLayer.requestsTimer.clearAll();
        }
        StandardSMMessage smsg = new StandardSMMessage(this.SVManager.getStaticConf().getProcessId(), this.waitingEid, 6, this.replica, null, null, -1, -1);
        this.tomLayer.getCommunication().send(this.SVManager.getCurrentViewOtherAcceptors(), smsg);
        System.out.println("(StandardStateManager.requestState) I just sent a request to the other replicas for the state up to EID " + this.waitingEid);
        TimerTask stateTask = new TimerTask(){

            @Override
            public void run() {
                System.out.println("Timeout to retrieve state");
                int[] myself = new int[]{StandardStateManager.this.SVManager.getStaticConf().getProcessId()};
                StandardStateManager.this.tomLayer.getCommunication().send(myself, new StandardSMMessage(-1, StandardStateManager.this.waitingEid, 9, -1, null, null, -1, -1));
            }
        };
        this.stateTimer = new Timer("state timer");
        this.timeout *= 2L;
        this.stateTimer.schedule(stateTask, this.timeout);
    }

    @Override
    public void stateTimeout() {
        this.lockTimer.lock();
        Logger.println("(StateManager.stateTimeout) Timeout for the replica that was supposed to send the complete state. Changing desired replica.");
        System.out.println("Timeout no timer do estado!");
        if (this.stateTimer != null) {
            this.stateTimer.cancel();
        }
        this.changeReplica();
        this.reset();
        this.requestState();
        this.lockTimer.unlock();
    }

    @Override
    public void SMRequestDeliver(SMMessage msg, boolean isBFT) {
        if (this.SVManager.getStaticConf().isStateTransferEnabled() && this.dt.getRecoverer() != null) {
            StandardSMMessage stdMsg = (StandardSMMessage)msg;
            boolean sendState = stdMsg.getReplica() == this.SVManager.getStaticConf().getProcessId();
            ApplicationState thisState = this.dt.getRecoverer().getState(msg.getEid(), sendState);
            if (thisState == null) {
                thisState = this.dt.getRecoverer().getState(-1, sendState);
            }
            int[] targets = new int[]{msg.getSender()};
            StandardSMMessage smsg = new StandardSMMessage(this.SVManager.getStaticConf().getProcessId(), msg.getEid(), 7, -1, thisState, this.SVManager.getCurrentView(), this.lcManager.getLastReg(), this.tomLayer.lm.getCurrentLeader());
            System.out.println("Sending state");
            this.tomLayer.getCommunication().send(targets, smsg);
            System.out.println("Sent");
        }
    }

    @Override
    public void SMReplyDeliver(SMMessage msg, boolean isBFT) {
        this.lockTimer.lock();
        if (this.SVManager.getStaticConf().isStateTransferEnabled() && this.waitingEid != -1 && msg.getEid() == this.waitingEid) {
            int currentRegency = -1;
            int currentLeader = -1;
            View currentView = null;
            if (!this.appStateOnly) {
                this.senderRegencies.put(msg.getSender(), msg.getRegency());
                this.senderLeaders.put(msg.getSender(), msg.getLeader());
                this.senderViews.put(msg.getSender(), msg.getView());
                if (this.moreThan2F_Regencies(msg.getRegency())) {
                    currentRegency = msg.getRegency();
                }
                if (this.moreThan2F_Leaders(msg.getLeader())) {
                    currentLeader = msg.getLeader();
                }
                if (this.moreThan2F_Views(msg.getView())) {
                    currentView = msg.getView();
                }
            } else {
                currentLeader = this.tomLayer.lm.getCurrentLeader();
                currentRegency = this.lcManager.getLastReg();
                currentView = this.SVManager.getCurrentView();
            }
            if (msg.getSender() == this.replica && msg.getState().getSerializedState() != null) {
                System.out.println("Expected replica sent state. Setting it to state");
                this.state = msg.getState();
                if (this.stateTimer != null) {
                    this.stateTimer.cancel();
                }
            }
            this.senderStates.put(msg.getSender(), msg.getState());
            System.out.println("Verifying more than F replies");
            if (this.moreThanF_Replies()) {
                System.out.println("More than F confirmed");
                ApplicationState otherReplicaState = this.getOtherReplicaState();
                System.out.println("State != null: " + (this.state != null) + ", recvState != null: " + (otherReplicaState != null));
                int haveState = 0;
                if (this.state != null) {
                    byte[] hash = null;
                    hash = this.tomLayer.computeHash(this.state.getSerializedState());
                    if (otherReplicaState != null) {
                        if (Arrays.equals(hash, otherReplicaState.getStateHash())) {
                            haveState = 1;
                        } else if (this.getNumEqualStates() > this.SVManager.getCurrentViewF()) {
                            haveState = -1;
                        }
                    }
                }
                System.out.println("haveState: " + haveState);
                if (otherReplicaState != null && haveState == 1 && currentRegency > -1 && currentLeader > -1 && currentView != null) {
                    System.out.println("Received state. Will install it");
                    this.lcManager.setLastReg(currentRegency);
                    this.lcManager.setNextReg(currentRegency);
                    this.lcManager.setNewLeader(currentLeader);
                    this.tomLayer.lm.setNewLeader(currentLeader);
                    this.dt.deliverLock();
                    this.waitingEid = -1;
                    this.dt.update(this.state);
                    if (!this.appStateOnly && this.execManager.stopped()) {
                        Queue<PaxosMessage> stoppedMsgs = this.execManager.getStoppedMsgs();
                        for (PaxosMessage stopped : stoppedMsgs) {
                            if (stopped.getNumber() <= this.state.getLastEid()) continue;
                            this.execManager.addOutOfContextMessage(stopped);
                        }
                        this.execManager.clearStopped();
                        this.execManager.restart();
                    }
                    this.tomLayer.processOutOfContext();
                    if (this.SVManager.getCurrentViewId() != currentView.getId()) {
                        System.out.println("Installing current view!");
                        this.SVManager.reconfigureTo(currentView);
                    }
                    this.dt.canDeliver();
                    this.dt.deliverUnlock();
                    this.reset();
                    System.out.println("I updated the state!");
                    this.tomLayer.requestsTimer.Enabled(true);
                    this.tomLayer.requestsTimer.startTimer();
                    if (this.stateTimer != null) {
                        this.stateTimer.cancel();
                    }
                    if (this.appStateOnly) {
                        this.appStateOnly = false;
                        this.tomLayer.resumeLC();
                    }
                } else if (otherReplicaState == null && this.SVManager.getCurrentViewN() / 2 < this.getReplies()) {
                    this.waitingEid = -1;
                    this.reset();
                    if (this.stateTimer != null) {
                        this.stateTimer.cancel();
                    }
                    if (this.appStateOnly) {
                        this.requestState();
                    }
                } else if (haveState == -1) {
                    Logger.println("(TOMLayer.SMReplyDeliver) The replica from which I expected the state, sent one which doesn't match the hash of the others, or it never sent it at all");
                    this.changeReplica();
                    this.reset();
                    this.requestState();
                    if (this.stateTimer != null) {
                        this.stateTimer.cancel();
                    }
                }
            }
        }
        this.lockTimer.unlock();
    }

    private ApplicationState getOtherReplicaState() {
        int[] processes;
        int[] nArray = processes = this.SVManager.getCurrentViewProcesses();
        int n = processes.length;
        int n2 = 0;
        while (n2 < n) {
            ApplicationState otherState;
            int process = nArray[n2];
            if (process != this.replica && (otherState = (ApplicationState)this.senderStates.get(process)) != null) {
                return otherState;
            }
            ++n2;
        }
        return null;
    }

    private int getNumEqualStates() {
        ArrayList<ApplicationState> states = new ArrayList<ApplicationState>(this.receivedStates());
        int match = 0;
        for (ApplicationState st1 : states) {
            int count = 0;
            for (ApplicationState st2 : states) {
                if (st1 == null || !st1.equals(st2)) continue;
                ++count;
            }
            if (count <= match) continue;
            match = count;
        }
        return match;
    }
}

