/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.statemanagement.strategy;

import bftsmart.reconfiguration.ServerViewManager;
import bftsmart.reconfiguration.views.View;
import bftsmart.statemanagement.ApplicationState;
import bftsmart.statemanagement.SMMessage;
import bftsmart.statemanagement.StateManager;
import bftsmart.tom.core.DeliveryThread;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.util.Logger;
import java.util.Collection;
import java.util.HashMap;

public abstract class BaseStateManager
implements StateManager {
    protected TOMLayer tomLayer;
    protected ServerViewManager SVManager;
    protected HashMap<Integer, ApplicationState> senderStates = new HashMap();
    protected HashMap<Integer, View> senderViews = new HashMap();
    protected HashMap<Integer, Integer> senderRegencies = new HashMap();
    protected HashMap<Integer, Integer> senderLeaders = new HashMap();
    protected boolean appStateOnly;
    protected int waitingEid = -1;
    protected int lastEid;
    protected ApplicationState state;

    protected int getReplies() {
        return this.senderStates.size();
    }

    protected boolean moreThanF_Replies() {
        return this.senderStates.size() > this.SVManager.getCurrentViewF();
    }

    protected boolean moreThan2F_Regencies(int regency) {
        return this.senderRegencies.size() > this.SVManager.getQuorumStrong();
    }

    protected boolean moreThan2F_Leaders(int leader) {
        return this.senderLeaders.size() > this.SVManager.getQuorumStrong();
    }

    protected boolean moreThan2F_Views(View view) {
        Collection<View> views = this.senderViews.values();
        int counter = 0;
        for (View v : views) {
            if (!view.equals(v)) continue;
            ++counter;
        }
        boolean result = counter > this.SVManager.getQuorumStrong();
        views = null;
        return result;
    }

    protected void reset() {
        this.senderStates.clear();
        this.senderLeaders.clear();
        this.senderRegencies.clear();
        this.senderViews.clear();
        this.state = null;
    }

    public Collection<ApplicationState> receivedStates() {
        return this.senderStates.values();
    }

    public void setLastEID(int eid) {
        this.lastEid = eid;
    }

    public int getLastEID() {
        return this.lastEid;
    }

    @Override
    public void requestAppState(int eid) {
        this.lastEid = eid + 1;
        this.waitingEid = eid;
        System.out.println("waitingeid is now " + eid);
        this.appStateOnly = true;
        this.requestState();
    }

    @Override
    public void analyzeState(int eid) {
        Logger.println("(TOMLayer.analyzeState) The state transfer protocol is enabled");
        if (this.waitingEid == -1) {
            Logger.println("(TOMLayer.analyzeState) I'm not waiting for any state, so I will keep record of this message");
            if (this.tomLayer.execManager.isDecidable(eid)) {
                System.out.println("BaseStateManager.analyzeState: I have now more than " + this.SVManager.getCurrentViewF() + " messages for EID " + eid + " which are beyond EID " + this.lastEid);
                this.lastEid = eid;
                this.waitingEid = eid - 1;
                System.out.println("analyzeState " + this.waitingEid);
                this.requestState();
            }
        }
    }

    @Override
    public abstract void init(TOMLayer var1, DeliveryThread var2);

    @Override
    public boolean isRetrievingState() {
        return this.waitingEid > -1;
    }

    protected abstract void requestState();

    @Override
    public abstract void stateTimeout();

    @Override
    public abstract void SMRequestDeliver(SMMessage var1, boolean var2);

    @Override
    public abstract void SMReplyDeliver(SMMessage var1, boolean var2);
}

