/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.statemanagement;

import bftsmart.communication.SystemMessage;
import bftsmart.reconfiguration.views.View;
import bftsmart.statemanagement.ApplicationState;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class SMMessage
extends SystemMessage
implements Externalizable {
    private ApplicationState state;
    private View view;
    private int eid;
    private int type;
    private int regency;
    private int leader;
    public final boolean TRIGGER_SM_LOCALLY;

    protected SMMessage(int sender, int eid, int type, ApplicationState state, View view, int regency, int leader) {
        super(sender);
        this.state = state;
        this.view = view;
        this.eid = eid;
        this.type = type;
        this.sender = sender;
        this.regency = regency;
        this.leader = leader;
        this.TRIGGER_SM_LOCALLY = type == 9 && sender == -1;
    }

    protected SMMessage() {
        this.TRIGGER_SM_LOCALLY = false;
    }

    public ApplicationState getState() {
        return this.state;
    }

    public View getView() {
        return this.view;
    }

    public int getType() {
        return this.type;
    }

    public int getEid() {
        return this.eid;
    }

    public int getRegency() {
        return this.regency;
    }

    public int getLeader() {
        return this.leader;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.sender);
        out.writeInt(this.eid);
        out.writeInt(this.type);
        out.writeInt(this.regency);
        out.writeInt(this.leader);
        out.writeObject(this.state);
        out.writeObject(this.view);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sender = in.readInt();
        this.eid = in.readInt();
        this.type = in.readInt();
        this.regency = in.readInt();
        this.leader = in.readInt();
        this.state = (ApplicationState)in.readObject();
        this.view = (View)in.readObject();
    }
}

