/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.reconfiguration.util;

import bftsmart.reconfiguration.util.Configuration;
import bftsmart.reconfiguration.util.RSAKeyLoader;
import bftsmart.tom.util.Logger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.StringTokenizer;

public class TOMConfiguration
extends Configuration {
    protected int n;
    protected int f;
    protected int requestTimeout;
    protected int tomPeriod;
    protected int paxosHighMark;
    protected int revivalHighMark;
    protected int timeoutHighMark;
    protected int replyVerificationTime;
    protected int maxBatchSize;
    protected int numberOfNonces;
    protected int inQueueSize;
    protected int outQueueSize;
    protected boolean shutdownHookEnabled;
    protected boolean useSenderThread;
    protected RSAKeyLoader rsaLoader;
    private int debug;
    private int numNIOThreads;
    private int useMACs;
    private int useSignatures;
    private boolean stateTransferEnabled;
    private int checkpointPeriod;
    private int globalCheckpointPeriod;
    private int useControlFlow;
    private int[] initialView;
    private int ttpId;
    private boolean isToLog;
    private boolean syncLog;
    private boolean parallelLog;
    private boolean logToDisk;
    private boolean isToWriteCkpsToDisk;
    private boolean syncCkp;
    private boolean isBFT;

    public TOMConfiguration(int processId) {
        super(processId);
    }

    public TOMConfiguration(int processId, String configHome) {
        super(processId, configHome);
    }

    public TOMConfiguration(int processId, String configHome, String hostsFileName) {
        super(processId, configHome, hostsFileName);
    }

    @Override
    protected void init() {
        super.init();
        try {
            this.n = Integer.parseInt(((String)this.configs.remove("system.servers.num")).toString());
            String s = (String)this.configs.remove("system.servers.f");
            this.f = s == null ? (int)Math.ceil((this.n - 1) / 3) : Integer.parseInt(s);
            s = (String)this.configs.remove("system.shutdownhook");
            this.shutdownHookEnabled = s != null ? Boolean.parseBoolean(s) : false;
            s = (String)this.configs.remove("system.totalordermulticast.period");
            this.tomPeriod = s == null ? this.n * 5 : Integer.parseInt(s);
            s = (String)this.configs.remove("system.totalordermulticast.timeout");
            if (s == null) {
                this.requestTimeout = 10000;
            } else {
                this.requestTimeout = Integer.parseInt(s);
                if (this.requestTimeout < 0) {
                    this.requestTimeout = 0;
                }
            }
            s = (String)this.configs.remove("system.totalordermulticast.highMark");
            if (s == null) {
                this.paxosHighMark = 10000;
            } else {
                this.paxosHighMark = Integer.parseInt(s);
                if (this.paxosHighMark < 10) {
                    this.paxosHighMark = 10;
                }
            }
            s = (String)this.configs.remove("system.totalordermulticast.revival_highMark");
            if (s == null) {
                this.revivalHighMark = 10;
            } else {
                this.revivalHighMark = Integer.parseInt(s);
                if (this.revivalHighMark < 1) {
                    this.revivalHighMark = 1;
                }
            }
            s = (String)this.configs.remove("system.totalordermulticast.timeout_highMark");
            if (s == null) {
                this.timeoutHighMark = 100;
            } else {
                this.timeoutHighMark = Integer.parseInt(s);
                if (this.timeoutHighMark < 1) {
                    this.timeoutHighMark = 1;
                }
            }
            s = (String)this.configs.remove("system.totalordermulticast.maxbatchsize");
            this.maxBatchSize = s == null ? 100 : Integer.parseInt(s);
            s = (String)this.configs.remove("system.debug");
            if (s == null) {
                Logger.debug = false;
            } else {
                this.debug = Integer.parseInt(s);
                Logger.debug = this.debug != 0;
            }
            s = (String)this.configs.remove("system.totalordermulticast.replayVerificationTime");
            this.replyVerificationTime = s == null ? 0 : Integer.parseInt(s);
            s = (String)this.configs.remove("system.totalordermulticast.nonces");
            this.numberOfNonces = s == null ? 0 : Integer.parseInt(s);
            s = (String)this.configs.remove("system.communication.useSenderThread");
            this.useSenderThread = s == null ? false : Boolean.parseBoolean(s);
            s = (String)this.configs.remove("system.communication.numNIOThreads");
            this.numNIOThreads = s == null ? 2 : Integer.parseInt(s);
            s = (String)this.configs.remove("system.communication.useMACs");
            this.useMACs = s == null ? 0 : Integer.parseInt(s);
            s = (String)this.configs.remove("system.communication.useSignatures");
            this.useSignatures = s == null ? 0 : Integer.parseInt(s);
            s = (String)this.configs.remove("system.totalordermulticast.state_transfer");
            this.stateTransferEnabled = s == null ? false : Boolean.parseBoolean(s);
            s = (String)this.configs.remove("system.totalordermulticast.checkpoint_period");
            this.checkpointPeriod = s == null ? 1 : Integer.parseInt(s);
            s = (String)this.configs.remove("system.communication.useControlFlow");
            this.useControlFlow = s == null ? 0 : Integer.parseInt(s);
            s = (String)this.configs.remove("system.initial.view");
            if (s == null) {
                this.initialView = new int[this.n];
                int i = 0;
                while (i < this.n) {
                    this.initialView[i] = i;
                    ++i;
                }
            } else {
                StringTokenizer str = new StringTokenizer(s, ",");
                this.initialView = new int[str.countTokens()];
                int i = 0;
                while (i < this.initialView.length) {
                    this.initialView[i] = Integer.parseInt(str.nextToken());
                    ++i;
                }
            }
            s = (String)this.configs.remove("system.ttp.id");
            this.ttpId = s == null ? -1 : Integer.parseInt(s);
            s = (String)this.configs.remove("system.communication.inQueueSize");
            if (s == null) {
                this.inQueueSize = 1000;
            } else {
                this.inQueueSize = Integer.parseInt(s);
                if (this.inQueueSize < 1) {
                    this.inQueueSize = 1000;
                }
            }
            s = (String)this.configs.remove("system.communication.outQueueSize");
            if (s == null) {
                this.outQueueSize = 1000;
            } else {
                this.outQueueSize = Integer.parseInt(s);
                if (this.outQueueSize < 1) {
                    this.outQueueSize = 1000;
                }
            }
            s = (String)this.configs.remove("system.totalordermulticast.log");
            this.isToLog = s != null ? Boolean.parseBoolean(s) : false;
            s = (String)this.configs.remove("system.totalordermulticast.log_parallel");
            this.parallelLog = s != null ? Boolean.parseBoolean(s) : false;
            s = (String)this.configs.remove("system.totalordermulticast.log_to_disk");
            this.logToDisk = s != null ? Boolean.parseBoolean(s) : false;
            s = (String)this.configs.remove("system.totalordermulticast.sync_log");
            this.syncLog = s != null ? Boolean.parseBoolean(s) : false;
            s = (String)this.configs.remove("system.totalordermulticast.checkpoint_to_disk");
            this.isToWriteCkpsToDisk = s == null ? false : Boolean.parseBoolean(s);
            s = (String)this.configs.remove("system.totalordermulticast.sync_ckp");
            this.syncCkp = s == null ? false : Boolean.parseBoolean(s);
            s = (String)this.configs.remove("system.totalordermulticast.global_checkpoint_period");
            this.globalCheckpointPeriod = s == null ? 1 : Integer.parseInt(s);
            this.rsaLoader = new RSAKeyLoader(configHome);
            s = (String)this.configs.remove("system.bft");
            this.isBFT = s != null ? Boolean.parseBoolean(s) : true;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public String getViewStoreClass() {
        String s = (String)this.configs.remove("view.storage.handler");
        if (s == null) {
            return "bftsmart.reconfiguration.views.DefaultViewStorage";
        }
        return s;
    }

    public boolean isTheTTP() {
        return this.getTTPId() == this.getProcessId();
    }

    public final int[] getInitialView() {
        return this.initialView;
    }

    public int getTTPId() {
        return this.ttpId;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public int getReplyVerificationTime() {
        return this.replyVerificationTime;
    }

    public int getN() {
        return this.n;
    }

    public int getF() {
        return this.f;
    }

    public int getPaxosHighMark() {
        return this.paxosHighMark;
    }

    public int getRevivalHighMark() {
        return this.revivalHighMark;
    }

    public int getTimeoutHighMark() {
        return this.timeoutHighMark;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public boolean isShutdownHookEnabled() {
        return this.shutdownHookEnabled;
    }

    public boolean isStateTransferEnabled() {
        return this.stateTransferEnabled;
    }

    public int getInQueueSize() {
        return this.inQueueSize;
    }

    public int getOutQueueSize() {
        return this.outQueueSize;
    }

    public boolean isUseSenderThread() {
        return this.useSenderThread;
    }

    public int getNumberOfNIOThreads() {
        return this.numNIOThreads;
    }

    public int getNumberOfNonces() {
        return this.numberOfNonces;
    }

    public int getUseSignatures() {
        return this.useSignatures;
    }

    public int getUseMACs() {
        return this.useMACs;
    }

    public int getCheckpointPeriod() {
        return this.checkpointPeriod;
    }

    public boolean isToWriteCkpsToDisk() {
        return this.isToWriteCkpsToDisk;
    }

    public boolean isToWriteSyncCkp() {
        return this.syncCkp;
    }

    public boolean isToLog() {
        return this.isToLog;
    }

    public boolean isToWriteSyncLog() {
        return this.syncLog;
    }

    public boolean logToDisk() {
        return this.logToDisk;
    }

    public boolean isToLogParallel() {
        return this.parallelLog;
    }

    public int getGlobalCheckpointPeriod() {
        return this.globalCheckpointPeriod;
    }

    public int getUseControlFlow() {
        return this.useControlFlow;
    }

    public PublicKey getRSAPublicKey() {
        try {
            return this.rsaLoader.loadPublicKey();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public PrivateKey getRSAPrivateKey() {
        try {
            return this.rsaLoader.loadPrivateKey();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public boolean isBFT() {
        if (this.isBFT) {
            Logger.println("----------------ISBFT--------------");
        } else {
            Logger.println("----------------ISCFT---------------");
        }
        return this.isBFT;
    }
}

